/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.queryeditor.workitem;

import com.ibm.icu.text.Collator;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.process.common.ITeamAreaHandle;
import com.ibm.team.process.common.ITeamAreaHierarchy;
import com.ibm.team.process.rcp.ui.teamnavigator.ConnectedProjectAreaRegistry;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.workitem.client.IAuditableClient;
import com.ibm.team.workitem.client.internal.util.ClientUtils;
import com.ibm.team.workitem.common.model.ItemProfile;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.control.IInputProvider;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.util.ExcludingViewerFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class ProcessAreaProviders {
    public static IInputProvider createInputProvider(ContentMode contentMode, ProjectMode projectMode) {
        return new ProcessAreaInputProvider(contentMode, projectMode);
    }

    public static ITreeContentProvider createContentProvider() {
        return new ProcessAreaContentProvider();
    }

    public static ProcessAreaFilter createFilter() {
        return new ProcessAreaFilter();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ContentMode {
        TEAM_AREA,
        PROCESS_AREA,
        PROJECT_AREA;

    }

    private static class ProcessAreaContentProvider
    implements ITreeContentProvider {
        private ProcessAreaTree fProcessAreaTree;

        private ProcessAreaContentProvider() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            if (newInput == null) {
                this.fProcessAreaTree = null;
            } else if (newInput instanceof ProcessAreaTree) {
                this.fProcessAreaTree = (ProcessAreaTree)newInput;
            }
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof IProcessAreaHandle) {
                IProcessAreaHandle parent = (IProcessAreaHandle)parentElement;
                return this.fProcessAreaTree.getChildren(parent).toArray();
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            if (element instanceof ITeamAreaHandle) {
                ITeamAreaHandle child = (ITeamAreaHandle)element;
                return this.fProcessAreaTree.getParent(child);
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof IProcessAreaHandle) {
                IProcessAreaHandle parent = (IProcessAreaHandle)element;
                return this.fProcessAreaTree.hasChildren(parent);
            }
            return false;
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof ProcessAreaTree) {
                Assert.isTrue((inputElement == this.fProcessAreaTree ? 1 : 0) != 0);
                return this.fProcessAreaTree.getRoots().toArray();
            }
            return new Object[0];
        }

        public void dispose() {
            this.fProcessAreaTree = null;
        }
    }

    public static class ProcessAreaFilter
    extends ExcludingViewerFilter {
        private boolean fShowArchived = false;

        public void showArchived(boolean show) {
            this.fShowArchived = show;
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (!this.fShowArchived && element instanceof IProcessArea && !this.isExcluded(element, viewer)) {
                IProcessArea processArea = (IProcessArea)element;
                return !processArea.isArchived();
            }
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ProcessAreaInputProvider
    implements IInputProvider {
        private final ContentMode fContentMode;
        private final ProjectMode fProjectMode;

        public ProcessAreaInputProvider(ContentMode contentMode, ProjectMode projectMode) {
            this.fContentMode = contentMode;
            this.fProjectMode = projectMode;
        }

        @Override
        public Object createInput(IProjectAreaHandle projectAreaHandle, Collection<Object> values, IProgressMonitor monitor) throws TeamRepositoryException {
            IAuditableClient auditableClient = (IAuditableClient)ClientUtils.getClientLibrary((IItemHandle)projectAreaHandle, IAuditableClient.class);
            if (this.fProjectMode == ProjectMode.SINGLE) {
                return this.createProcessAreaTree(auditableClient, Collections.singletonList(projectAreaHandle), monitor);
            }
            List projectAreas = ConnectedProjectAreaRegistry.getDefault().getConnectedProjectAreas((ITeamRepository)projectAreaHandle.getOrigin(), true);
            return this.createProcessAreaTree(auditableClient, projectAreas, monitor);
        }

        private ProcessAreaTree createProcessAreaTree(IAuditableClient auditableClient, List<IProjectAreaHandle> projectAreas, IProgressMonitor monitor) throws TeamRepositoryException {
            List projects = auditableClient.resolveAuditables(projectAreas, ItemProfile.createFullProfile((IItemType)IProjectArea.ITEM_TYPE), monitor);
            List teams = Collections.emptyList();
            if (this.fContentMode != ContentMode.PROJECT_AREA) {
                ArrayList teamAreaHandles = new ArrayList();
                for (IProjectArea projectArea : projects) {
                    if (projectArea == null) continue;
                    teamAreaHandles.addAll(projectArea.getTeamAreas());
                }
                teams = auditableClient.resolveAuditablesPermissionAware(teamAreaHandles, ItemProfile.TEAM_AREA_DEFAULT, monitor);
            }
            return new ProcessAreaTree(this.fContentMode, projects, teams);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ProcessAreaTree {
        private final Comparator<IProcessArea> fProcessAreaComparator = new Comparator<IProcessArea>(){
            Collator collator = Collator.getInstance();

            @Override
            public int compare(IProcessArea pa1, IProcessArea pa2) {
                return this.collator.compare(pa1.getName(), pa2.getName());
            }
        };
        private final ContentMode fContentMode;
        private final Map<UUID, ITeamArea> fTeamAreaMap;
        private final Map<UUID, IProjectArea> fProjectAreaMap;

        public ProcessAreaTree(ContentMode contentMode, List<IProjectArea> projectAreas, List<ITeamArea> resolvedTeamAreas) {
            Assert.isLegal((!projectAreas.isEmpty() ? 1 : 0) != 0);
            this.fContentMode = contentMode;
            this.fProjectAreaMap = new HashMap<UUID, IProjectArea>();
            for (IProjectArea projectArea : projectAreas) {
                this.fProjectAreaMap.put(projectArea.getItemId(), projectArea);
            }
            this.fTeamAreaMap = new HashMap<UUID, ITeamArea>();
            for (ITeamArea teamArea : resolvedTeamAreas) {
                this.fTeamAreaMap.put(teamArea.getItemId(), teamArea);
            }
        }

        public List<? extends IProcessArea> getRoots() {
            if (this.fProjectAreaMap.size() == 1 && this.fContentMode != ContentMode.PROJECT_AREA) {
                IProjectArea projectArea = this.fProjectAreaMap.values().iterator().next();
                return this.getTeamAreas(projectArea.getTeamAreaHierarchy().getRoots());
            }
            ArrayList<IProjectArea> projectAreas = new ArrayList<IProjectArea>(this.fProjectAreaMap.values());
            Collections.sort(projectAreas, this.fProcessAreaComparator);
            return projectAreas;
        }

        public boolean hasChildren(IProcessAreaHandle parent) {
            if (parent instanceof IProjectAreaHandle) {
                return this.fContentMode != ContentMode.PROJECT_AREA;
            }
            ITeamAreaHandle teamArea = (ITeamAreaHandle)parent;
            return !this.getHierarchy(teamArea).getChildren(teamArea).isEmpty();
        }

        public List<ITeamArea> getChildren(IProcessAreaHandle parent) {
            if (parent instanceof IProjectAreaHandle) {
                IProjectArea projectArea = this.getProjectArea((IProjectAreaHandle)parent);
                return this.getTeamAreas(projectArea.getTeamAreaHierarchy().getRoots());
            }
            ITeamAreaHandle teamArea = (ITeamAreaHandle)parent;
            return this.getTeamAreas(this.getHierarchy(teamArea).getChildren(teamArea));
        }

        public IProcessArea getParent(ITeamAreaHandle handle) {
            ITeamAreaHandle parent = this.getHierarchy(handle).getParent(handle);
            if (parent != null) {
                return this.getTeamArea(parent);
            }
            if (this.fProjectAreaMap.size() > 1) {
                ITeamArea teamArea = this.getTeamArea(handle);
                return this.getProjectArea(teamArea.getProjectArea());
            }
            return null;
        }

        private ITeamArea getTeamArea(ITeamAreaHandle handle) {
            return this.fTeamAreaMap.get(handle.getItemId());
        }

        private IProjectArea getProjectArea(IProjectAreaHandle handle) {
            return this.fProjectAreaMap.get(handle.getItemId());
        }

        private ITeamAreaHierarchy getHierarchy(ITeamAreaHandle handle) {
            ITeamArea teamArea = this.getTeamArea(handle);
            IProjectArea projectArea = this.getProjectArea(teamArea.getProjectArea());
            return projectArea.getTeamAreaHierarchy();
        }

        private List<ITeamArea> getTeamAreas(Collection<ITeamAreaHandle> handles) {
            ArrayList<ITeamArea> teamAreas = new ArrayList<ITeamArea>();
            for (ITeamAreaHandle teamAreaHandle : handles) {
                ITeamArea teamArea = this.getTeamArea(teamAreaHandle);
                teamAreas.add(teamArea);
            }
            Collections.sort(teamAreas, this.fProcessAreaComparator);
            return teamAreas;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ProjectMode {
        SINGLE,
        MULTI;

    }
}

