/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.queryeditor.workitem;

import com.ibm.team.process.client.workingcopies.IIterationStructureWorkingCopy;
import com.ibm.team.process.common.IDevelopmentLine;
import com.ibm.team.process.common.IDevelopmentLineHandle;
import com.ibm.team.process.common.IIteration;
import com.ibm.team.process.common.IIterationHandle;
import com.ibm.team.process.internal.ide.ui.editors.IIterationStructureWorkingCopyProvider;
import com.ibm.team.process.internal.ide.ui.editors.IterationsLabelProvider;
import com.ibm.team.workitem.common.internal.util.ItemHandleAwareHashSet;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.control.TreeViewerControl;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.util.ExcludingViewerFilter;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.workitem.IterationProviders;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.workitem.Messages;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.actions.ActionGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IterationTreeViewerControl
extends TreeViewerControl
implements IIterationStructureWorkingCopyProvider {
    private Action fShowArchivedAction = new Action(Messages.IterationTreeViewerControl_FILTER_SHOW_ARCHIVED, 2){

        public void run() {
            IterationTreeViewerControl.this.fFilter.showArchived(this.isChecked());
            IterationTreeViewerControl.this.refresh();
        }
    };
    private Action fShowCompleteAction = new Action(Messages.IterationTreeViewerControl_FILTER_SHOW_COMPLETED, 2){

        public void run() {
            IterationTreeViewerControl.this.fFilter.showCompleted(this.isChecked());
            IterationTreeViewerControl.this.refresh();
        }
    };
    private IterationFilter fFilter;
    private IIterationStructureWorkingCopy fWorkingCopy;

    public IterationTreeViewerControl() {
        this.setInputProvider(IterationProviders.createInputProvider());
        this.setContentProvider((IContentProvider)IterationProviders.createContentProvider());
        this.setPopupContentProvider((IContentProvider)IterationProviders.createContentProvider());
        this.setConverter(IterationProviders.createConverter());
        this.setLabelProvider((IBaseLabelProvider)new IterationsLabelProvider((IIterationStructureWorkingCopyProvider)this));
        this.setPopupLabelProvider((IBaseLabelProvider)new IterationsLabelProvider((IIterationStructureWorkingCopyProvider)this));
        this.setNonCheckableClasses(IDevelopmentLineHandle.class);
        this.fFilter = new IterationFilter();
        this.setFilters(this.fFilter);
        this.fShowArchivedAction.setChecked(false);
        this.fShowCompleteAction.setChecked(true);
        this.fFilter.showArchived(this.fShowArchivedAction.isChecked());
        this.fFilter.showCompleted(this.fShowCompleteAction.isChecked());
        this.setWidthHintInChars(65);
        this.setHeightHintInLines(10);
    }

    @Override
    protected void inputChanged(Object input) {
        Assert.isLegal((input == null || input instanceof IterationProviders.IterationInput ? 1 : 0) != 0);
        this.fWorkingCopy = ((IterationProviders.IterationInput)input).getIterationStructure();
        super.inputChanged(input);
        for (IIterationHandle iterationHandle : this.getCurrentIterations()) {
            this.getCheckboxTreeViewer().expandToLevel((Object)iterationHandle, 0);
        }
    }

    private Set<IIterationHandle> getCurrentIterations() {
        IDevelopmentLine[] devLines;
        ItemHandleAwareHashSet currentIterations = new ItemHandleAwareHashSet();
        IDevelopmentLine[] iDevelopmentLineArray = devLines = this.fWorkingCopy.getDevelopmentLines();
        int n = devLines.length;
        int n2 = 0;
        while (n2 < n) {
            IDevelopmentLine developmentLine = iDevelopmentLineArray[n2];
            IIterationHandle current = developmentLine.getCurrentIteration();
            while (current != null) {
                currentIterations.add(current);
                current = this.fWorkingCopy.getParentIteration(current);
            }
            ++n2;
        }
        return currentIterations;
    }

    @Override
    protected ActionGroup createFilterActionGroup() {
        return new ActionGroup(){

            public void fillContextMenu(IMenuManager menu) {
                menu.add((IAction)IterationTreeViewerControl.this.fShowArchivedAction);
                menu.add((IAction)IterationTreeViewerControl.this.fShowCompleteAction);
            }
        };
    }

    private void refresh() {
        this.fFilter.setExcludedElements(this.getSelectedElements());
        this.getCheckboxTreeViewer().refresh();
        this.getCheckboxTreeViewer().expandAll();
    }

    @Override
    protected void setSelectedElements(Object[] elements) {
        this.fFilter.setExcludedElements(elements);
        super.setSelectedElements(elements);
    }

    public IIterationStructureWorkingCopy getWorkingCopy() {
        return this.fWorkingCopy;
    }

    private static class IterationFilter
    extends ExcludingViewerFilter {
        private boolean fShowArchived = false;
        private boolean fShowCompleted = true;

        private IterationFilter() {
        }

        public void showArchived(boolean show) {
            this.fShowArchived = show;
        }

        public void showCompleted(boolean show) {
            this.fShowCompleted = show;
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (this.fShowArchived && this.fShowCompleted || this.isExcluded(element, viewer)) {
                return true;
            }
            if (element instanceof IDevelopmentLine) {
                IDevelopmentLine developmentLine = (IDevelopmentLine)element;
                return this.fShowArchived || !developmentLine.isArchived();
            }
            if (element instanceof IIteration) {
                IIteration iteration = (IIteration)element;
                return !(!this.fShowArchived && iteration.isArchived() || !this.fShowCompleted && this.isCompleted(viewer, (IIterationHandle)iteration));
            }
            return true;
        }

        private boolean isCompleted(Viewer viewer, IIterationHandle iterationHandle) {
            Object input = viewer.getInput();
            if (input instanceof IterationProviders.IterationInput) {
                IIterationStructureWorkingCopy workingCopy = ((IterationProviders.IterationInput)input).getIterationStructure();
                return workingCopy.isCompletedIteration(iterationHandle);
            }
            return false;
        }
    }
}

