/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.queryeditor.workitem;

import com.ibm.icu.text.Collator;
import com.ibm.team.jface.labelProviders.TypeLabelProvider;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.client.IAuditableClient;
import com.ibm.team.workitem.client.internal.util.ClientUtils;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.internal.util.CategoriesHelper;
import com.ibm.team.workitem.common.internal.util.CategoriesManager;
import com.ibm.team.workitem.common.internal.util.CategoryTreeNode;
import com.ibm.team.workitem.common.internal.util.ItemHandleAwareHashSet;
import com.ibm.team.workitem.common.model.ICategory;
import com.ibm.team.workitem.common.model.ICategoryHandle;
import com.ibm.team.workitem.common.model.ItemProfile;
import com.ibm.team.workitem.ide.ui.internal.WorkItemIDEUIPlugin;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.control.IInputProvider;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.control.IValueConverter;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.util.ExcludingViewerFilter;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.workitem.Messages;
import com.ibm.team.workitem.rcp.ui.internal.viewer.ItemComparer;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerLabel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CategoryProviders {
    public static IInputProvider createInputProvider() {
        return new CategoryInputProvider();
    }

    public static ITreeContentProvider createContentProvider() {
        return new CategoryContentProvider();
    }

    public static ILabelProvider createLabelProvider() {
        return new CategoryLabelProvider();
    }

    public static Comparator<CategoryTreeNode> createComparator() {
        return new CategoryComparator();
    }

    public static IValueConverter createConverter() {
        return new CategoryConverter();
    }

    public static IElementComparer createElementComparer() {
        return new CategoryElementComparer();
    }

    public static CategoryFilter createFilter() {
        return new CategoryFilter();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CategoryComparator
    implements Comparator<CategoryTreeNode> {
        private Collator collator = Collator.getInstance();

        private CategoryComparator() {
        }

        @Override
        public int compare(CategoryTreeNode node1, CategoryTreeNode node2) {
            return this.collator.compare(node1.getName(), node2.getName());
        }
    }

    private static class CategoryContentProvider
    implements ITreeContentProvider {
        private static final Object[] EMPTY_ARRAY = new Object[0];
        private CategoryInput fCategoryInput;

        private CategoryContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            CategoryTreeNode node = this.getCategoryTreeNode(parentElement);
            if (node != null) {
                return node.getChildren().toArray();
            }
            return EMPTY_ARRAY;
        }

        public Object getParent(Object element) {
            CategoryTreeNode node = this.getCategoryTreeNode(element);
            if (node != null) {
                return node.getParent();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            CategoryTreeNode node = this.getCategoryTreeNode(element);
            if (node != null) {
                return !node.getChildren().isEmpty();
            }
            return false;
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof CategoryInput) {
                CategoryInput input = (CategoryInput)inputElement;
                return this.getChildren(input.getCategoriesManager().getRoot());
            }
            return EMPTY_ARRAY;
        }

        public void dispose() {
            this.fCategoryInput = null;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            Assert.isLegal((newInput == null || newInput instanceof CategoryInput ? 1 : 0) != 0);
            this.fCategoryInput = (CategoryInput)newInput;
        }

        private CategoryTreeNode getCategoryTreeNode(Object element) {
            if (element instanceof CategoryTreeNode) {
                return (CategoryTreeNode)element;
            }
            if (element instanceof ICategoryHandle && this.fCategoryInput != null) {
                CategoryTreeNode root = this.fCategoryInput.getCategoriesManager().getRoot();
                return this.findNode(root, (ICategoryHandle)element);
            }
            return null;
        }

        private CategoryTreeNode findNode(CategoryTreeNode root, ICategoryHandle element) {
            if (root.getCategory().sameItemId((IItemHandle)element)) {
                return root;
            }
            for (CategoryTreeNode child : root.getChildren()) {
                CategoryTreeNode node = this.findNode(child, element);
                if (node == null) continue;
                return node;
            }
            return null;
        }
    }

    private static class CategoryConverter
    implements IValueConverter {
        private CategoryConverter() {
        }

        public Object convertFrom(Object object) {
            if (object instanceof CategoryTreeNode) {
                CategoryTreeNode node = (CategoryTreeNode)object;
                return node.getCategory();
            }
            return object;
        }

        public Object convertTo(Object object) {
            return object;
        }
    }

    private static class CategoryElementComparer
    extends ItemComparer {
        private CategoryElementComparer() {
        }

        public boolean equals(Object a, Object b) {
            if (a instanceof CategoryTreeNode) {
                a = ((CategoryTreeNode)a).getCategory();
            }
            if (b instanceof CategoryTreeNode) {
                b = ((CategoryTreeNode)b).getCategory();
            }
            return super.equals(a, b);
        }

        public int hashCode(Object element) {
            if (element instanceof CategoryTreeNode) {
                element = ((CategoryTreeNode)element).getCategory();
            }
            return super.hashCode(element);
        }
    }

    public static class CategoryFilter
    extends ExcludingViewerFilter {
        private boolean fShowArchived = false;
        private boolean fShowDetailed = false;

        public void showArchived(boolean show) {
            this.fShowArchived = show;
        }

        public void showDetailed(boolean show) {
            this.fShowDetailed = show;
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (!(this.fShowArchived && this.fShowDetailed || !(element instanceof CategoryTreeNode) || this.isExcluded(element, viewer))) {
                CategoryTreeNode node = (CategoryTreeNode)element;
                return !(!this.fShowArchived && node.isArchived() || !this.fShowDetailed && !this.isVisible(node, viewer));
            }
            return true;
        }

        private boolean isVisible(CategoryTreeNode node, Viewer viewer) {
            Object input = viewer.getInput();
            if (input instanceof CategoryInput) {
                CategoryInput categoryInput = (CategoryInput)input;
                return categoryInput.getVisibleCategories().contains(node.getCategory());
            }
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CategoryInput {
        private CategoriesManager fCategoriesManager;
        private ItemHandleAwareHashSet<ICategory> fVisibleCategories;

        private CategoryInput(CategoriesManager categoriesManager, List<ICategory> visibleCategories) {
            this.fCategoriesManager = categoriesManager;
            this.fVisibleCategories = new ItemHandleAwareHashSet(visibleCategories);
        }

        public CategoriesManager getCategoriesManager() {
            return this.fCategoriesManager;
        }

        public Set<ICategory> getVisibleCategories() {
            return this.fVisibleCategories;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CategoryInputProvider
    implements IInputProvider {
        private CategoryInputProvider() {
        }

        @Override
        public Object createInput(IProjectAreaHandle projectArea, Collection<Object> values, IProgressMonitor monitor) throws TeamRepositoryException {
            monitor = ClientUtils.getProgressMonitor((IProgressMonitor)monitor);
            try {
                monitor.beginTask(Messages.CategoryProviders_COMPUTING_CATEGORIES, 100);
                IAuditableClient auditableClient = (IAuditableClient)ClientUtils.getClientLibrary((IItemHandle)projectArea, IAuditableClient.class);
                CategoriesManager categoriesManager = CategoriesManager.createInstance((IAuditableCommon)auditableClient, (boolean)false, (IProjectAreaHandle)projectArea, (IProgressMonitor)new SubProgressMonitor(monitor, 50));
                List visibleCategories = CategoriesHelper.findVisibleCategories((IAuditableCommon)auditableClient, (IProjectAreaHandle)projectArea, (IContributorHandle)auditableClient.getUser(), (boolean)true, (ItemProfile)ICategory.DEFAULT_PROFILE, (IProgressMonitor)new SubProgressMonitor(monitor, 50));
                CategoryInput categoryInput = new CategoryInput(categoriesManager, visibleCategories);
                return categoryInput;
            }
            finally {
                monitor.done();
            }
        }
    }

    private static class CategoryLabelProvider
    extends TypeLabelProvider {
        private CategoryLabelProvider() {
        }

        public void updateLabel(ViewerLabel label, Object element) {
            if (element instanceof CategoryTreeNode) {
                CategoryTreeNode node = (CategoryTreeNode)element;
                label.setText(node.getName());
                if (node.isArchived()) {
                    label.setForeground(WorkItemIDEUIPlugin.getDefault().getMidShadow());
                }
            }
        }
    }
}

