/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.queryeditor.workitem;

import com.ibm.team.workitem.common.expression.IQueryableAttribute;
import com.ibm.team.workitem.common.internal.query.presentations.IControlPresentationDescriptor;
import com.ibm.team.workitem.common.internal.util.ValidationUtils;
import com.ibm.team.workitem.common.query.SyntheticAttributeIdentifiers;
import com.ibm.team.workitem.ide.ui.internal.ImagePool;
import com.ibm.team.workitem.ide.ui.internal.WorkItemIDEUIPlugin;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.contributions.IDefaultQueryEditorControlFactory;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.control.BooleanConditionControl;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.control.DateConditionControl;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.control.IConditionControl;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.control.IValidator;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.control.MessageConditionControl;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.control.NumberConverter;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.control.NumberValidator;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.control.SliderConditionControl;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.control.TextConditionControl;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.control.TextControl;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.workitem.Messages;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.workitem.RegularExpressionValidator;
import java.util.HashMap;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.core.runtime.IStatus;

public class BasicQueryEditorControlFactory
implements IDefaultQueryEditorControlFactory {
    private static HashMap<String, ConditionControl> fgTypeControls = new HashMap();

    static {
        fgTypeControls.put("timestamp", ConditionControl.DATE_CONTROL);
        fgTypeControls.put("smallString", ConditionControl.TEXT_CONTROL);
        fgTypeControls.put("mediumString", ConditionControl.TEXT_CONTROL);
        fgTypeControls.put("mediumHtml", ConditionControl.TEXT_CONTROL);
        fgTypeControls.put("integer", ConditionControl.INTEGER_CONTROL);
        fgTypeControls.put("long", ConditionControl.LONG_CONTROL);
        fgTypeControls.put("float", ConditionControl.FLOAT_CONTROL);
        fgTypeControls.put("boolean", ConditionControl.BOOLEAN_CONTROL);
        fgTypeControls.put("html", ConditionControl.LARGE_STRING_CONTROL);
        fgTypeControls.put("string", ConditionControl.LARGE_STRING_CONTROL);
    }

    public IConditionControl createConditionControl(IControlPresentationDescriptor descriptor) {
        ConditionControl control = this.getConditionControl(descriptor.getAttribute());
        return control != null ? control.createControl(descriptor) : null;
    }

    public boolean supports(IControlPresentationDescriptor descriptor) {
        ConditionControl control = this.getConditionControl(descriptor.getAttribute());
        return control != null;
    }

    private ConditionControl getConditionControl(IQueryableAttribute attribute) {
        if (attribute.isSynthetic() && !SyntheticAttributeIdentifiers.QUERYABLE_ATTRIBUTES.contains(attribute.getIdentifier())) {
            return null;
        }
        String attributeType = attribute.getAttributeType();
        if ("all".equals(attribute.getIdentifier())) {
            return ConditionControl.FULLTEXT_CONTROL;
        }
        if (!attribute.isStateExtension() && !attribute.isSynthetic() && ("html".equals(attributeType) || "string".equals(attributeType))) {
            return null;
        }
        return fgTypeControls.get(attributeType);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ConditionControl {
        TEXT_CONTROL{

            protected IConditionControl createControl(IControlPresentationDescriptor descriptor) {
                TextConditionControl control = new TextConditionControl();
                if (descriptor.hasConfigurationValue("regularExpression")) {
                    String regExp = descriptor.getConfigurationValue("regularExpression");
                    String message = descriptor.getConfigurationValue("wrongFormatMessage");
                    if (this.checkExpression(regExp)) {
                        control.setValidator(new RegularExpressionValidator(regExp, message), ConditionControl.getOptions(descriptor, TextControl.Options.VERIFY_WARN));
                    }
                }
                return control;
            }

            private boolean checkExpression(String regExp) {
                if (regExp == null) {
                    return false;
                }
                try {
                    Pattern.compile(regExp);
                    return true;
                }
                catch (PatternSyntaxException e) {
                    WorkItemIDEUIPlugin.getDefault().log(Messages.BasicQueryEditorControlFactory_WRORNG_REGEXP_FORMAT, e);
                    return false;
                }
            }
        }
        ,
        INTEGER_CONTROL{

            protected IConditionControl createControl(IControlPresentationDescriptor descriptor) {
                String rangeStartString = descriptor.getConfigurationValue("rangeStart");
                String rangeEndString = descriptor.getConfigurationValue("rangeEnd");
                Integer rangeStart = null;
                Integer rangeEnd = null;
                if (rangeStartString != null && NumberValidator.INTEGER_VALIDATOR.validate(rangeStartString).isOK()) {
                    rangeStart = new Integer(rangeStartString);
                }
                if (rangeEndString != null && NumberValidator.INTEGER_VALIDATOR.validate(rangeEndString).isOK()) {
                    rangeEnd = new Integer(rangeEndString);
                }
                if ("com.ibm.team.workitem.query.kind.slider".equals(descriptor.getPresentationIdentifier()) && ConditionControl.checkRange(rangeStart, rangeEnd)) {
                    SliderConditionControl<Integer> control = new SliderConditionControl<Integer>(SliderConditionControl.Type.INTEGER, rangeStart, rangeEnd);
                    control.setStartLabelText(descriptor.getConfigurationValue("startLabel"));
                    control.setEndLabelText(descriptor.getConfigurationValue("endLabel"));
                    return control;
                }
                TextConditionControl control = new TextConditionControl();
                control.setValidator(new NumberValidator.IntegerValidator(rangeStart, rangeEnd), ConditionControl.getOptions(descriptor, TextControl.Options.VERIFY_STRICT));
                control.setConverter(NumberConverter.create(Integer.class));
                return control;
            }
        }
        ,
        LONG_CONTROL{

            protected IConditionControl createControl(IControlPresentationDescriptor descriptor) {
                String rangeStartString = descriptor.getConfigurationValue("rangeStart");
                String rangeEndString = descriptor.getConfigurationValue("rangeEnd");
                Long rangeStart = null;
                Long rangeEnd = null;
                if (rangeStartString != null && NumberValidator.LONG_VALIDATOR.validate(rangeStartString).isOK()) {
                    rangeStart = new Long(rangeStartString);
                }
                if (rangeEndString != null && NumberValidator.LONG_VALIDATOR.validate(rangeEndString).isOK()) {
                    rangeEnd = new Long(rangeEndString);
                }
                if ("com.ibm.team.workitem.query.kind.slider".equals(descriptor.getPresentationIdentifier()) && ConditionControl.checkRange(rangeStart, rangeEnd)) {
                    SliderConditionControl<Long> control = new SliderConditionControl<Long>(SliderConditionControl.Type.LONG, rangeStart, rangeEnd);
                    control.setStartLabelText(descriptor.getConfigurationValue("startLabel"));
                    control.setEndLabelText(descriptor.getConfigurationValue("endLabel"));
                    return control;
                }
                TextConditionControl control = new TextConditionControl();
                control.setValidator(new NumberValidator.LongValidator(rangeStart, rangeEnd), ConditionControl.getOptions(descriptor, TextControl.Options.VERIFY_STRICT));
                control.setConverter(NumberConverter.create(Long.class));
                return control;
            }
        }
        ,
        FLOAT_CONTROL{

            protected IConditionControl createControl(IControlPresentationDescriptor descriptor) {
                String rangeStartString = descriptor.getConfigurationValue("rangeStart");
                String rangeEndString = descriptor.getConfigurationValue("rangeEnd");
                Float rangeStart = null;
                Float rangeEnd = null;
                if (rangeStartString != null && NumberValidator.FLOAT_VALIDATOR.validate(rangeStartString).isOK()) {
                    rangeStart = new Float(rangeStartString);
                }
                if (rangeEndString != null && NumberValidator.FLOAT_VALIDATOR.validate(rangeEndString).isOK()) {
                    rangeEnd = new Float(rangeEndString);
                }
                if ("com.ibm.team.workitem.query.kind.slider".equals(descriptor.getPresentationIdentifier()) && ConditionControl.checkRange(rangeStart, rangeEnd)) {
                    SliderConditionControl<Float> control = new SliderConditionControl<Float>(SliderConditionControl.Type.FLOAT, rangeStart, rangeEnd);
                    control.setStartLabelText(descriptor.getConfigurationValue("startLabel"));
                    control.setEndLabelText(descriptor.getConfigurationValue("endLabel"));
                    return control;
                }
                TextConditionControl control = new TextConditionControl();
                control.setValidator(new NumberValidator.FloatValidator(rangeStart, rangeEnd), ConditionControl.getOptions(descriptor, TextControl.Options.VERIFY_STRICT));
                control.setConverter(NumberConverter.create(Integer.class));
                return control;
            }
        }
        ,
        DATE_CONTROL{

            protected IConditionControl createControl(IControlPresentationDescriptor descriptor) {
                DateConditionControl control = new DateConditionControl();
                if (descriptor.hasConfigurationValue("futureVariables")) {
                    control.setAllowFutureVariables(descriptor.getBooleanConfigurationValue("futureVariables"));
                }
                return control;
            }
        }
        ,
        LARGE_STRING_CONTROL{

            protected IConditionControl createControl(IControlPresentationDescriptor descriptor) {
                return new MessageConditionControl(Messages.BasicQueryEditorControlFactory_USE_FULLTEXT_HINT, ImagePool.INFO_ICON);
            }
        }
        ,
        FULLTEXT_CONTROL{

            protected IConditionControl createControl(IControlPresentationDescriptor descriptor) {
                TextConditionControl control = new TextConditionControl();
                control.setValidator(new IValidator(){

                    public IStatus validate(Object object) {
                        return ValidationUtils.validatePhraseSearch((String)object.toString());
                    }
                }, TextControl.Options.VERIFY_WARN);
                return control;
            }
        }
        ,
        BOOLEAN_CONTROL{

            protected IConditionControl createControl(IControlPresentationDescriptor descriptor) {
                boolean checkBoxStyle = "com.ibm.team.workitem.query.kind.checkBox".equals(descriptor.getPresentationIdentifier());
                BooleanConditionControl control = new BooleanConditionControl(checkBoxStyle ? BooleanConditionControl.Flavour.CHECKBOX : BooleanConditionControl.Flavour.RADIO);
                control.setCustomTrueLabel(descriptor.getConfigurationValue("customTrueLabel"));
                control.setCustomFalseLabel(descriptor.getConfigurationValue("customFalseLabel"));
                return control;
            }
        };


        private static TextControl.Options getOptions(IControlPresentationDescriptor descriptor, TextControl.Options defaultOption) {
            String mode = descriptor.getConfigurationValue("mode");
            if ("strict".equals(mode)) {
                return TextControl.Options.VERIFY_STRICT;
            }
            if ("warn".equals(mode)) {
                return TextControl.Options.VERIFY_WARN;
            }
            return defaultOption;
        }

        private static <T> boolean checkRange(Comparable<T> start, T end) {
            return start != null && end != null && start.compareTo(end) < 0;
        }

        protected abstract IConditionControl createControl(IControlPresentationDescriptor var1);
    }
}

