/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.queryeditor.util;

import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.widgets.Section;

public class SectionUtils {
    public static final String TOP_SECTION = String.valueOf(SectionUtils.class.getName()) + ".topSection";
    public static final String BOTTOM_SECTION = String.valueOf(SectionUtils.class.getName()) + ".bottomSection";
    private static final String TOP_FORM_ATTACHMENT = String.valueOf(SectionUtils.class.getName()) + ".topFormAttachment";
    private static final String BOTTOM_FORM_ATTACHMENT = String.valueOf(SectionUtils.class.getName()) + ".bottomFormAttachment";

    public static void adaptTopAttachment(Section bottom, boolean bottomExpanded) {
        Section top = (Section)bottom.getData(TOP_SECTION);
        if (top == null) {
            return;
        }
        SectionUtils.internalAdaptTopAttachment(bottom, bottomExpanded, top, top.isExpanded());
    }

    private static void internalAdaptTopAttachment(Section bottom, boolean bottomExpanded, Section top, boolean topExpanded) {
        FormData data = (FormData)bottom.getLayoutData();
        FormAttachment topFormAttachment = (FormAttachment)bottom.getData(TOP_FORM_ATTACHMENT);
        if (topFormAttachment == null && data.top != null) {
            topFormAttachment = data.top;
            bottom.setData(TOP_FORM_ATTACHMENT, (Object)topFormAttachment);
        }
        if (bottomExpanded && topExpanded) {
            SectionUtils.restoreAttachment(bottom);
            SectionUtils.restoreAttachment(top);
        } else if (bottomExpanded) {
            data.top = new FormAttachment((Control)top);
        } else {
            if (!topExpanded) {
                top.setExpanded(true);
            }
            data.top = null;
            SectionUtils.internalAdaptBottomAttachment(top, top.isExpanded(), bottom, bottomExpanded);
        }
    }

    public static void adaptBottomAttachment(Section top, boolean topExpanded) {
        Section bottom = (Section)top.getData(BOTTOM_SECTION);
        if (bottom == null) {
            return;
        }
        SectionUtils.internalAdaptBottomAttachment(top, topExpanded, bottom, bottom.isExpanded());
    }

    private static void internalAdaptBottomAttachment(Section top, boolean topExpanded, Section bottom, boolean bottomExpanded) {
        FormData data = (FormData)top.getLayoutData();
        FormAttachment bottomFormAttachment = (FormAttachment)top.getData(BOTTOM_FORM_ATTACHMENT);
        if (bottomFormAttachment == null && data.bottom != null) {
            bottomFormAttachment = data.bottom;
            top.setData(BOTTOM_FORM_ATTACHMENT, (Object)bottomFormAttachment);
        }
        if (bottomExpanded && topExpanded) {
            SectionUtils.restoreAttachment(bottom);
            SectionUtils.restoreAttachment(top);
        }
        if (topExpanded) {
            data.bottom = bottomExpanded ? bottomFormAttachment : new FormAttachment((Control)bottom);
        } else {
            if (!bottomExpanded) {
                bottom.setExpanded(true);
            }
            data.bottom = null;
            SectionUtils.internalAdaptTopAttachment(bottom, bottom.isExpanded(), top, topExpanded);
        }
    }

    private static void restoreAttachment(Section section) {
        FormData data = (FormData)section.getLayoutData();
        if (section.getData(BOTTOM_FORM_ATTACHMENT) != null) {
            data.bottom = (FormAttachment)section.getData(BOTTOM_FORM_ATTACHMENT);
        }
        if (section.getData(TOP_FORM_ATTACHMENT) != null) {
            data.top = (FormAttachment)section.getData(TOP_FORM_ATTACHMENT);
        }
    }

    public static Section getSection(Composite parent) {
        Composite current = parent;
        while (current != null && !(current instanceof Section)) {
            current = current.getParent();
        }
        return (Section)current;
    }
}

