/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.queryeditor.part;

import com.ibm.team.workitem.client.query.WorkingCopyChangeEvent;
import com.ibm.team.workitem.common.expression.IQueryableAttribute;
import com.ibm.team.workitem.common.expression.QueryableAttributes;
import com.ibm.team.workitem.common.expression.StatementChangeEvent;
import com.ibm.team.workitem.common.internal.expression.EditableSortColumn;
import com.ibm.team.workitem.common.internal.expression.EditableStatement;
import com.ibm.team.workitem.common.internal.query.util.QueryUtils;
import com.ibm.team.workitem.common.query.IQueryDescriptor;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.QueryEditorToolkit;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.SlushBucket;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.part.Messages;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.part.QueryEditorFormPart;
import com.ibm.team.workitem.rcp.ui.internal.queries.QueryableAttributeContentProvider;
import com.ibm.team.workitem.rcp.ui.internal.queries.QueryableAttributeLabelProvider;
import com.ibm.team.workitem.rcp.ui.internal.util.DefaultViewerComparator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SortingPart
extends QueryEditorFormPart {
    public static final String PART_ID = "com.ibm.team.query.part.sorting";
    private static final String[] HANDLED_ATTRIBUTES = new String[]{IQueryDescriptor.EXPRESSION_PROPERTY};
    private static final String[] SORT_DIRECTION_LITERALS = new String[]{Messages.SortingPart_DIRECTION_ASC, Messages.SortingPart_DIRECTION_DESC};
    private SelectionAdapter fButtonDispatcher = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            if (SortingPart.this.fSlushBucket.getAddButton() == e.widget) {
                SortingPart.this.handleAdd();
            } else if (SortingPart.this.fSlushBucket.getAddAllButton() == e.widget) {
                SortingPart.this.handleAddAll();
            } else if (SortingPart.this.fSlushBucket.getRemoveButton() == e.widget) {
                SortingPart.this.handleRemove();
            } else if (SortingPart.this.fSlushBucket.getRemoveAllButton() == e.widget) {
                SortingPart.this.handleRemoveAll();
            } else if (SortingPart.this.fSlushBucket.getUpButton() == e.widget) {
                SortingPart.this.handleMoveUp();
            } else if (SortingPart.this.fSlushBucket.getDownButton() == e.widget) {
                SortingPart.this.handleMoveDown();
            } else if (SortingPart.this.fSlushBucket.getDefaultsButton() == e.widget) {
                SortingPart.this.handleSetDefaults();
            }
        }
    };
    private IDoubleClickListener fDoubleClickDispatcher = new IDoubleClickListener(){

        public void doubleClick(DoubleClickEvent event) {
            if (SortingPart.this.fAvailableColumnViewer == event.getViewer()) {
                SortingPart.this.handleAdd();
            } else if (SortingPart.this.fSelectedColumnViewer == event.getViewer()) {
                SortingPart.this.handleRemove();
            }
        }
    };
    private TableViewer fAvailableColumnViewer;
    private TableViewer fSelectedColumnViewer;
    private SlushBucket fSlushBucket;
    private EditableStatement fStatement;
    private List<IQueryableAttribute> fAvailableAttributes;

    @Override
    protected String[] getHandledAttributes() {
        return HANDLED_ATTRIBUTES;
    }

    @Override
    protected void update(WorkingCopyChangeEvent event) {
        if (event.affects(this.fStatement)) {
            StatementChangeEvent statementChangeEvent = event.getStatementChangeEvent();
            switch (statementChangeEvent.getType()) {
                case SORT_COLUMNS_ADDED: {
                    this.addSortColumns(statementChangeEvent.getSortColumns());
                    break;
                }
                case SORT_COLUMNS_REMOVED: {
                    this.removeSortColumns(statementChangeEvent.getSortColumns());
                    break;
                }
                case SORT_COLUMNS_CLEARED: 
                case SORT_COLUMNS_CHANGED: {
                    this.updateAll();
                    break;
                }
                case SORT_COLUMNS_CHANGED_ORDER: {
                    this.updateSortColumns();
                }
            }
        }
    }

    @Override
    public void setInput(Object input) {
        super.setInput(input);
        this.fStatement = this.getInput().getWorkingCopy().getEditableStatement();
        this.fAvailableAttributes = this.getAvailableAttributes(this.getInput().getConfiguration().getColumnAttributes());
        this.fAvailableColumnViewer.setInput(this.fAvailableAttributes);
        this.fSelectedColumnViewer.setInput((Object)this.fStatement);
        this.fSlushBucket.updateButtonEnablement();
    }

    public void createContent(Composite parent) {
        QueryEditorToolkit toolkit = (QueryEditorToolkit)this.getSite().getToolkit();
        this.fSlushBucket = toolkit.createSlushBucket(parent, Messages.SortingPart_AVAILABLE_COLUMNS, Messages.SortingPart_SELECTED_COLUMNS);
        this.fAvailableColumnViewer = new TableViewer(this.fSlushBucket.getAvailableTable());
        this.fAvailableColumnViewer.setContentProvider((IContentProvider)new QueryableAttributeContentProvider());
        this.fAvailableColumnViewer.setLabelProvider((IBaseLabelProvider)new QueryableAttributeLabelProvider());
        this.fAvailableColumnViewer.setComparator((ViewerComparator)new DefaultViewerComparator(QueryableAttributes.createComparator()));
        this.fAvailableColumnViewer.addFilter((ViewerFilter)new AvailableColumnsFilter());
        Table selectedTable = this.fSlushBucket.getSelectedTable();
        selectedTable.setHeaderVisible(true);
        selectedTable.setLinesVisible(true);
        TableLayout selectedTableLayout = new TableLayout();
        selectedTable.setLayout((Layout)selectedTableLayout);
        TableColumn attributeColumn = new TableColumn(selectedTable, 0);
        attributeColumn.setText(Messages.SortingPart_COLUMN);
        attributeColumn.setResizable(false);
        selectedTableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(60));
        TableColumn sortingColumn = new TableColumn(selectedTable, 0);
        sortingColumn.setText(Messages.SortingPart_DIRECTION);
        sortingColumn.setResizable(false);
        selectedTableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(40));
        this.fSelectedColumnViewer = new TableViewer(this.fSlushBucket.getSelectedTable());
        this.fSelectedColumnViewer.setContentProvider((IContentProvider)new SelectedSortColumnContentProvider());
        TableViewerColumn attributeViewerColumn = new TableViewerColumn(this.fSelectedColumnViewer, attributeColumn);
        attributeViewerColumn.setLabelProvider(QueryableAttributeLabelProvider.createCellLabelProvider());
        TableViewerColumn sortingViewerColumn = new TableViewerColumn(this.fSelectedColumnViewer, sortingColumn);
        sortingViewerColumn.setEditingSupport((EditingSupport)new SortCriteriaEditingSupport(this.fSelectedColumnViewer));
        sortingViewerColumn.setLabelProvider((CellLabelProvider)new SortColumnDirectionLabelProvider());
        this.fSlushBucket.addSelectionListener((SelectionListener)this.fButtonDispatcher);
        this.fAvailableColumnViewer.addDoubleClickListener(this.fDoubleClickDispatcher);
        this.fSelectedColumnViewer.addDoubleClickListener(this.fDoubleClickDispatcher);
    }

    private void handleAdd() {
        List<IQueryableAttribute> addedAttributes = this.getAttributesFromSelection(this.fAvailableColumnViewer.getSelection());
        ArrayList<EditableSortColumn> sortColumns = new ArrayList<EditableSortColumn>(addedAttributes.size());
        for (IQueryableAttribute added : addedAttributes) {
            sortColumns.add(new EditableSortColumn(added, EditableSortColumn.Direction.ASCENDING));
        }
        this.fStatement.addSortColumns(sortColumns);
    }

    private void handleAddAll() {
        ArrayList<EditableSortColumn> sortColumns = new ArrayList<EditableSortColumn>(this.fAvailableAttributes.size());
        for (IQueryableAttribute available : this.fAvailableAttributes) {
            sortColumns.add(new EditableSortColumn(available, EditableSortColumn.Direction.ASCENDING));
        }
        this.fStatement.addSortColumns(sortColumns);
    }

    private void handleRemove() {
        List<EditableSortColumn> addedAttributes = this.getSortColumnsFromSelection(this.fSelectedColumnViewer.getSelection());
        this.fStatement.removeSortColumns(addedAttributes);
    }

    private void handleRemoveAll() {
        this.fStatement.removeAllSortColumns();
    }

    private void handleMoveUp() {
        List<EditableSortColumn> movedSortColumns = this.getSortColumnsFromSelection(this.fSelectedColumnViewer.getSelection());
        this.fStatement.moveSortColumns(movedSortColumns, -1);
    }

    private void handleMoveDown() {
        List<EditableSortColumn> movedSortColumns = this.getSortColumnsFromSelection(this.fSelectedColumnViewer.getSelection());
        this.fStatement.moveSortColumns(movedSortColumns, 1);
    }

    private void addSortColumns(List<EditableSortColumn> sortColumns) {
        this.fSelectedColumnViewer.refresh();
        this.fSelectedColumnViewer.setSelection((ISelection)new StructuredSelection(sortColumns));
        if (sortColumns.size() > 0) {
            this.fSelectedColumnViewer.editElement((Object)sortColumns.get(0), 1);
        }
        this.fAvailableColumnViewer.remove(this.getSortColumnAttributes(sortColumns).toArray());
        this.fSlushBucket.updateButtonEnablement();
    }

    private void removeSortColumns(List<EditableSortColumn> sortColumns) {
        this.fSelectedColumnViewer.refresh();
        Object[] attributes = this.getSortColumnAttributes(sortColumns).toArray();
        this.fAvailableColumnViewer.add(attributes);
        this.fAvailableColumnViewer.setSelection((ISelection)new StructuredSelection(attributes));
        this.fSlushBucket.updateButtonEnablement();
    }

    private void updateAll() {
        this.fSelectedColumnViewer.refresh();
        this.fAvailableColumnViewer.refresh();
        this.fSlushBucket.updateButtonEnablement();
    }

    private void updateSortColumns() {
        this.fSelectedColumnViewer.refresh();
        this.fSlushBucket.updateButtonEnablement();
    }

    private void handleSetDefaults() {
        List<EditableSortColumn> defaultSortOrder = this.getInput().getConfiguration().getDefaultSortOrder();
        this.fStatement.setSortColumns(defaultSortOrder);
    }

    private List<IQueryableAttribute> getAvailableAttributes(List<IQueryableAttribute> attributes) {
        ArrayList<IQueryableAttribute> available = new ArrayList<IQueryableAttribute>();
        for (IQueryableAttribute attribute : attributes) {
            if (!QueryUtils.isSortable((IQueryableAttribute)attribute)) continue;
            available.add(attribute);
        }
        return available;
    }

    private List<EditableSortColumn> getSortColumnsFromSelection(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            ArrayList<EditableSortColumn> sortColumns = new ArrayList<EditableSortColumn>(structuredSelection.size());
            for (Object element : structuredSelection) {
                if (!(element instanceof EditableSortColumn)) continue;
                sortColumns.add((EditableSortColumn)element);
            }
            return sortColumns;
        }
        return Collections.emptyList();
    }

    private List<IQueryableAttribute> getAttributesFromSelection(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            ArrayList<IQueryableAttribute> attributes = new ArrayList<IQueryableAttribute>(structuredSelection.size());
            for (Object element : structuredSelection) {
                if (!(element instanceof IQueryableAttribute)) continue;
                attributes.add((IQueryableAttribute)element);
            }
            return attributes;
        }
        return Collections.emptyList();
    }

    private List<IQueryableAttribute> getSortColumnAttributes(List<EditableSortColumn> sortColumns) {
        ArrayList<IQueryableAttribute> attributes = new ArrayList<IQueryableAttribute>();
        for (EditableSortColumn column : sortColumns) {
            attributes.add(column.getAttribute());
        }
        return attributes;
    }

    public boolean stretchHorizontally() {
        return true;
    }

    public boolean stretchVertically() {
        return true;
    }

    private class AvailableColumnsFilter
    extends ViewerFilter {
        private AvailableColumnsFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (SortingPart.this.fStatement != null) {
                IQueryableAttribute attribute = (IQueryableAttribute)element;
                for (EditableSortColumn column : SortingPart.this.fStatement.getSortColumns()) {
                    if (!attribute.getIdentifier().equals(column.getAttribute().getIdentifier())) continue;
                    return false;
                }
            }
            return true;
        }
    }

    private static class SelectedSortColumnContentProvider
    implements IStructuredContentProvider {
        private SelectedSortColumnContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof EditableStatement) {
                EditableStatement statement = (EditableStatement)inputElement;
                return statement.getSortColumns().toArray();
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private static class SortColumnDirectionLabelProvider
    extends CellLabelProvider {
        private SortColumnDirectionLabelProvider() {
        }

        public void update(ViewerCell cell) {
            EditableSortColumn column = (EditableSortColumn)cell.getElement();
            EditableSortColumn.Direction direction = column.getDirection();
            cell.setText(direction == EditableSortColumn.Direction.ASCENDING ? SORT_DIRECTION_LITERALS[0] : SORT_DIRECTION_LITERALS[1]);
        }
    }

    private static class SortCriteriaEditingSupport
    extends EditingSupport {
        private TableViewer fTableViewer;
        private CellEditor fCellEditor;

        public SortCriteriaEditingSupport(TableViewer viewer) {
            super((ColumnViewer)viewer);
            this.fTableViewer = viewer;
        }

        protected boolean canEdit(Object element) {
            return true;
        }

        protected CellEditor getCellEditor(Object element) {
            if (this.fCellEditor == null) {
                this.fCellEditor = new ComboBoxCellEditor((Composite)this.fTableViewer.getTable(), SORT_DIRECTION_LITERALS, 8);
            }
            return this.fCellEditor;
        }

        protected Object getValue(Object element) {
            if (element instanceof EditableSortColumn) {
                EditableSortColumn column = (EditableSortColumn)element;
                return column.getDirection() == EditableSortColumn.Direction.ASCENDING ? 0 : 1;
            }
            return 0;
        }

        protected void setValue(Object element, Object value) {
            if (element instanceof EditableSortColumn && value instanceof Integer) {
                EditableSortColumn column = (EditableSortColumn)element;
                Integer index = (Integer)value;
                column.setDirection(index == 0 ? EditableSortColumn.Direction.ASCENDING : EditableSortColumn.Direction.DESCENDING);
            }
        }
    }
}

