/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.queryeditor.part;

import com.ibm.team.foundation.common.text.XMLString;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.ui.editor.TeamFormPart;
import com.ibm.team.workitem.client.query.IQueryDescriptorWorkingCopy;
import com.ibm.team.workitem.common.expression.IQueryableAttribute;
import com.ibm.team.workitem.common.internal.expression.EditableAttributeExpression;
import com.ibm.team.workitem.common.internal.expression.EditableExpression;
import com.ibm.team.workitem.common.internal.expression.EditableTerm;
import com.ibm.team.workitem.common.model.AttributeOperation;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.QueryEditorInput;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.contributions.ShortCut;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.control.PageBookControl;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.part.Messages;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.part.TermPart;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class ConditionsPart
extends TeamFormPart {
    public static final String PART_ID = "com.ibm.team.query.part.conditions";
    private static final String LINK_FORMAT = "<p><a>{0}</a><br/>{1}</p>";
    private static final String START_FROM_SCRATCH_LINK = XMLString.createFromPlainText((String)Messages.ConditionsPart_START_FROM_SCRATCH_LINK).getXMLText();
    private static final String START_FROM_SCRATCH_DESCRIPTION = XMLString.createFromPlainText((String)Messages.ConditionsPart_START_FROM_SCRATCH_DESCRIPTION).getXMLText();
    private PageBookControl fPageBook;
    private QueryEditorInput fInput;
    private TermPart fTermPart;

    public void setInput(Object input) {
        if (input instanceof QueryEditorInput) {
            this.fInput = (QueryEditorInput)((Object)input);
            this.createConditionContent(this.fPageBook.getPage((Object)Pages.CONDITIONS));
            if (this.getWorkingCopy().getQueryDescriptor().isNewItem() && this.getRoot().getExpressions().isEmpty()) {
                this.createShortCutContent(this.fPageBook.getPage((Object)Pages.SHORTCUTS));
                this.fPageBook.showPage((Object)Pages.SHORTCUTS);
            } else {
                this.fPageBook.showPage((Object)Pages.CONDITIONS);
            }
        }
    }

    public void createContent(Composite parent) {
        GridLayoutFactory.fillDefaults().applyTo(parent);
        this.fPageBook = new PageBookControl(parent, 0);
        this.getSite().getToolkit().adapt((Composite)this.fPageBook.getPageBook());
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.fPageBook.getPageBook());
        this.fPageBook.createPage((Object)Pages.CONDITIONS);
        this.fPageBook.createPage((Object)Pages.SHORTCUTS);
    }

    private void createConditionContent(Composite conditionPage) {
        if (this.fTermPart != null) {
            this.fTermPart.dispose();
        }
        this.fTermPart = new TermPart(this.getRoot());
        this.fTermPart.init(this.getSite());
        this.fTermPart.setInput((Object)this.fInput);
        this.fTermPart.createContent(conditionPage);
    }

    private void createShortCutContent(Composite shortCutPage) {
        GridLayoutFactory.fillDefaults().applyTo(shortCutPage);
        FormToolkit toolkit = this.getSite().getToolkit();
        HyperlinkAdapter listener = new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                ConditionsPart.this.fPageBook.showPage((Object)Pages.CONDITIONS);
                ShortCut shortCut = (ShortCut)e.widget.getData();
                this.createSections(shortCut.getAttributes());
            }

            private void createSections(List<String> attributes) {
                EditableTerm term = ConditionsPart.this.getRoot();
                if (term != null) {
                    for (String string : attributes) {
                        IQueryableAttribute attribute = this.getAttribute(string);
                        EditableAttributeExpression expression = new EditableAttributeExpression(attribute, (AttributeOperation)attribute.getOperators().get(0));
                        term.add((EditableExpression)expression);
                    }
                }
            }

            private IQueryableAttribute getAttribute(String string) {
                for (IQueryableAttribute attribute : ConditionsPart.this.fInput.getConfiguration().getAttributes()) {
                    if (!attribute.getIdentifier().equals(string)) continue;
                    return attribute;
                }
                return null;
            }
        };
        FormText intro = toolkit.createFormText(shortCutPage, false);
        intro.setText(Messages.ConditionsPart_LINKS_INTRO, false, false);
        String startFromScratchDescription = NLS.bind((String)LINK_FORMAT, (Object)START_FROM_SCRATCH_LINK, (Object[])new Object[]{START_FROM_SCRATCH_DESCRIPTION});
        ShortCut fromScratchShortCut = new ShortCut(startFromScratchDescription, Collections.<String>emptyList());
        ArrayList<ShortCut> shortCuts = new ArrayList<ShortCut>(this.fInput.getConfiguration().getShortCuts());
        shortCuts.add(0, fromScratchShortCut);
        for (ShortCut shortCut : shortCuts) {
            FormText formText = toolkit.createFormText(shortCutPage, false);
            String text = String.format("<form>%s</form>", shortCut.getDescription());
            try {
                formText.setText(text, true, false);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                formText.setText(text, false, false);
            }
            formText.setData((Object)shortCut);
            formText.addHyperlinkListener((IHyperlinkListener)listener);
        }
        shortCutPage.layout();
    }

    public boolean stretchHorizontally() {
        return true;
    }

    public boolean stretchVertically() {
        return true;
    }

    private IQueryDescriptorWorkingCopy getWorkingCopy() {
        return this.fInput.getWorkingCopy();
    }

    private EditableTerm getRoot() {
        return this.getWorkingCopy().getEditableStatement().getLogicalRoot();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Pages {
        CONDITIONS,
        SHORTCUTS;

    }
}

