/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.queryeditor.part;

import com.ibm.team.workitem.common.expression.Term;
import com.ibm.team.workitem.common.internal.expression.EditableExpression;
import com.ibm.team.workitem.common.internal.expression.EditableTerm;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.QueryEditorConfiguration;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.actions.AddMultiAttributeConditionAction;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.actions.AddTermConditionAction;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.actions.SelectAttributeConditionAction;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.contributions.TypeGroupDescriptor;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.part.Messages;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.ActionGroup;

public class AddConditionActionGroup
extends ActionGroup {
    private static final String GROUP_MAIN = "main";
    private static final String GROUP_TERM = "terms";
    private static final String GROUP_TYPES = "types";
    private static final String GROUP_BUILTIN = "attributes";
    private static final String GROUP_OTHER = "other";
    private static final String GROUP_CUSTOM = "custom";
    private static final String GROUP_LINKS = "links";
    private final Shell fShell;
    private final EditableTerm fTerm;
    private final EditableExpression fAfterExpression;
    private final QueryEditorConfiguration fConfiguration;
    private final AddTermConditionAction fAddAndTerm;
    private final AddTermConditionAction fAddOrTerm;

    public AddConditionActionGroup(Shell shell, EditableTerm term, EditableExpression after, QueryEditorConfiguration configuration) {
        Assert.isNotNull((Object)term);
        this.fShell = shell;
        this.fTerm = term;
        this.fAfterExpression = after;
        this.fConfiguration = configuration;
        this.fAddAndTerm = new AddTermConditionAction(this.fTerm, Messages.AddConditionActionGroup_AND_GROUP, Term.Operator.AND);
        this.fAddOrTerm = new AddTermConditionAction(this.fTerm, Messages.AddConditionActionGroup_OR_GROUP, Term.Operator.OR);
    }

    public void fillContextMenu(IMenuManager menu) {
        menu.add((IContributionItem)new Separator(GROUP_MAIN));
        menu.add((IContributionItem)new Separator(GROUP_TERM));
        menu.add((IContributionItem)new Separator(GROUP_TYPES));
        menu.add((IContributionItem)new Separator(GROUP_BUILTIN));
        menu.add((IContributionItem)new Separator(GROUP_OTHER));
        menu.appendToGroup(GROUP_MAIN, (IAction)new SelectAttributeConditionAction(this.fShell, this.fTerm, this.fAfterExpression, this.fConfiguration));
        menu.appendToGroup(GROUP_TERM, (IAction)this.fAddAndTerm);
        menu.appendToGroup(GROUP_TERM, (IAction)this.fAddOrTerm);
        MenuManager customAttributesMenu = new MenuManager(Messages.AddConditionActionGroup_CUSTOM_ATTRIBUTES);
        customAttributesMenu.add((IContributionItem)new GroupMarker(GROUP_CUSTOM));
        menu.appendToGroup(GROUP_OTHER, (IContributionItem)customAttributesMenu);
        MenuManager linksMenu = new MenuManager(Messages.AddConditionActionGroup_LINKS);
        linksMenu.add((IContributionItem)new GroupMarker(GROUP_LINKS));
        menu.appendToGroup(GROUP_OTHER, (IContributionItem)linksMenu);
        for (TypeGroupDescriptor typeGroup : this.fConfiguration.getTypeGroups()) {
            AddMultiAttributeConditionAction action = new AddMultiAttributeConditionAction(this.fTerm, this.fAfterExpression, typeGroup.filter(this.fConfiguration.getAttributes()));
            action.setText(typeGroup.getMenuLabel());
            menu.appendToGroup(GROUP_TYPES, (IAction)action);
        }
    }
}

