/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.queryeditor.control;

import com.ibm.team.workitem.ide.ui.internal.queryeditor.control.AbstractConditionControl;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.control.IValidator;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.control.TextControl;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class TextConditionControl
extends AbstractConditionControl {
    private TextControl fTextControl;
    private IValidator fValidator;
    private TextControl.Options fOptions;
    private int fWidthHintInChars = -1;
    private ISelectionChangedListener fSelectionChangedListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            TextConditionControl.this.notifySelectionChanged(event.getSelection());
        }
    };

    public void createContent(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        this.fTextControl = new TextControl(parent, 2052, this.hasInputProvider());
        this.fTextControl.setValidator(this.fValidator, this.fOptions);
        this.fTextControl.addSelectionChangedListener(this.fSelectionChangedListener);
        if (this.fWidthHintInChars > 0) {
            this.fTextControl.setWidthHintInChars(this.fWidthHintInChars);
        }
        this.getSite().getToolkit().adapt((Control)this.fTextControl.getTextControl(), true, false);
    }

    public void setSelection(ISelection selection) {
        if (this.fTextControl != null) {
            this.fTextControl.setSelection(selection);
        }
    }

    public void setFocus() {
        if (this.fTextControl != null) {
            this.fTextControl.setFocus();
        }
    }

    public void setValidator(IValidator validator, TextControl.Options options) {
        this.fValidator = validator;
        this.fOptions = options;
        if (this.fTextControl != null) {
            this.fTextControl.setValidator(validator, options);
        }
    }

    public void setWidthHintInChars(int chars) {
        this.fWidthHintInChars = chars;
        if (this.fTextControl != null) {
            this.fTextControl.setWidthHintInChars(chars);
        }
    }

    protected void inputChanged(Object input) {
        if (this.fTextControl != null) {
            this.fTextControl.setInput(input);
        }
    }
}

