/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.queryeditor.control;

import com.ibm.team.workitem.common.internal.util.ItemHandleAwareHashSet;
import com.ibm.team.workitem.ide.ui.internal.ImagePool;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.QueryEditorToolkit;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.actions.ActionGroupMenuAction;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.control.AbstractConditionControl;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.control.ElementSelectionPopupDialog;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.control.Messages;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.util.DelegatingTreeContentProvider;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.util.VariableAwareComparator;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.util.VariableAwareLabelProvider;
import com.ibm.team.workitem.rcp.ui.internal.util.DefaultViewerComparator;
import com.ibm.team.workitem.rcp.ui.internal.viewer.ItemComparer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckable;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.actions.ActionGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class StructuredViewerControl
extends AbstractConditionControl {
    private static final int MAGIC_WIDTH_IN_CHARS = 30;
    private static final int MAGIC_HEIGHT_IN_LINES = 8;
    private ISelectionChangedListener fSelectionChangedListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            StructuredViewerControl.this.notifySelectionChanged((ISelection)new StructuredSelection(StructuredViewerControl.this.getSelectedElements()));
        }
    };
    private ICheckStateListener fCheckStateListener = new ICheckStateListener(){

        public void checkStateChanged(CheckStateChangedEvent event) {
            StructuredViewerControl.this.notifySelectionChanged((ISelection)new StructuredSelection(StructuredViewerControl.this.getSelectedElements()));
        }
    };
    private DisposeListener fDisposeListener = new DisposeListener(){

        public void widgetDisposed(DisposeEvent e) {
            StructuredViewerControl.this.dispose();
        }
    };
    private KeyAdapter fPopupAdapter = new KeyAdapter(){

        public void keyPressed(KeyEvent e) {
            ElementSelectionPopupDialog dialog;
            if (e.character > ' ' && (dialog = StructuredViewerControl.this.getElementSelectionDialog(String.valueOf(e.character))) != null) {
                e.doit = false;
                dialog.open();
            }
            super.keyPressed(e);
        }
    };
    private int fWidthHintInChars = 30;
    private int fHeightHintInLines = 8;
    private StructuredViewer fViewer;
    private Object fResolvedInput;
    private IBaseLabelProvider fLabelProvider;
    private VariableAwareLabelProvider fPopupLabelProvider;
    private IContentProvider fContentProvider;
    private IContentProvider fPopupContentProvider;
    private ViewerComparator fComparator;
    private ViewerFilter[] fFilters;
    private IElementComparer fElementComparer;

    public void setLabelProvider(IBaseLabelProvider labelProvider) {
        this.fLabelProvider = new VariableAwareLabelProvider(labelProvider);
    }

    public void setPopupLabelProvider(IBaseLabelProvider labelProvider) {
        this.fPopupLabelProvider = new VariableAwareLabelProvider(labelProvider, false);
    }

    public void setContentProvider(IContentProvider contentProvider) {
        this.fContentProvider = contentProvider;
    }

    public void setPopupContentProvider(IContentProvider contentProvider) {
        this.fPopupContentProvider = new DelegatingTreeContentProvider(contentProvider, false);
    }

    public void setElementComparer(IElementComparer comparer) {
        this.fElementComparer = comparer;
    }

    public <T> void setComparator(Comparator<T> comparator) {
        if (comparator == null) {
            this.fComparator = null;
            return;
        }
        this.fComparator = new DefaultViewerComparator(new VariableAwareComparator<T>(comparator));
    }

    public void setFilters(ViewerFilter ... filters) {
        this.fFilters = filters;
    }

    public void setWidthHintInChars(int chars) {
        this.fWidthHintInChars = chars;
    }

    protected int getWidthHintInChars() {
        return this.fWidthHintInChars;
    }

    public void setHeightHintInLines(int lines) {
        this.fHeightHintInLines = lines;
    }

    protected int getHeightHintInLines() {
        return this.fHeightHintInLines;
    }

    @Override
    public void createContent(Composite parent) {
        QueryEditorToolkit toolkit = (QueryEditorToolkit)this.getSite().getToolkit();
        Composite border = toolkit.createBorder(parent);
        this.fViewer = this.createStructuredViewer(border);
        this.fViewer.setComparer((IElementComparer)(this.fElementComparer != null ? this.fElementComparer : new ItemComparer()));
        this.fViewer.setLabelProvider(this.fLabelProvider);
        this.fViewer.setContentProvider(this.fContentProvider);
        this.fViewer.setComparator(this.fComparator);
        this.fViewer.getControl().addKeyListener((KeyListener)this.fPopupAdapter);
        this.fViewer.getControl().addDisposeListener(this.fDisposeListener);
        if (this.fFilters != null) {
            this.fViewer.setFilters(this.fFilters);
        }
        if (this.fViewer instanceof ICheckable) {
            ICheckable checkable = (ICheckable)this.fViewer;
            checkable.addCheckStateListener(this.fCheckStateListener);
        } else {
            this.fViewer.addSelectionChangedListener(this.fSelectionChangedListener);
        }
        GridLayoutFactory.fillDefaults().applyTo(parent);
        GridDataFactory.fillDefaults().grab(true, true).hint(this.getMinWidth(), this.getMinHeight()).applyTo((Control)border);
        this.initializeToolBar();
        this.getSite().showSummary(true);
    }

    private ElementSelectionPopupDialog getElementSelectionDialog(String initialText) {
        if (this.fPopupContentProvider == null) {
            return null;
        }
        ElementSelectionPopupDialog dialog = new ElementSelectionPopupDialog(this.fViewer.getControl().getShell(), 0, false, true, false, Messages.StructuredViewerControl_START_TYPING_INFO_TEXT){

            protected void handleSelection(ISelection selection) {
                StructuredViewerControl.this.handlePopupSelection(selection);
            }
        };
        dialog.setContentProvider(this.fPopupContentProvider);
        dialog.setLabelProvider((IBaseLabelProvider)this.fPopupLabelProvider);
        dialog.setComparator(this.fComparator);
        dialog.setFilters(this.fFilters);
        dialog.setInput(this.getResolvedInput());
        dialog.setInitialFilterText(initialText);
        dialog.setSize(50, 15);
        dialog.setInitialLocation(this.getViewerLocation());
        return dialog;
    }

    private Point getViewerLocation() {
        Point location = this.fViewer.getControl().getLocation();
        return this.fViewer.getControl().getParent().toDisplay(location);
    }

    @Override
    public void setFocus() {
        if (this.fViewer != null) {
            this.fViewer.getControl().setFocus();
        }
    }

    protected StructuredViewer getViewer() {
        return this.fViewer;
    }

    @Override
    protected void inputChanged(Object input) {
        this.getViewer().setInput(input);
        this.fResolvedInput = input;
    }

    protected Object getResolvedInput() {
        return this.fResolvedInput;
    }

    protected void initializeToolBar() {
        ActionGroup filterActions = this.createFilterActionGroup();
        if (filterActions != null) {
            ActionGroupMenuAction filterAction = new ActionGroupMenuAction(Messages.StructuredViewerControl_FILTERS_LABEL);
            filterAction.setActionGroup(filterActions);
            filterAction.setImageDescriptor(ImagePool.FILTER_ICON);
            this.getSite().getToolBarManager().add((IAction)filterAction);
        }
    }

    protected ActionGroup createFilterActionGroup() {
        return null;
    }

    public void setSelection(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            this.setSelectedElements(structuredSelection.toArray());
            this.notifySelectionChanged((ISelection)structuredSelection);
        }
    }

    @Override
    protected void restoreLastSelection(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            this.setSelectedElements(structuredSelection.toArray());
        }
    }

    protected void handlePopupSelection(ISelection selection) {
        if (!selection.isEmpty() && selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            ItemHandleAwareHashSet newSelection = new ItemHandleAwareHashSet();
            newSelection.addAll((Collection)structuredSelection.toList());
            newSelection.addAll(Arrays.asList(this.getSelectedElements()));
            this.setSelection((ISelection)new StructuredSelection(newSelection.toArray()));
        }
    }

    private void dispose() {
        if (this.fPopupContentProvider != null) {
            this.fPopupContentProvider.dispose();
            this.fPopupContentProvider = null;
        }
        if (this.fPopupLabelProvider != null) {
            this.fPopupLabelProvider.disposeDelegate();
            this.fPopupLabelProvider.dispose();
            this.fPopupLabelProvider = null;
        }
    }

    protected abstract StructuredViewer createStructuredViewer(Composite var1);

    protected abstract Object[] getSelectedElements();

    protected abstract void setSelectedElements(Object[] var1);

    protected abstract int getMinWidth();

    protected abstract int getMinHeight();
}

