/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.queryeditor.control;

import com.ibm.team.workitem.common.expression.variables.RelativeDateVariable;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.control.AbstractSelectionProvider;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.control.Messages;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.control.NumberValidator;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.control.TextControl;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class RelativeDatePickerControl
extends AbstractSelectionProvider {
    private TextControl fNumberControl;
    private ComboViewer fTimeUnitCombo;
    private boolean fNotificationSuspended = false;
    private boolean fAllowFutureVariables = true;
    private LabelProvider fTimeUnitLabelProvider = new LabelProvider(){

        public String getText(Object element) {
            if (element instanceof RelativeDateVariable.TimeUnit) {
                RelativeDateVariable.TimeUnit timeUnit = (RelativeDateVariable.TimeUnit)element;
                switch (timeUnit) {
                    case MINUTES_AGO: {
                        return Messages.RelativeDatePickerControl_MINUTES_AGO;
                    }
                    case HOURS_AGO: {
                        return Messages.RelativeDatePickerControl_HOURS_AGO;
                    }
                    case DAYS_AGO: {
                        return Messages.RelativeDatePickerControl_DAYS_AGO;
                    }
                    case MONTHS_AGO: {
                        return Messages.RelativeDatePickerControl_MONTHS_AGO;
                    }
                    case YEARS_AGO: {
                        return Messages.RelativeDatePickerControl_YEARS_AGO;
                    }
                    case MINUTES_FROM_NOW: {
                        return Messages.RelativeDatePickerControl_MINUTES_FROM_NOW;
                    }
                    case HOURS_FROM_NOW: {
                        return Messages.RelativeDatePickerControl_HOURS_FROM_NOW;
                    }
                    case DAYS_FROM_NOW: {
                        return Messages.RelativeDatePickerControl_DAYS_FROM_NOW;
                    }
                    case MONTHS_FROM_NOW: {
                        return Messages.RelativeDatePickerControl_MONTHS_FROM_NOW;
                    }
                    case YEARS_FROM_NOW: {
                        return Messages.RelativeDatePickerControl_YEARS_FROM_NOW;
                    }
                }
            }
            return super.getText(element);
        }
    };
    private ViewerFilter fRangeFilter = new ViewerFilter(){

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (!RelativeDatePickerControl.this.fAllowFutureVariables && element instanceof RelativeDateVariable.TimeUnit) {
                RelativeDateVariable.TimeUnit unit = (RelativeDateVariable.TimeUnit)element;
                return unit.isPast();
            }
            return true;
        }
    };

    public RelativeDatePickerControl(Composite parent) {
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(parent);
        this.fNumberControl = new TextControl(parent, 2052);
        this.fNumberControl.setValidator(NumberValidator.INTEGER_VALIDATOR, TextControl.Options.VERIFY_STRICT);
        this.fNumberControl.setWidthHintInChars(5);
        this.fNumberControl.useMultiSelection(false);
        this.fTimeUnitCombo = new ComboViewer(parent);
        this.fTimeUnitCombo.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.fTimeUnitCombo.setLabelProvider((IBaseLabelProvider)this.fTimeUnitLabelProvider);
        this.fTimeUnitCombo.addFilter(this.fRangeFilter);
        this.fTimeUnitCombo.setInput((Object)RelativeDateVariable.TimeUnit.values());
        this.fTimeUnitCombo.setSelection((ISelection)new StructuredSelection((Object)RelativeDateVariable.TimeUnit.DAYS_AGO));
        GridDataFactory.fillDefaults().grab(true, false).applyTo(this.fTimeUnitCombo.getControl());
        this.installListeners();
    }

    public void setAllowFutureVariables(boolean showFuture) {
        this.fAllowFutureVariables = showFuture;
        if (this.fTimeUnitCombo != null) {
            this.fTimeUnitCombo.refresh();
        }
    }

    private void installListeners() {
        ISelectionChangedListener selectionChangedListener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                RelativeDatePickerControl.this.notifySelectionChanged();
            }
        };
        this.fNumberControl.addSelectionChangedListener(selectionChangedListener);
        this.fTimeUnitCombo.addSelectionChangedListener(selectionChangedListener);
    }

    public void adapt(FormToolkit toolkit) {
        toolkit.adapt((Control)this.fNumberControl.getTextControl(), true, false);
        toolkit.adapt((Control)this.fTimeUnitCombo.getCombo(), true, false);
    }

    public void setSelection(ISelection selection) {
        IStructuredSelection structuredSelection;
        if (selection instanceof IStructuredSelection && (structuredSelection = (IStructuredSelection)selection).getFirstElement() instanceof RelativeDateVariable) {
            RelativeDateVariable variable = (RelativeDateVariable)structuredSelection.getFirstElement();
            boolean hasChanged = false;
            try {
                this.suspendNotification();
                if (this.isNumberControlEmpty() || this.getTimeSpan() != variable.getTimeSpan()) {
                    this.fNumberControl.setSelection((ISelection)new StructuredSelection((Object)variable.getTimeSpan()));
                    hasChanged = true;
                }
                if (this.getTimeUnit() != variable.getTimeUnit()) {
                    this.fTimeUnitCombo.setSelection((ISelection)new StructuredSelection((Object)variable.getTimeUnit()));
                    hasChanged = true;
                }
            }
            finally {
                this.resumeNotification(hasChanged);
            }
        }
    }

    private void suspendNotification() {
        this.fNotificationSuspended = true;
    }

    private void resumeNotification(boolean hasChanged) {
        this.fNotificationSuspended = false;
        if (hasChanged) {
            this.notifySelectionChanged();
        }
    }

    private void notifySelectionChanged() {
        if (this.fNotificationSuspended) {
            return;
        }
        if (this.fNumberControl.isInputValid() && !this.isNumberControlEmpty()) {
            RelativeDateVariable.TimeUnit timeUnit = this.getTimeUnit();
            int timeSpan = this.getTimeSpan();
            RelativeDateVariable variable = new RelativeDateVariable(timeUnit, timeSpan);
            this.notifySelectionChanged((ISelection)new StructuredSelection((Object)variable));
        } else {
            this.notifySelectionChanged((ISelection)StructuredSelection.EMPTY);
        }
    }

    private RelativeDateVariable.TimeUnit getTimeUnit() {
        IStructuredSelection selection = (IStructuredSelection)this.fTimeUnitCombo.getSelection();
        return (RelativeDateVariable.TimeUnit)selection.getFirstElement();
    }

    private int getTimeSpan() {
        IStructuredSelection selection = (IStructuredSelection)this.fNumberControl.getSelection();
        return Integer.parseInt((String)selection.getFirstElement());
    }

    private boolean isNumberControlEmpty() {
        return this.fNumberControl.getSelection().isEmpty();
    }

    public void setFocus() {
        if (this.fNumberControl != null) {
            this.fNumberControl.setFocus();
        }
    }
}

