/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.queryeditor.control;

import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.control.IValidator;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.control.Messages;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NumberValidator {
    public static final IValidator INTEGER_VALIDATOR = new IntegerValidator(null, null);
    public static final IValidator LONG_VALIDATOR = new LongValidator(null, null);
    public static final IValidator FLOAT_VALIDATOR = new FloatValidator(null, null);

    private static <T extends Number> IStatus checkRange(Comparable<T> value, T start, T end) {
        if (start != null && value.compareTo(start) < 0 || end != null && value.compareTo(end) > 0) {
            return NumberValidator.getRangeStatus(start, end);
        }
        return Status.OK_STATUS;
    }

    private static IStatus getRangeStatus(Number start, Number end) {
        String message = NLS.bind((String)Messages.NumberValidator_RANGE_MESSAGE_FORMAT, (Object)start.toString(), (Object[])new Object[]{end.toString()});
        return new Status(4, "com.ibm.team.workitem.ide.ui", message, null);
    }

    private static IStatus getStatus(String input, Throwable e) {
        String message = Messages.NumberValidator_ENTER_NUMBER_MESSAGE;
        return new Status(4, "com.ibm.team.workitem.ide.ui", message, e);
    }

    public static class FloatValidator
    implements IValidator {
        private Float fRangeStart;
        private Float fRangeEnd;

        public FloatValidator(Float rangeStart, Float rangeEnd) {
            this.fRangeStart = rangeStart;
            this.fRangeEnd = rangeEnd;
        }

        public IStatus validate(Object object) {
            String input = object.toString().trim();
            if (input.length() == 0) {
                return Status.OK_STATUS;
            }
            try {
                Float value = Float.valueOf(Float.parseFloat(input));
                return NumberValidator.checkRange(value, this.fRangeStart, this.fRangeEnd);
            }
            catch (NumberFormatException e) {
                return NumberValidator.getStatus(input, e);
            }
        }
    }

    public static class IntegerValidator
    implements IValidator {
        private Integer fRangeStart;
        private Integer fRangeEnd;

        public IntegerValidator(Integer rangeStart, Integer rangeEnd) {
            this.fRangeStart = rangeStart;
            this.fRangeEnd = rangeEnd;
        }

        public IStatus validate(Object object) {
            String input = object.toString().trim();
            if (input.length() == 0) {
                return Status.OK_STATUS;
            }
            try {
                Integer value = Integer.parseInt(object.toString());
                return NumberValidator.checkRange(value, this.fRangeStart, this.fRangeEnd);
            }
            catch (NumberFormatException e) {
                return NumberValidator.getStatus(input, e);
            }
        }
    }

    public static class LongValidator
    implements IValidator {
        private Long fRangeStart;
        private Long fRangeEnd;

        public LongValidator(Long rangeStart, Long rangeEnd) {
            this.fRangeStart = rangeStart;
            this.fRangeEnd = rangeEnd;
        }

        public IStatus validate(Object object) {
            String input = object.toString().trim();
            if (input.length() == 0) {
                return Status.OK_STATUS;
            }
            try {
                Long value = Long.parseLong(object.toString());
                return NumberValidator.checkRange(value, this.fRangeStart, this.fRangeEnd);
            }
            catch (NumberFormatException e) {
                return NumberValidator.getStatus(input, e);
            }
        }
    }
}

