/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.queryeditor.control;

import com.ibm.team.workitem.rcp.ui.internal.util.Utils;
import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;

public class ElementSelectionPopupDialog
extends PopupDialog {
    private ModifyListener fFilterModifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            String text = ElementSelectionPopupDialog.this.fFilterText.getText();
            ElementSelectionPopupDialog.this.fFilteredTree.setFilterString(text);
        }
    };
    private KeyAdapter fKeyAdapter = new KeyAdapter(){

        public void keyPressed(KeyEvent e) {
            if (e.keyCode == 0x1000002 || e.keyCode == 13) {
                ElementSelectionPopupDialog.this.fFilteredTree.selectFirstMatch();
            }
        }
    };
    private IOpenListener fOpenListener = new IOpenListener(){

        public void open(OpenEvent event) {
            ElementSelectionPopupDialog.this.close();
            ElementSelectionPopupDialog.this.handleSelection(event.getSelection());
        }
    };
    private Text fFilterText;
    private CustomFilteredTree fFilteredTree;
    private IContentProvider fContentProvider;
    private IBaseLabelProvider flabelProvider;
    private ViewerComparator fComparator;
    private ViewerFilter[] fFilters;
    private Object fInput;
    private int fWidth = -1;
    private int fHeight = -1;
    private String fInitialText = "";
    private Point fInitialLocation;

    public ElementSelectionPopupDialog(Shell parent, int shellStyle, boolean persistBounds, boolean showDialogMenu, boolean showPersistAction, String infoText) {
        super(parent, shellStyle, true, persistBounds, showDialogMenu, showPersistAction, null, infoText);
    }

    public int open() {
        int result = super.open();
        this.updateInitialText();
        return result;
    }

    public void setSize(int width, int height) {
        this.fWidth = width;
        this.fHeight = height;
    }

    public void setInitialLocation(Point location) {
        this.fInitialLocation = location;
    }

    public void setContentProvider(IContentProvider contentProvider) {
        this.fContentProvider = contentProvider;
        if (this.fFilteredTree != null) {
            this.fFilteredTree.getViewer().setContentProvider(this.fContentProvider);
        }
    }

    public void setLabelProvider(IBaseLabelProvider labelProvider) {
        this.flabelProvider = labelProvider;
        if (this.fFilteredTree != null) {
            this.fFilteredTree.getViewer().setLabelProvider(this.flabelProvider);
        }
    }

    public void setComparator(ViewerComparator comparator) {
        this.fComparator = comparator;
        if (this.fFilteredTree != null) {
            this.fFilteredTree.getViewer().setComparator(this.fComparator);
        }
    }

    public void setFilters(ViewerFilter ... filters) {
        this.fFilters = filters;
    }

    public void setInput(Object input) {
        this.fInput = input;
        if (this.fFilteredTree != null) {
            this.fFilteredTree.getViewer().setInput(this.fInput);
        }
    }

    public void setInitialFilterText(String text) {
        this.fInitialText = text;
    }

    private void updateInitialText() {
        this.fFilterText.setText(this.fInitialText);
        this.fFilterText.setSelection(this.fInitialText.length());
    }

    protected Control createTitleControl(Composite parent) {
        this.fFilterText = new Text(parent, 0);
        this.fFilterText.addModifyListener(this.fFilterModifyListener);
        this.fFilterText.addKeyListener((KeyListener)this.fKeyAdapter);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.fFilterText);
        return this.fFilterText;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.fFilteredTree = new CustomFilteredTree(composite, 0, new PatternFilter());
        TreeViewer viewer = this.fFilteredTree.getViewer();
        viewer.addOpenListener(this.fOpenListener);
        viewer.setContentProvider(this.fContentProvider);
        viewer.setLabelProvider(this.flabelProvider);
        viewer.setComparator(this.fComparator);
        if (this.fFilters != null) {
            ViewerFilter[] viewerFilterArray = this.fFilters;
            int n = this.fFilters.length;
            int n2 = 0;
            while (n2 < n) {
                ViewerFilter filter = viewerFilterArray[n2];
                viewer.addFilter(filter);
                ++n2;
            }
        }
        viewer.setInput(this.fInput);
        viewer.expandAll();
        int widthHint = this.fWidth > -1 ? Utils.convertWidthInCharsToPixels((Control)viewer.getTree(), (int)this.fWidth) : -1;
        int heightHint = this.fHeight > -1 ? viewer.getTree().getItemHeight() * this.fHeight : -1;
        GridDataFactory.fillDefaults().grab(true, true).hint(widthHint, heightHint).applyTo((Control)this.fFilteredTree);
        return composite;
    }

    protected Control getFocusControl() {
        return this.fFilterText;
    }

    protected Point getInitialLocation(Point initialSize) {
        if (this.fInitialLocation != null) {
            return this.fInitialLocation;
        }
        return super.getInitialLocation(initialSize);
    }

    protected void handleSelection(ISelection selection) {
    }

    private static class CustomFilteredTree
    extends FilteredTree {
        private String fFilterString;
        private final PatternFilter fPatternFilter;

        public CustomFilteredTree(Composite parent, int treeStyle, PatternFilter filter) {
            super(parent, treeStyle, filter);
            this.fPatternFilter = filter;
        }

        public void setFilterString(String text) {
            this.fFilterString = text;
            this.textChanged();
        }

        public void selectFirstMatch() {
            TreeItem item = this.getFirstMatch(this.treeViewer.getTree().getItems());
            if (item != null) {
                this.treeViewer.setSelection((ISelection)new StructuredSelection(item.getData()), true);
            }
            this.treeViewer.getTree().setFocus();
        }

        private TreeItem getFirstMatch(TreeItem[] items) {
            TreeItem[] treeItemArray = items;
            if (items.length != 0) {
                TreeItem treeItem = treeItemArray[0];
                if (this.fPatternFilter.isElementVisible((Viewer)this.treeViewer, (Object)treeItem)) {
                    return treeItem;
                }
                return this.getFirstMatch(treeItem.getItems());
            }
            return null;
        }

        protected String getFilterString() {
            return this.fFilterString;
        }

        protected void createControl(Composite parentComposite, int treeStyle) {
            GridLayoutFactory.fillDefaults().applyTo((Composite)this);
            GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this);
            this.treeComposite = new Composite((Composite)this, 0);
            GridLayoutFactory.fillDefaults().applyTo(this.treeComposite);
            GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.treeComposite);
            this.createTreeControl(this.treeComposite, treeStyle);
        }
    }
}

