/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.queryeditor.control;

import com.ibm.icu.text.DateFormat;
import com.ibm.team.jface.JazzResources;
import com.ibm.team.jface.calendar.DatePicker;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.common.internal.util.Daystamp;
import com.ibm.team.workitem.ide.ui.internal.ImagePool;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.control.AbstractSelectionProvider;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.control.IValidator;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.control.Messages;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.control.TextControl;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.Date;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class DatePickerControl
extends AbstractSelectionProvider {
    private ISelectionChangedListener fSelectionChangeListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            DatePickerControl.this.handleSelectionChanged(event);
        }
    };
    private TextControl fTextControl;
    private ToolBar fToolBar;
    private ToolItem fButton;
    private Daystamp fDaystamp;

    public DatePickerControl(Composite parent, int dateFormat) {
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(parent);
        this.fDaystamp = new Daystamp(dateFormat);
        this.fTextControl = new TextControl(parent, 2052);
        this.fTextControl.useMultiSelection(false);
        this.fTextControl.setValidator(new DateValidator(dateFormat), TextControl.Options.VERIFY_WARN);
        this.fTextControl.addSelectionChangedListener(this.fSelectionChangeListener);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.fTextControl.getTextContainer());
        this.fToolBar = new ToolBar(parent, 0x800000);
        this.fToolBar.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        LocalResourceManager resourceManager = new LocalResourceManager(JFaceResources.getResources(), (Control)this.fToolBar);
        Image image = JazzResources.getImageWithDefault((ResourceManager)resourceManager, (ImageDescriptor)ImagePool.DATE);
        this.fButton = new ToolItem(this.fToolBar, 8);
        this.fButton.setToolTipText(Messages.DatePickerControl_PICK_DATE_TOOLTIP);
        this.fButton.setImage(image);
        this.fButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DatePickerControl.this.handleButtonSelected();
            }
        });
    }

    public void setSelection(ISelection selection) {
        IStructuredSelection structuredSelection;
        if (selection instanceof IStructuredSelection && (structuredSelection = (IStructuredSelection)selection).getFirstElement() instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)structuredSelection.getFirstElement();
            this.setTextSelection(timestamp);
        }
    }

    protected void handleButtonSelected() {
        Rectangle bounds = this.fButton.getBounds();
        Point location = new Point(bounds.x, bounds.y + bounds.height);
        location = this.fToolBar.toDisplay(location);
        DatePicker datePicker = new DatePicker(this.fToolBar.getShell());
        datePicker.setLocation(location.x, location.y);
        datePicker.open();
        Date selected = datePicker.getDateObject();
        if (selected != null) {
            this.setTextSelection(new Timestamp(selected.getTime()));
        }
    }

    private void setTextSelection(Timestamp timestamp) {
        this.fDaystamp.setTimestamp(timestamp);
        String formatted = this.fDaystamp.getText();
        this.fTextControl.setSelection((ISelection)new StructuredSelection((Object)formatted));
    }

    private void handleSelectionChanged(SelectionChangedEvent event) {
        if (event.getSelection() instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)event.getSelection();
            if (structuredSelection.isEmpty()) {
                this.notifySelectionChanged((ISelection)StructuredSelection.EMPTY);
            } else {
                ParseException exception = this.fDaystamp.setText(structuredSelection.getFirstElement().toString());
                if (exception == null && this.fDaystamp.getTimestamp() != null) {
                    this.notifySelectionChanged((ISelection)new StructuredSelection((Object)this.fDaystamp.getTimestamp()));
                }
            }
        }
    }

    public void adapt(FormToolkit toolkit) {
        toolkit.adapt((Control)this.fTextControl.getTextControl(), true, false);
        toolkit.adapt((Composite)this.fToolBar);
    }

    public void setFocus() {
        if (this.fToolBar != null) {
            this.fToolBar.setFocus();
        }
    }

    private static class DateValidator
    implements IValidator {
        private DateFormat fDateFormat;
        private IStatus fErrorStatus;

        public DateValidator(int dateFormat) {
            this.fDateFormat = DateFormat.getDateInstance((int)dateFormat);
            String example = NLS.bind((String)Messages.DatePickerControl_EXAMPLE_FORMAT, (Object)this.fDateFormat.format(new Date()), (Object[])new Object[0]);
            this.fErrorStatus = new Status(4, "com.ibm.team.workitem.ide.ui", example);
        }

        public IStatus validate(Object object) {
            String text = object.toString().trim();
            if (text.length() == 0) {
                return Status.OK_STATUS;
            }
            try {
                this.fDateFormat.parse(object.toString());
                return Status.OK_STATUS;
            }
            catch (ParseException e) {
                if (e.getErrorOffset() == text.length()) {
                    return Status.OK_STATUS;
                }
                return this.fErrorStatus;
            }
        }
    }
}

