/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.queryeditor.control;

import com.ibm.team.workitem.ide.ui.internal.queryeditor.control.AbstractConditionControl;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.control.Messages;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class BooleanConditionControl
extends AbstractConditionControl {
    private SelectionAdapter fSelectionListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            BooleanConditionControl.this.handleSelection();
        }
    };
    private Flavour fFlavour;
    private Button fTrueButton;
    private Button fFalseButton;
    private String fTrueLabel;
    private String fFalseLabel;
    private String fDefaultTrueLabel;
    private String fDefaultFalseLabel;

    public BooleanConditionControl(Flavour flavour) {
        this.fFlavour = flavour;
        this.fDefaultTrueLabel = Messages.BooleanConditionControl_BOOLEAN_LITERAL_TRUE;
        this.fDefaultFalseLabel = Messages.BooleanConditionControl_BOOLEAN_LITERAL_FALSE;
    }

    public void createContent(Composite parent) {
        switch (this.fFlavour) {
            case RADIO: {
                this.createRadioContent(parent);
                break;
            }
            case CHECKBOX: {
                this.createCheckBoxContent(parent);
            }
        }
    }

    private void createRadioContent(Composite parent) {
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(parent);
        FormToolkit toolkit = this.getSite().getToolkit();
        this.fTrueButton = toolkit.createButton(parent, this.getTrueLabel(), 16);
        this.fTrueButton.addSelectionListener((SelectionListener)this.fSelectionListener);
        this.fFalseButton = toolkit.createButton(parent, this.getFalseLabel(), 16);
        this.fFalseButton.addSelectionListener((SelectionListener)this.fSelectionListener);
    }

    private void createCheckBoxContent(Composite parent) {
        GridLayoutFactory.fillDefaults().applyTo(parent);
        FormToolkit toolkit = this.getSite().getToolkit();
        this.fTrueButton = toolkit.createButton(parent, this.getTrueLabel(), 32);
        this.fTrueButton.addSelectionListener((SelectionListener)this.fSelectionListener);
    }

    private void handleSelection() {
        this.notifySelectionChanged((ISelection)new StructuredSelection((Object)new Boolean(this.fTrueButton.getSelection())));
    }

    public void setFocus() {
    }

    public void setSelection(ISelection selection) {
        IStructuredSelection structuredSelection;
        if (selection instanceof IStructuredSelection && (structuredSelection = (IStructuredSelection)selection).getFirstElement() instanceof Boolean) {
            Boolean bool = (Boolean)structuredSelection.getFirstElement();
            this.fTrueButton.setSelection(bool.booleanValue());
            if (this.fFalseButton != null) {
                this.fFalseButton.setSelection(bool == false);
            }
        }
    }

    protected void inputChanged(Object input) {
    }

    private String getFalseLabel() {
        if (this.fFalseLabel == null) {
            return this.fDefaultFalseLabel;
        }
        return this.fFalseLabel;
    }

    private String getTrueLabel() {
        if (this.fTrueLabel == null) {
            return this.fDefaultTrueLabel;
        }
        return this.fTrueLabel;
    }

    public void setCustomTrueLabel(String label) {
        this.fTrueLabel = label;
        if (this.fTrueButton != null) {
            this.fTrueButton.setText(this.fTrueLabel);
        }
    }

    public void setCustomFalseLabel(String label) {
        this.fFalseLabel = label;
        if (this.fFalseButton != null) {
            this.fFalseButton.setText(this.fFalseLabel);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Flavour {
        CHECKBOX,
        RADIO;

    }
}

