/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.queryeditor.actions;

import com.ibm.team.workitem.common.expression.IQueryableAttribute;
import com.ibm.team.workitem.common.internal.expression.EditableAttributeExpression;
import com.ibm.team.workitem.common.internal.expression.EditableExpression;
import com.ibm.team.workitem.common.internal.expression.EditableTerm;
import com.ibm.team.workitem.common.model.AttributeOperation;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;

public class AddAttributeConditionAction
extends Action {
    private static final String GROUP_CHILDREN = "children";
    private final EditableTerm fParentTerm;
    private final EditableExpression fAfterExpression;
    private final IQueryableAttribute fAttribute;

    public AddAttributeConditionAction(IQueryableAttribute attribute, EditableTerm parentTerm, EditableExpression afterExpression) {
        super(attribute.getDisplayName());
        this.fAttribute = attribute;
        this.fParentTerm = parentTerm;
        this.fAfterExpression = afterExpression;
    }

    public void fillContextMenu(IMenuManager menu, String groupName) {
        List childAttributes = this.fAttribute.getChildAttributes();
        if (childAttributes.isEmpty()) {
            menu.appendToGroup(groupName, (IAction)this);
        } else {
            MenuManager subMenu = new MenuManager(this.fAttribute.getDisplayName());
            subMenu.add((IContributionItem)new GroupMarker(GROUP_CHILDREN));
            for (IQueryableAttribute attribute : childAttributes) {
                AddAttributeConditionAction action = new AddAttributeConditionAction(attribute, this.fParentTerm, this.fAfterExpression);
                action.fillContextMenu((IMenuManager)subMenu, GROUP_CHILDREN);
            }
            menu.appendToGroup(groupName, (IContributionItem)subMenu);
        }
    }

    public void run() {
        List operators = this.fAttribute.getOperators();
        if (!operators.isEmpty()) {
            EditableAttributeExpression attributeExpression = new EditableAttributeExpression(this.fAttribute, (AttributeOperation)operators.get(0));
            this.fParentTerm.add((EditableExpression)attributeExpression, this.fAfterExpression);
        }
    }
}

