/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.queryeditor;

import com.ibm.team.foundation.common.URIReference;
import com.ibm.team.foundation.rcp.core.hyperlinks.Hyperlinks;
import com.ibm.team.foundation.rcp.ui.internal.util.Utils;
import com.ibm.team.jface.JazzResources;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.workitem.client.IDetailedStatus;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.AbstractItemEditorInput;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.Messages;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.ControlContribution;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.HTMLTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.forms.IMessageManager;
import org.eclipse.ui.forms.editor.SharedHeaderFormEditor;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Form;

public abstract class TitlePart {
    private AbstractItemEditorInput fInput;
    private SharedHeaderFormEditor fEditor;
    private Form fTitleForm;
    private IHyperlinkListener fHyperlinkListener;
    private ResourceManager fResourceManager;

    public void init(SharedHeaderFormEditor editor) {
        this.fEditor = editor;
        this.fTitleForm = this.fEditor.getHeaderForm().getForm().getForm();
        this.fResourceManager = new LocalResourceManager(JFaceResources.getResources(), (Control)this.fTitleForm);
        this.updateTitle();
        this.createContextMenu(this.fTitleForm);
        this.addDragSupport(this.fTitleForm);
        this.createActionArea(this.fTitleForm);
    }

    private void createContextMenu(Form form) {
        IMenuManager menuMgr = form.getMenuManager();
        menuMgr.add((IContributionItem)new Separator("additions"));
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                manager.add((IContributionItem)new Separator("additions"));
            }
        });
        if (menuMgr instanceof MenuManager) {
            this.fEditor.getSite().registerContextMenu(this.fEditor.getSite().getId(), (MenuManager)menuMgr, (ISelectionProvider)new TitleSelectionProvider());
        }
    }

    private void addDragSupport(Form proxy) {
        DragSourceAdapter dragSourcelistener = new DragSourceAdapter(){

            public void dragStart(DragSourceEvent event) {
                IItemHandle element = TitlePart.this.getElement();
                if (element == null) {
                    event.doit = false;
                } else {
                    LocalSelectionTransfer.getTransfer().setSelection((ISelection)new StructuredSelection((Object)element));
                }
            }

            public void dragSetData(DragSourceEvent event) {
                if (LocalSelectionTransfer.getTransfer().isSupportedType(event.dataType)) {
                    event.data = LocalSelectionTransfer.getTransfer().getSelection();
                } else if (HTMLTransfer.getInstance().isSupportedType(event.dataType)) {
                    event.data = Utils.escapeForHTMLTransfer((String)TitlePart.this.getHTML());
                }
            }

            public void dragFinished(DragSourceEvent event) {
                LocalSelectionTransfer.getTransfer().setSelection(null);
            }
        };
        proxy.addTitleDragSupport(4, new Transfer[]{LocalSelectionTransfer.getTransfer(), HTMLTransfer.getInstance()}, (DragSourceListener)dragSourcelistener);
    }

    private void createActionArea(Form titleForm) {
        IToolBarManager toolBarManager = titleForm.getToolBarManager();
        this.installActions(toolBarManager);
        ControlContribution save = new ControlContribution("save"){

            protected Control createControl(Composite parent) {
                final Button button = TitlePart.this.fEditor.getToolkit().createButton(parent, Messages.TitlePart_SAVE_ACTION_LABEL, 8);
                button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        TitlePart.this.fEditor.getSite().getPage().saveEditor((IEditorPart)TitlePart.this.fEditor, false);
                    }
                });
                TitlePart.this.fEditor.addPropertyListener(new IPropertyListener(){

                    public void propertyChanged(Object source, int propId) {
                        if (source instanceof IEditorPart && propId == 257) {
                            button.setEnabled(TitlePart.this.fEditor.isDirty() && TitlePart.this.checkSaveButtonEnablement());
                        }
                    }
                });
                button.setEnabled(TitlePart.this.fEditor.isDirty());
                return button;
            }
        };
        toolBarManager.add((IContributionItem)save);
        ControlContribution saveAs = new ControlContribution("saveAs"){

            protected Control createControl(Composite parent) {
                final Button button = TitlePart.this.fEditor.getToolkit().createButton(parent, Messages.TitlePart_SAVE_AS, 8);
                button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        TitlePart.this.fEditor.doSaveAs();
                    }
                });
                TitlePart.this.fEditor.addPropertyListener(new IPropertyListener(){

                    public void propertyChanged(Object source, int propId) {
                        if (source instanceof IEditorPart && propId == 257) {
                            button.setEnabled(TitlePart.this.fEditor.isSaveAsAllowed());
                        }
                    }
                });
                button.setEnabled(TitlePart.this.fEditor.isSaveAsAllowed());
                return button;
            }
        };
        toolBarManager.add((IContributionItem)saveAs);
        titleForm.updateToolBar();
    }

    protected void updateTitle() {
        this.setImage(this.getImage());
        this.setTitle(this.getTitle());
    }

    protected void setImage(ImageDescriptor imageDescriptor) {
        if (imageDescriptor != null) {
            Image image = JazzResources.getImageWithDefault((ResourceManager)this.getResourceManager(), (ImageDescriptor)imageDescriptor);
            this.setBusy(this.isBusy(), image);
        }
    }

    protected void setTitle(String text) {
        if (text == null || !text.equals(this.fTitleForm.getText())) {
            this.fTitleForm.setText(text);
        }
    }

    private void setBusy(boolean isBusy, Image image) {
        this.fTitleForm.setBusy(isBusy);
        this.fTitleForm.setImage(image);
    }

    private ResourceManager getResourceManager() {
        if (this.fResourceManager == null) {
            this.fResourceManager = new LocalResourceManager(JFaceResources.getResources());
        }
        return this.fResourceManager;
    }

    public void setInput(Object input) {
        this.fInput = input instanceof AbstractItemEditorInput ? (AbstractItemEditorInput)((Object)input) : null;
        this.updateTitle();
    }

    public void setStatus(String title, IDetailedStatus status) {
        IMessageManager messageManager = this.fEditor.getHeaderForm().getMessageManager();
        messageManager.removeAllMessages();
        if (this.fHyperlinkListener != null) {
            this.fTitleForm.removeMessageHyperlinkListener(this.fHyperlinkListener);
            this.fHyperlinkListener = null;
        }
        if (status != null) {
            this.showStatus(messageManager, title, (IStatus)status);
        }
    }

    public void clearStatus() {
        this.setStatus("", null);
    }

    private void showStatus(IMessageManager messageManager, String title, IStatus status) {
        if (status.isOK()) {
            return;
        }
        this.fHyperlinkListener = new ShowStatusListener(this.fEditor.getSite().getShell(), title, status);
        this.fTitleForm.addMessageHyperlinkListener(this.fHyperlinkListener);
        messageManager.addMessage((Object)status, title, null, this.getMessageType(status));
    }

    private int getMessageType(IStatus status) {
        int type;
        switch (status.getSeverity()) {
            case 4: 
            case 8: {
                type = 3;
                break;
            }
            case 2: {
                type = 2;
                break;
            }
            case 1: {
                type = 1;
                break;
            }
            default: {
                type = 0;
            }
        }
        return type;
    }

    public void dispose() {
        if (this.fHyperlinkListener != null) {
            this.fHyperlinkListener = null;
        }
    }

    protected SharedHeaderFormEditor getEditor() {
        return this.fEditor;
    }

    protected String getHTML() {
        URIReference reference = Hyperlinks.create((Object)this.getElement(), (IProgressMonitor)new NullProgressMonitor());
        return String.format("<a href=\"%s\">%s</a>", reference.getURI().toString(), this.getName());
    }

    protected String getName() {
        return this.fInput != null ? this.fInput.getName() : Messages.TitlePart_UNRESOLVED_NAME;
    }

    protected String getTitle() {
        return this.fInput != null ? this.fInput.getTitle() : Messages.TitlePart_UNKNOWN_TITLE;
    }

    protected ImageDescriptor getImage() {
        return this.fInput != null ? this.fInput.getImageDescriptor() : null;
    }

    protected boolean isBusy() {
        return this.fInput != null && this.fInput.isFuture();
    }

    protected IItemHandle getElement() {
        return this.fInput != null ? this.fInput.getItemHandle() : null;
    }

    protected boolean checkSaveButtonEnablement() {
        return true;
    }

    protected abstract void installActions(IToolBarManager var1);

    private static class ShowStatusListener
    extends HyperlinkAdapter {
        private Shell fParentShell;
        private String fTitle;
        private String fMessage;
        private IStatus fStatus;

        public ShowStatusListener(Shell parentShell, String title, IStatus status) {
            this.fParentShell = parentShell;
            this.fTitle = title;
            this.fMessage = status.getMessage();
            String details = status.getException() != null && status.getException().getMessage() != null && status.getException().getMessage().length() > 0 ? status.getException().getMessage() : Messages.TitlePart_STATUS_NO_DETAILS;
            this.fStatus = new Status(status.getSeverity(), status.getPlugin(), status.getCode(), details, status.getException());
        }

        public void linkActivated(HyperlinkEvent e) {
            this.openDialog();
        }

        public void openDialog() {
            ErrorDialog.openError((Shell)this.fParentShell, (String)this.fTitle, (String)this.fMessage, (IStatus)this.fStatus);
        }
    }

    private class TitleSelectionProvider
    implements ISelectionProvider {
        private TitleSelectionProvider() {
        }

        public void addSelectionChangedListener(ISelectionChangedListener listener) {
        }

        public ISelection getSelection() {
            IItemHandle selection = TitlePart.this.getElement();
            return selection != null ? new StructuredSelection((Object)selection) : StructuredSelection.EMPTY;
        }

        public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        }

        public void setSelection(ISelection selection) {
        }
    }
}

