/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.queryeditor;

import com.ibm.team.workitem.ide.ui.internal.queryeditor.Messages;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.QueryEditorToolkit;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class SlushBucket {
    private final Table fAvailableTable;
    private final Table fSelectedTable;
    private final Button fAddButton;
    private final Button fRemoveButton;
    private final Button fAddAllButton;
    private final Button fRemoveAllButton;
    private final Button fUpButton;
    private final Button fDownButton;
    private final Button fDefaultsButton;

    SlushBucket(Composite parent, QueryEditorToolkit toolkit, String availableText, String selectedText) {
        GridLayoutFactory.fillDefaults().margins(0, 5).numColumns(4).applyTo(parent);
        Label availableLabel = toolkit.createLabel(parent, availableText);
        Label selectedLabel = toolkit.createLabel(parent, selectedText);
        Composite availableBorder = toolkit.createBorder(parent);
        Table availableColumnTable = toolkit.createTable(availableBorder, 65538);
        Composite buttonComposite = toolkit.createComposite(parent);
        Button defaultsButton = this.createButton(toolkit, buttonComposite, Messages.SlushBucket_SET_DEFAULTS, 0x1000000);
        Button addButton = this.createButton(toolkit, buttonComposite, ">", 0x1000000);
        Button removeButton = this.createButton(toolkit, buttonComposite, "<", 0x1000000);
        Button addAllButton = this.createButton(toolkit, buttonComposite, ">>", 0x1000000);
        Button removeAllButton = this.createButton(toolkit, buttonComposite, "<<", 0x1000000);
        Composite selectedBorder = toolkit.createBorder(parent);
        Table selectedColumnTable = toolkit.createTable(selectedBorder, 65538);
        Composite upDownComposite = toolkit.createComposite(parent);
        Button moveUpButton = this.createButton(toolkit, upDownComposite, Messages.QueryEditorToolkit_SLUSHBUCKET_MOVE_UP, 0x1000000);
        Button moveDownButton = this.createButton(toolkit, upDownComposite, Messages.QueryEditorToolkit_SLUSHBUCKET_MOVE_DOWN, 0x1000000);
        availableLabel.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        selectedLabel.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        addButton.setToolTipText(Messages.QueryEditorToolkit_SLUSHBUCKET_ADD);
        removeButton.setToolTipText(Messages.QueryEditorToolkit_SLUSHBUCKET_REMOVE);
        addAllButton.setToolTipText(Messages.QueryEditorToolkit_SLUSHBUCKET_ADD_ALL);
        removeAllButton.setToolTipText(Messages.QueryEditorToolkit_SLUSHBUCKET_REMOVE_ALL);
        moveUpButton.setToolTipText(Messages.QueryEditorToolkit_SLUSHBUCKET_MOVE_UP_TOOLTIP);
        moveDownButton.setToolTipText(Messages.QueryEditorToolkit_SLUSHBUCKET_MOVE_DOWN_TOOLTIP);
        FillLayout buttonLayout = new FillLayout(512);
        buttonLayout.spacing = 5;
        buttonLayout.marginWidth = 10;
        buttonComposite.setLayout((Layout)buttonLayout);
        FillLayout upDownLayout = new FillLayout(512);
        buttonLayout.spacing = 5;
        buttonLayout.marginWidth = 10;
        upDownComposite.setLayout((Layout)upDownLayout);
        GridDataFactory.swtDefaults().align(1, 128).applyTo((Control)upDownComposite);
        GridDataFactory.swtDefaults().span(2, 1).applyTo((Control)availableLabel);
        GridDataFactory.swtDefaults().span(2, 1).applyTo((Control)selectedLabel);
        int viewerHeight = availableColumnTable.getItemHeight() * 10;
        GridDataFactory.fillDefaults().grab(true, true).hint(-1, viewerHeight).applyTo((Control)availableBorder);
        GridDataFactory.fillDefaults().grab(true, true).hint(-1, viewerHeight).applyTo((Control)selectedBorder);
        this.fAvailableTable = availableColumnTable;
        this.fSelectedTable = selectedColumnTable;
        this.fAddButton = addButton;
        this.fRemoveButton = removeButton;
        this.fAddAllButton = addAllButton;
        this.fRemoveAllButton = removeAllButton;
        this.fUpButton = moveUpButton;
        this.fDownButton = moveDownButton;
        this.fDefaultsButton = defaultsButton;
        this.installListeners();
    }

    private Button createButton(QueryEditorToolkit toolkit, Composite parent, String text, int style) {
        Button button = toolkit.createButton(parent, text, style);
        button.setBackground(parent.getBackground());
        return button;
    }

    public void updateButtonEnablement() {
        this.updateAvailableButtons();
        this.updateSelectionButtons();
    }

    public void addSelectionListener(SelectionListener listener) {
        this.getAddButton().addSelectionListener(listener);
        this.getAddAllButton().addSelectionListener(listener);
        this.getRemoveButton().addSelectionListener(listener);
        this.getRemoveAllButton().addSelectionListener(listener);
        this.getUpButton().addSelectionListener(listener);
        this.getDownButton().addSelectionListener(listener);
        this.getDefaultsButton().addSelectionListener(listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.getAddButton().removeSelectionListener(listener);
        this.getAddAllButton().removeSelectionListener(listener);
        this.getRemoveButton().removeSelectionListener(listener);
        this.getRemoveAllButton().removeSelectionListener(listener);
        this.getUpButton().removeSelectionListener(listener);
        this.getDownButton().removeSelectionListener(listener);
        this.getDefaultsButton().removeSelectionListener(listener);
    }

    private void installListeners() {
        this.fAvailableTable.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SlushBucket.this.updateAvailableButtons();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                SlushBucket.this.updateAvailableButtons();
            }
        });
        this.fSelectedTable.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SlushBucket.this.updateSelectionButtons();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                SlushBucket.this.updateSelectionButtons();
            }
        });
        this.fSelectedTable.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                SlushBucket.this.adaptColumns(e);
            }
        });
    }

    private void adaptColumns(ControlEvent e) {
        TableColumn tableColumn;
        Table table = (Table)e.widget;
        TableColumn[] columns = table.getColumns();
        int tableWidth = table.getClientArea().width;
        if (tableWidth == 0) {
            return;
        }
        int totalColumnWidth = 0;
        TableColumn[] tableColumnArray = columns;
        int n = columns.length;
        int n2 = 0;
        while (n2 < n) {
            tableColumn = tableColumnArray[n2];
            totalColumnWidth += tableColumn.getWidth();
            ++n2;
        }
        if (totalColumnWidth == 0) {
            return;
        }
        tableColumnArray = columns;
        n = columns.length;
        n2 = 0;
        while (n2 < n) {
            tableColumn = tableColumnArray[n2];
            int currentWidth = tableColumn.getWidth();
            tableColumn.setWidth(currentWidth * tableWidth / totalColumnWidth);
            ++n2;
        }
    }

    private void updateAvailableButtons() {
        this.fAddButton.setEnabled(this.fAvailableTable.getSelectionCount() > 0);
        this.fAddAllButton.setEnabled(this.fAvailableTable.getItemCount() > 0);
    }

    private void updateSelectionButtons() {
        int[] indices = this.fSelectedTable.getSelectionIndices();
        int itemCount = this.fSelectedTable.getItemCount();
        this.fRemoveButton.setEnabled(indices.length > 0);
        this.fRemoveAllButton.setEnabled(itemCount > 0);
        this.fUpButton.setEnabled(this.getMinIndex(indices) > 0);
        this.fDownButton.setEnabled(this.getMaxIndex(indices) < itemCount - 1);
    }

    private int getMaxIndex(int[] indices) {
        int maxIndex = indices.length > 0 ? -1 : Integer.MAX_VALUE;
        int[] nArray = indices;
        int n = indices.length;
        int n2 = 0;
        while (n2 < n) {
            int index = nArray[n2];
            if (index > maxIndex) {
                maxIndex = index;
            }
            ++n2;
        }
        return maxIndex;
    }

    private int getMinIndex(int[] indices) {
        int minIndex = indices.length > 0 ? Integer.MAX_VALUE : -1;
        int[] nArray = indices;
        int n = indices.length;
        int n2 = 0;
        while (n2 < n) {
            int index = nArray[n2];
            if (index < minIndex) {
                minIndex = index;
            }
            ++n2;
        }
        return minIndex;
    }

    public Table getAvailableTable() {
        return this.fAvailableTable;
    }

    public Table getSelectedTable() {
        return this.fSelectedTable;
    }

    public Button getAddButton() {
        return this.fAddButton;
    }

    public Button getRemoveButton() {
        return this.fRemoveButton;
    }

    public Button getAddAllButton() {
        return this.fAddAllButton;
    }

    public Button getRemoveAllButton() {
        return this.fRemoveAllButton;
    }

    public Button getUpButton() {
        return this.fUpButton;
    }

    public Button getDownButton() {
        return this.fDownButton;
    }

    public Button getDefaultsButton() {
        return this.fDefaultsButton;
    }
}

