/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.queryeditor;

import com.ibm.team.workitem.client.DetailedStatus;
import com.ibm.team.workitem.client.IDetailedStatus;
import com.ibm.team.workitem.client.query.IWorkingCopyListener;
import com.ibm.team.workitem.client.query.WorkingCopyChangeEvent;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.Messages;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.QueryEditorErrorInput;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.QueryEditorInput;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.TitlePart;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.actions.RunAction;
import com.ibm.team.workitem.rcp.ui.internal.ImagePool;
import com.ibm.team.workitem.rcp.ui.internal.actions.ActionDelegateAdapter;
import com.ibm.team.workitem.rcp.ui.internal.actions.AddQueryToSubscriptionsAction;
import com.ibm.team.workitem.rcp.ui.internal.util.UIWorkingCopyAdapter;
import org.eclipse.jface.action.ControlContribution;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.forms.editor.SharedHeaderFormEditor;

public class QueryEditorTitlePart
extends TitlePart {
    private IWorkingCopyListener fWorkingCopyListener = new IWorkingCopyListener(){

        public void workingCopyChanged(WorkingCopyChangeEvent event) {
            if (WorkingCopyChangeEvent.EventType.QUERY_SAVED.equals((Object)event.getType())) {
                QueryEditorTitlePart.this.updateAddSubscriptionAction();
            }
        }
    };
    private QueryEditorInput fInput;
    private RunContribution fRunContribution;
    private ActionDelegateAdapter fAddQueryToSubscriptionAction;

    public void init(SharedHeaderFormEditor editor) {
        super.init(editor);
        UIWorkingCopyAdapter adapter = (UIWorkingCopyAdapter)editor.getAdapter(UIWorkingCopyAdapter.class);
        adapter.addListener(this.fWorkingCopyListener);
    }

    public void setInput(Object input) {
        super.setInput(input);
        if (input instanceof QueryEditorInput) {
            this.fInput = (QueryEditorInput)((Object)input);
            this.fAddQueryToSubscriptionAction.setSelection((ISelection)new StructuredSelection((Object)this.fInput.getWorkingCopy().getQueryDescriptor()));
        } else if (input instanceof QueryEditorErrorInput) {
            QueryEditorErrorInput errorInput = (QueryEditorErrorInput)((Object)input);
            this.setStatus(Messages.QueryEditorTitlePart_RESOLVE_INPUT_ERROR, (IDetailedStatus)new DetailedStatus(errorInput.getStatus()));
        }
        this.updateActions();
    }

    public void dispose() {
        UIWorkingCopyAdapter adapter = (UIWorkingCopyAdapter)this.getEditor().getAdapter(UIWorkingCopyAdapter.class);
        adapter.removeListener(this.fWorkingCopyListener);
        super.dispose();
    }

    protected void installActions(IToolBarManager toolBarManager) {
        this.fAddQueryToSubscriptionAction = new ActionDelegateAdapter((IObjectActionDelegate)new AddQueryToSubscriptionsAction(), this.getEditor().getEditorSite().getPart());
        this.fAddQueryToSubscriptionAction.setImageDescriptor(ImagePool.RSS_FEED);
        this.fAddQueryToSubscriptionAction.setToolTipText(Messages.QueryEditorTitlePart_CREATE_RSS_SUBSCRIPTION);
        this.fRunContribution = new RunContribution();
        toolBarManager.add((IAction)this.fAddQueryToSubscriptionAction);
        toolBarManager.add((IContributionItem)this.fRunContribution);
    }

    protected boolean checkSaveButtonEnablement() {
        if (this.fInput != null) {
            String name = this.fInput.getWorkingCopy().getQueryDescriptor().getName();
            return name != null && name.trim().length() > 0;
        }
        return super.checkSaveButtonEnablement();
    }

    private void updateActions() {
        if (this.fInput != null) {
            this.updateAddSubscriptionAction();
            this.fRunContribution.setEnabled(true);
        } else {
            if (this.fRunContribution != null) {
                this.fRunContribution.setEnabled(false);
            }
            if (this.fAddQueryToSubscriptionAction != null) {
                this.fAddQueryToSubscriptionAction.setEnabled(false);
            }
        }
    }

    private void updateAddSubscriptionAction() {
        this.fAddQueryToSubscriptionAction.setEnabled(!this.fInput.getWorkingCopy().getQueryDescriptor().isNewItem());
    }

    private class RunContribution
    extends ControlContribution {
        private Button fButton;

        public RunContribution() {
            super("run");
        }

        protected Control createControl(Composite parent) {
            this.fButton = QueryEditorTitlePart.this.getEditor().getToolkit().createButton(parent, Messages.QueryEditorTitlePart_RUN_ACTION_LABEL, 8);
            this.fButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    RunAction runAction = new RunAction();
                    runAction.setActiveEditor((IAction)runAction, (IEditorPart)QueryEditorTitlePart.this.getEditor());
                    runAction.run();
                }
            });
            return this.fButton;
        }

        public void setEnabled(boolean enabled) {
            if (this.fButton != null) {
                this.fButton.setEnabled(enabled);
            }
        }
    }
}

