/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.queryeditor;

import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.common.expression.IQueryableAttribute;
import com.ibm.team.workitem.common.internal.expression.EditableSortColumn;
import com.ibm.team.workitem.common.internal.query.presentations.IControlPresentationDescriptor;
import com.ibm.team.workitem.common.internal.query.presentations.QueryEditorPresentation;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.Messages;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.contributions.ControlPresentationBindingRegistry;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.contributions.IQueryEditorControlFactory;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.contributions.ShortCut;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.contributions.TypeGroupDescriptor;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.control.IConditionControl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryEditorConfiguration {
    public static final int OPTION_HIGHLIGHT_SUMMARY = 1;
    private static final String LINK_FORMAT = "<p><a>{0}</a><br/>{1}</p>";
    private final QueryEditorPresentation fPresentation;
    private final List<IQueryableAttribute> fAttributes;
    private final List<IQueryableAttribute> fColumnAttributes;
    private final List<IQueryableAttribute> fDefaultColumns;
    private final List<EditableSortColumn> fDefaultSortOrder;
    private int fOptions;

    public QueryEditorConfiguration(QueryEditorPresentation presentation, List<IQueryableAttribute> attributes, List<IQueryableAttribute> columnAttributes, List<IQueryableAttribute> defaultColumns, List<EditableSortColumn> defaultSortOrder, int options) {
        this.fPresentation = presentation;
        this.fAttributes = Collections.unmodifiableList(attributes);
        this.fColumnAttributes = Collections.unmodifiableList(columnAttributes);
        this.fDefaultColumns = Collections.unmodifiableList(defaultColumns);
        this.fDefaultSortOrder = Collections.unmodifiableList(defaultSortOrder);
        this.fOptions = options;
    }

    public IConditionControl createConditionControl(IQueryableAttribute attribute) {
        IControlPresentationDescriptor descriptor = this.fPresentation.getControlPresentationDescriptor(attribute);
        IQueryEditorControlFactory factory = ControlPresentationBindingRegistry.getInstance().getBinding(attribute, this.fPresentation);
        return factory != null ? factory.createConditionControl(descriptor) : null;
    }

    public boolean supports(IQueryableAttribute attribute) {
        IControlPresentationDescriptor descriptor = this.fPresentation.getControlPresentationDescriptor(attribute);
        if (descriptor.getPresentationIdentifier() != null) {
            return ControlPresentationBindingRegistry.getInstance().hasBinding(descriptor.getPresentationIdentifier());
        }
        IQueryEditorControlFactory factory = ControlPresentationBindingRegistry.getInstance().getBinding(attribute, this.fPresentation);
        return factory != null;
    }

    public List<TypeGroupDescriptor> getTypeGroups() {
        ArrayList<TypeGroupDescriptor> typeGroups = new ArrayList<TypeGroupDescriptor>(3);
        typeGroups.add(new TypeGroupDescriptor("contributor", Messages.QueryEditorConfiguration_USERGROUP_SECTION_NAME, Messages.QueryEditorConfiguration_USERGROUP_MENU_NAME));
        typeGroups.add(new TypeGroupDescriptor("timestamp", Messages.QueryEditorConfiguration_DATEGROUP_SECTION_NAME, Messages.QueryEditorConfiguration_DATEGROUP_MENU_NAME));
        typeGroups.add(new TypeGroupDescriptor("mediumHtml", Messages.QueryEditorConfiguration_TEXTGROUP_SECTION_NAME, Messages.QueryEditorConfiguration_TEXTGROUP_MENU_NAME, true));
        return typeGroups;
    }

    public List<ShortCut> getShortCuts() {
        ArrayList<ShortCut> shortCuts = new ArrayList<ShortCut>();
        String[] simpleQueryAttributes = new String[]{IWorkItem.STATE_PROPERTY, IWorkItem.CATEGORY_PROPERTY, IWorkItem.OWNER_PROPERTY, "all"};
        String simpleQueryDescription = NLS.bind((String)LINK_FORMAT, (Object)Messages.QueryEditorConfiguration_SIMPLEQUERY_TITLE, (Object[])new Object[]{Messages.QueryEditorConfiguration_SIMPLEQUERY_DESCRIPTION});
        shortCuts.add(new ShortCut(simpleQueryDescription, Arrays.asList(simpleQueryAttributes)));
        String[] textQueryAttributes = new String[]{"all"};
        String textQueryDescription = NLS.bind((String)LINK_FORMAT, (Object)Messages.QueryEditorConfiguration_FULLTEXTQUERY_TITLE, (Object[])new Object[]{Messages.QueryEditorConfiguration_FULLTEXTQUERY_DESCRIPTION});
        shortCuts.add(new ShortCut(textQueryDescription, Arrays.asList(textQueryAttributes)));
        return shortCuts;
    }

    public List<IQueryableAttribute> getAttributes() {
        return this.fAttributes;
    }

    public List<IQueryableAttribute> getColumnAttributes() {
        return this.fColumnAttributes;
    }

    public List<IQueryableAttribute> getDefaultColumns() {
        return this.fDefaultColumns;
    }

    public List<EditableSortColumn> getDefaultSortOrder() {
        return this.fDefaultSortOrder;
    }

    public boolean hasOption(int option) {
        return (this.fOptions & option) != 0;
    }
}

