/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.queryeditor;

import com.ibm.team.jface.JazzResources;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.ui.editor.TeamFormColors;
import com.ibm.team.ui.editor.TeamFormEditor;
import com.ibm.team.ui.editor.TeamFormPage;
import com.ibm.team.ui.editor.TeamFormPartContainer;
import com.ibm.team.workitem.client.DetailedStatus;
import com.ibm.team.workitem.client.IDetailedStatus;
import com.ibm.team.workitem.client.query.IQueryDescriptorWorkingCopy;
import com.ibm.team.workitem.client.query.IWorkingCopyListener;
import com.ibm.team.workitem.client.query.WorkingCopyChangeEvent;
import com.ibm.team.workitem.common.query.IQueryDescriptorHandle;
import com.ibm.team.workitem.ide.ui.internal.WorkItemIDEUIPlugin;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.IBackgroundLoadingListener;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.Messages;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.QueryEditorErrorInput;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.QueryEditorHeaderSection;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.QueryEditorInput;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.QueryEditorInputFuture;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.QueryEditorLayoutFactories;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.QueryEditorTitlePart;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.QueryEditorToolkit;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.QueryOutlinePage;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.contributions.IQueryEditorLayoutFactory;
import com.ibm.team.workitem.rcp.ui.internal.util.UIWorkingCopyAdapter;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.forms.FormColors;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.forms.editor.SharedHeaderFormEditor;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class QueryEditor
extends TeamFormEditor {
    private static final String EDITOR_ID = "com.ibm.team.workitem.queryeditor";
    private static final String QUERY_CONTEXT = "com.ibm.team.workitem.query";
    private QueryEditorTitlePart fTitlePart;
    private QueryOutlinePage fOutlinePage;
    private QueryEditorToolkit fToolKit;
    private final UIWorkingCopyAdapter fUIWorkingCopyAdapter;
    private IWorkingCopyListener fWorkingCopyListener = new IWorkingCopyListener(){

        public void workingCopyChanged(WorkingCopyChangeEvent event) {
            QueryEditor.this.handleWorkingCopyChanged(event);
        }
    };
    private IBackgroundLoadingListener fLoadingListener = new IBackgroundLoadingListener(){

        public void loadingCompleted(IEditorInput input) {
            QueryEditor.this.handleLoadingCompleted(input);
        }
    };

    public QueryEditor() {
        this.fUIWorkingCopyAdapter = new UIWorkingCopyAdapter();
        this.fUIWorkingCopyAdapter.addListener(this.fWorkingCopyListener);
    }

    protected void addPages() {
        try {
            IEditorInput input = this.getEditorInput();
            if (input instanceof QueryEditorInputFuture) {
                QueryEditorInputFuture inputFuture = (QueryEditorInputFuture)input;
                this.addPage((IEditorPart)new TeamFormPage((FormEditor)this, "com.ibm.team.workitem.query.editor.page.loading", input.getName()), inputFuture);
                this.setPartName(input.getName());
                inputFuture.addLoadingListener(this.fLoadingListener);
            } else if (input instanceof QueryEditorInput) {
                this.setPartName(input.getName());
                this.setTitleImage(JazzResources.getImageWithDefault((ResourceManager)this.fToolKit.getResourceManager(), (ImageDescriptor)input.getImageDescriptor()));
                IQueryDescriptorWorkingCopy workingCopy = ((QueryEditorInput)input).getWorkingCopy();
                workingCopy.addListener((IWorkingCopyListener)this.fUIWorkingCopyAdapter);
                IQueryEditorLayoutFactory factory = QueryEditorLayoutFactories.getInstance().getFactory(workingCopy.getQueryDescriptor());
                for (IEditorPart page : factory.createPages()) {
                    if (page instanceof IFormPage) {
                        IFormPage formPage = (IFormPage)page;
                        formPage.initialize((FormEditor)this);
                        this.addPage(formPage);
                        continue;
                    }
                    this.addPage(page, input);
                }
            } else if (input instanceof QueryEditorErrorInput) {
                this.addPage((IEditorPart)new TeamFormPage((FormEditor)this, "com.ibm.team.workitem.query.editor.page.error", Messages.QueryEditor_ERROR_TAB_NAME), input);
                this.setPartName(Messages.QueryEditor_ERROR_PART_NAME);
            }
        }
        catch (PartInitException e) {
            WorkItemIDEUIPlugin.getDefault().log(Messages.QueryEditor_OPEN_FAILED, e);
        }
    }

    protected Composite createPageContainer(Composite parent) {
        IContextService contextService = (IContextService)this.getSite().getService(IContextService.class);
        contextService.activateContext(QUERY_CONTEXT);
        return super.createPageContainer(parent);
    }

    protected void setInput(IEditorInput input) {
        this.releaseEditorInput(this.getEditorInput());
        if (this.fTitlePart != null) {
            this.fTitlePart.setInput(input);
        }
        if (this.fOutlinePage != null) {
            this.fOutlinePage.setInput(input);
        }
        super.setInput(input);
    }

    protected void createHeaderContents(IManagedForm headerForm) {
        this.fTitlePart = new QueryEditorTitlePart();
        this.fTitlePart.init((SharedHeaderFormEditor)this);
        this.fTitlePart.setInput(this.getEditorInput());
        QueryEditorHeaderSection headerSection = new QueryEditorHeaderSection();
        Composite head = headerForm.getForm().getForm().getHead();
        Control headClient = TeamFormPartContainer.setup((TeamFormPartContainer)headerSection, (IManagedForm)headerForm, (Composite)head);
        headerForm.addPart((IFormPart)headerSection);
        headerForm.getForm().setHeadClient(headClient);
    }

    protected FormToolkit createToolkit(Display display) {
        this.fToolKit = new QueryEditorToolkit((FormColors)new TeamFormColors(display));
        return this.fToolKit;
    }

    public void doSave(IProgressMonitor monitor) {
        super.doSave(monitor);
        IEditorInput input = this.getEditorInput();
        if (input instanceof QueryEditorInput) {
            final IQueryDescriptorWorkingCopy workingCopy = ((QueryEditorInput)input).getWorkingCopy();
            if (!this.validate(workingCopy)) {
                return;
            }
            IDetailedStatus status = this.runLongOperation(new IRunnableWithProgress(){

                public void run(IProgressMonitor operationMonitor) throws InvocationTargetException, InterruptedException {
                    try {
                        try {
                            operationMonitor.beginTask(Messages.QueryEditor_SAVE_JOB_NAME, 100);
                            workingCopy.save((IProgressMonitor)new SubProgressMonitor(operationMonitor, 100));
                        }
                        catch (TeamRepositoryException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                    finally {
                        operationMonitor.done();
                    }
                }
            }, Messages.QueryEditor_SAVE_ERROR);
            if (status.isOK()) {
                this.handleSuccessfulSave(status);
            } else {
                this.handleFailedSave(status);
            }
        }
    }

    private boolean validate(IQueryDescriptorWorkingCopy workingCopy) {
        String name = workingCopy.getQueryDescriptor().getName();
        if (name == null || "".equals(name)) {
            this.setStatus(Messages.QueryEditor_NAME_VALIDATION_ERROR, (IDetailedStatus)new DetailedStatus(2, "com.ibm.team.workitem.ide.ui", 2, Messages.QueryEditor_NAME_VALIDATION_ACTIONREQUEST, null));
            return false;
        }
        return true;
    }

    private void handleSuccessfulSave(IDetailedStatus status) {
        this.firePropertyChange(257);
        this.setPartName(this.getEditorInput().getName());
        this.setStatus("", status);
    }

    private void handleFailedSave(IDetailedStatus status) {
        this.setStatus(Messages.QueryEditor_SAVE_PROBLEM, status);
    }

    public void doSaveAs() {
        IEditorInput input = this.getEditorInput();
        if (input instanceof QueryEditorInput) {
            IQueryDescriptorWorkingCopy workingCopy = ((QueryEditorInput)input).getWorkingCopy();
            if (!this.validate(workingCopy)) {
                return;
            }
            String name = NLS.bind((String)Messages.QueryEditor_COPY_OF_PATTERN, (Object)workingCopy.getQueryDescriptor().getName(), (Object[])new Object[0]);
            boolean copyAssociations = false;
            List publicAssociations = workingCopy.getQueryDescriptor().getAssociations().getPublicContents();
            if (!publicAssociations.isEmpty()) {
                copyAssociations = MessageDialog.openQuestion((Shell)this.getSite().getShell(), (String)Messages.QueryEditor_SAVE_AS_TITLE, (String)Messages.QueryEditor_COPY_SHARING_CONFIRMATION);
            }
            this.doSaveAs(name, workingCopy, copyAssociations);
        }
    }

    private void doSaveAs(final String name, final IQueryDescriptorWorkingCopy workingCopy, final boolean copyAssociations) {
        final IQueryDescriptorHandle[] result = new IQueryDescriptorHandle[1];
        IDetailedStatus status = this.runLongOperation(new IRunnableWithProgress(){

            public void run(IProgressMonitor operationMonitor) throws InvocationTargetException, InterruptedException {
                try {
                    try {
                        operationMonitor.beginTask(Messages.QueryEditor_SAVE_JOB_NAME, 100);
                        result[0] = workingCopy.saveCopy(name, copyAssociations, operationMonitor);
                    }
                    catch (TeamRepositoryException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    operationMonitor.done();
                }
            }
        }, Messages.QueryEditor_SAVE_ERROR);
        if (status.isOK()) {
            QueryEditorInputFuture future = new QueryEditorInputFuture(result[0]);
            future.setOption(1);
            try {
                this.getSite().getWorkbenchWindow().getActivePage().openEditor((IEditorInput)future, EDITOR_ID);
            }
            catch (PartInitException e) {
                WorkItemIDEUIPlugin.getDefault().log(Messages.QueryEditor_OPEN_ERROR, e);
            }
        } else {
            this.handleFailedSave(status);
        }
    }

    public boolean isSaveAsAllowed() {
        if (this.getEditorInput() instanceof QueryEditorInput) {
            QueryEditorInput input = (QueryEditorInput)this.getEditorInput();
            return !input.getWorkingCopy().getQueryDescriptor().isNewItem();
        }
        return false;
    }

    public boolean isDirty() {
        IEditorInput input = this.getEditorInput();
        if (input instanceof QueryEditorInput) {
            IQueryDescriptorWorkingCopy workingCopy = ((QueryEditorInput)input).getWorkingCopy();
            return workingCopy.isDirty();
        }
        return super.isDirty();
    }

    private void handleLoadingCompleted(IEditorInput input) {
        Composite container = this.getContainer();
        if (container != null && !container.isDisposed()) {
            this.removePages();
            this.setInput(input);
            this.addPages();
            this.showInitialPage();
            this.firePropertyChange(258);
            this.firePropertyChange(257);
        }
    }

    private void showInitialPage() {
        this.setActivePage(0);
    }

    private void handleWorkingCopyChanged(WorkingCopyChangeEvent event) {
        switch (event.getType()) {
            case EXPRESSION_CHANGED: 
            case QUERY_ATTRIBUTE_CHANGED: 
            case QUERY_SAVED: {
                this.firePropertyChange(257);
                break;
            }
            case QUERY_DELETED: {
                this.close(false);
            }
        }
    }

    private void releaseEditorInput(IEditorInput editorInput) {
        if (editorInput instanceof QueryEditorInput) {
            QueryEditorInput input = (QueryEditorInput)editorInput;
            input.getWorkingCopy().removeListener((IWorkingCopyListener)this.fUIWorkingCopyAdapter);
            input.release();
        }
    }

    public Object getAdapter(Class adapter) {
        if (UIWorkingCopyAdapter.class.equals((Object)adapter)) {
            return this.fUIWorkingCopyAdapter;
        }
        return super.getAdapter(adapter);
    }

    public void dispose() {
        this.releaseEditorInput(this.getEditorInput());
        super.dispose();
    }

    private void setStatus(String statusMessage, IDetailedStatus status) {
        this.fTitlePart.setStatus(statusMessage, status);
    }

    private IDetailedStatus runLongOperation(IRunnableWithProgress runnable, String defaultErrorMessage) {
        try {
            this.getSite().getWorkbenchWindow().run(true, true, runnable);
            return new DetailedStatus(Status.OK_STATUS);
        }
        catch (InvocationTargetException x) {
            return this.createDetailedStatus(x.getTargetException(), defaultErrorMessage);
        }
        catch (InterruptedException x) {
            throw new OperationCanceledException(x.getMessage());
        }
    }

    private IDetailedStatus createDetailedStatus(Throwable exception, String defaultMessage) {
        String msg = exception.getMessage();
        if (msg == null || msg.trim().length() == 0) {
            msg = defaultMessage;
        } else {
            exception = null;
        }
        return new DetailedStatus(4, "com.ibm.team.workitem.ide.ui", 0, msg, exception);
    }
}

