/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.queryeditor;

import com.ibm.team.foundation.client.util.FoundationJob;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.AbstractItemEditorInput;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.IBackgroundLoadingListener;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.Messages;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractItemEditorInputFuture
extends AbstractItemEditorInput {
    private List<IBackgroundLoadingListener> fWaitingEditors = new ArrayList<IBackgroundLoadingListener>(1);
    private Object fMutex = new Object();
    private boolean fIsLoading = false;
    private boolean fIsDone = false;
    private String fName;
    private IEditorInput fEditorInput;

    protected abstract IEditorInput constructEditorInput(IProgressMonitor var1);

    protected AbstractItemEditorInputFuture(IItemHandle handle) {
        super(handle);
    }

    protected AbstractItemEditorInputFuture(IItemHandle handle, String activePageId) {
        super(handle, activePageId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLoadingListener(IBackgroundLoadingListener loadingListener) {
        ArrayList<IBackgroundLoadingListener> loadingListeners = null;
        Object object = this.fMutex;
        synchronized (object) {
            this.fWaitingEditors.add(loadingListener);
            if (!this.fIsLoading && !this.fIsDone) {
                this.fIsLoading = true;
                this.startLoadingThread();
            } else if (this.fIsDone) {
                loadingListeners = new ArrayList<IBackgroundLoadingListener>(this.fWaitingEditors);
            }
        }
        if (loadingListeners != null) {
            this.notifyEditors(this.fEditorInput, loadingListeners);
        }
    }

    private void startLoadingThread() {
        Job.getJobManager().cancel((Object)this.getItemHandle());
        String jobName = Messages.AbstractItemEditorInputFuture_LOADING_JOB_NAME;
        FoundationJob job = new FoundationJob(jobName){

            public boolean belongsTo(Object family) {
                if (family instanceof IItemHandle) {
                    return AbstractItemEditorInputFuture.this.getItemHandle().sameItemId((IItemHandle)family);
                }
                return false;
            }

            public IStatus runProtected(IProgressMonitor monitor) {
                AbstractItemEditorInputFuture.this.fEditorInput = AbstractItemEditorInputFuture.this.constructEditorInput(monitor);
                AbstractItemEditorInputFuture.this.fName = AbstractItemEditorInputFuture.this.fEditorInput.getName();
                return Status.OK_STATUS;
            }
        };
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void done(IJobChangeEvent event) {
                Object object = AbstractItemEditorInputFuture.this.fMutex;
                synchronized (object) {
                    AbstractItemEditorInputFuture.this.fIsLoading = false;
                    AbstractItemEditorInputFuture.this.fIsDone = true;
                }
                AbstractItemEditorInputFuture.this.notifyWaitingEditors(AbstractItemEditorInputFuture.this.fEditorInput);
            }
        });
        job.schedule();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyWaitingEditors(IEditorInput input) {
        ArrayList<IBackgroundLoadingListener> editors = null;
        Object object = this.fMutex;
        synchronized (object) {
            editors = new ArrayList<IBackgroundLoadingListener>(this.fWaitingEditors);
            this.fWaitingEditors.clear();
        }
        this.notifyEditors(input, editors);
    }

    private void notifyEditors(final IEditorInput input, ArrayList<IBackgroundLoadingListener> editors) {
        Iterator<IBackgroundLoadingListener> iterator = editors.iterator();
        while (iterator.hasNext()) {
            IBackgroundLoadingListener listener;
            final IBackgroundLoadingListener editor = listener = iterator.next();
            Display.getDefault().asyncExec(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    editor.loadingCompleted(input);
                    Object object = AbstractItemEditorInputFuture.this.fMutex;
                    synchronized (object) {
                        AbstractItemEditorInputFuture.this.fIsLoading = false;
                        AbstractItemEditorInputFuture.this.fIsDone = false;
                        AbstractItemEditorInputFuture.this.fEditorInput = null;
                    }
                }
            });
        }
    }

    public String getName() {
        return this.fName == null ? "..." : this.fName;
    }

    public String getToolTipText() {
        return this.getName();
    }

    @Override
    public boolean isFuture() {
        return true;
    }
}

