/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.preview.presentations;

import com.ibm.team.jface.JazzResources;
import com.ibm.team.process.common.IDevelopmentLine;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.process.common.ITeamAreaHandle;
import com.ibm.team.process.internal.ide.ui.ImagePool;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.common.model.ItemProfile;
import com.ibm.team.workitem.ide.ui.internal.preview.presentations.CollectionAwareAttributeMarkupPart;
import com.ibm.team.workitem.ide.ui.internal.preview.presentations.MarkupBuilder;
import com.ibm.team.workitem.ide.ui.internal.preview.presentations.Messages;
import java.net.URI;
import java.net.URL;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;

public class ProcessAreaAttributeMarkupPart
extends CollectionAwareAttributeMarkupPart {
    protected void fillValueContent(Object value, MarkupBuilder builder, IProgressMonitor monitor) throws TeamRepositoryException {
        try {
            this.internalFillPartContent(value, builder, monitor);
        }
        catch (TeamRepositoryException e) {
            this.handleException(builder, e);
        }
    }

    private void internalFillPartContent(Object value, MarkupBuilder builder, IProgressMonitor monitor) throws TeamRepositoryException {
        if (value instanceof IProcessAreaHandle) {
            IProcessAreaHandle handle = (IProcessAreaHandle)value;
            IProcessArea processArea = (IProcessArea)this.getAuditableClient().resolveAuditable((IAuditableHandle)handle, ItemProfile.PROCESS_AREA_DEFAULT, monitor);
            URI uri = this.toURI((IItemHandle)processArea);
            ImageDescriptor descriptor = this.getImageDescriptor(processArea);
            URL iconURL = JazzResources.createURL((ImageDescriptor)descriptor);
            if (iconURL != null) {
                builder.image(iconURL.toString(), processArea.getName());
                builder.imageLink(uri.toString(), this.getLabel(processArea, monitor));
            } else {
                builder.link(uri.toString(), this.getLabel(processArea, monitor));
            }
        } else if (value != null) {
            builder.plain(value.toString());
        }
    }

    private String getLabel(IProcessArea processArea, IProgressMonitor monitor) throws TeamRepositoryException {
        IDevelopmentLine developmentLine;
        if (processArea instanceof ITeamArea && (developmentLine = this.getAuditableCommon().getDevelopmentLine((ITeamAreaHandle)processArea.getItemHandle(), monitor)) != null) {
            return NLS.bind((String)Messages.ProcessAreaAttributeMarkupPart_TEAM_AREA_LABEL, (Object)processArea.getName(), (Object[])new Object[]{developmentLine.getLabel()});
        }
        return processArea.getName();
    }

    private ImageDescriptor getImageDescriptor(IProcessArea processArea) {
        if (processArea instanceof IProjectArea) {
            return ImagePool.PROJECT_AREA;
        }
        return ImagePool.TEAM_AREA_NOT_CUSTOMIZED;
    }
}

