/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.preview.presentations;

import com.ibm.team.repository.common.util.ExtensionRegistryReader;
import com.ibm.team.repository.common.util.ExtensionRegistryReaderListener;
import com.ibm.team.workitem.ide.ui.internal.WorkItemIDEUIPlugin;
import com.ibm.team.workitem.ide.ui.internal.preview.presentations.ApprovalsMarkupLayout;
import com.ibm.team.workitem.ide.ui.internal.preview.presentations.CustomAttributesMarkupLayout;
import com.ibm.team.workitem.ide.ui.internal.preview.presentations.HeaderMarkupLayout;
import com.ibm.team.workitem.ide.ui.internal.preview.presentations.HistoryMarkupLayout;
import com.ibm.team.workitem.ide.ui.internal.preview.presentations.LinksMarkupLayout;
import com.ibm.team.workitem.ide.ui.internal.preview.presentations.MarkupLayout;
import com.ibm.team.workitem.ide.ui.internal.preview.presentations.MarkupPart;
import com.ibm.team.workitem.ide.ui.internal.preview.presentations.Messages;
import com.ibm.team.workitem.ide.ui.internal.preview.presentations.OldHeaderMarkupLayout;
import com.ibm.team.workitem.ide.ui.internal.preview.presentations.OverviewMarkupLayout;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MarkupPresentationsManager
implements ExtensionRegistryReaderListener<Object> {
    private static final String MARKUP_PRESENTATIONS_EXTENSION_POINT = "clientMarkupPresentationOverride";
    private static final String MARKUP_PRESENTATIONS_ID_ATTRIBUTE = "id";
    private static final String MARKUP_PRESENTATIONS_CLASS_ATTRIBUTE = "class";
    public static final String HEADER_LAYOUT_ID = "internalHeader";
    private static final String OVERVIEW_LAYOUT = "builtInOverviewLayout";
    private static final String LINKS_LAYOUT = "builtInLinksLayout";
    private static final String APPROVALS_LAYOUT = "builtInApprovalsLayout";
    private static final String HISTORY_LAYOUT = "builtInHistoryLayout";
    private static final String CUSTOM_ATTRIBUTES_LAYOUT = "builtInCustomAttributesLayout";
    public static final String STATE_PRESENTATION_KIND = "com.ibm.team.workitem.ide.ui.internal.preview.fixed.presentations.State";
    public static final String RESOLUTION_PRESENTATION_KIND = "com.ibm.team.workitem.ide.ui.internal.preview.fixed.presentations.Resolution";
    public static final String OLD_HEADER_LAYOUT = "builtInHeaderLayout";
    private static MarkupPresentationsManager fgInstance = new MarkupPresentationsManager();
    private final Map<String, IConfigurationElement> fPresentations = new HashMap<String, IConfigurationElement>();
    private final Map<String, MarkupLayout> fLayouts = new HashMap<String, MarkupLayout>();

    private MarkupPresentationsManager() {
        ExtensionRegistryReader<Object> extensionReader = new ExtensionRegistryReader<Object>("com.ibm.team.workitem.ide.ui", MARKUP_PRESENTATIONS_EXTENSION_POINT){};
        extensionReader.addListener((ExtensionRegistryReaderListener)this);
        extensionReader.start();
        this.initLayouts();
    }

    private void initLayouts() {
        this.fLayouts.put(HEADER_LAYOUT_ID, new HeaderMarkupLayout());
        this.fLayouts.put(OVERVIEW_LAYOUT, new OverviewMarkupLayout());
        this.fLayouts.put(OLD_HEADER_LAYOUT, new OldHeaderMarkupLayout());
        this.fLayouts.put(APPROVALS_LAYOUT, new ApprovalsMarkupLayout());
        this.fLayouts.put(LINKS_LAYOUT, new LinksMarkupLayout());
        this.fLayouts.put(CUSTOM_ATTRIBUTES_LAYOUT, new CustomAttributesMarkupLayout());
        this.fLayouts.put(HISTORY_LAYOUT, new HistoryMarkupLayout());
    }

    public static MarkupPresentationsManager getInstance() {
        return fgInstance;
    }

    public MarkupPart getPart(String kind) {
        IConfigurationElement configElement = this.fPresentations.get(kind);
        if (configElement != null) {
            try {
                return (MarkupPart)configElement.createExecutableExtension(MARKUP_PRESENTATIONS_CLASS_ATTRIBUTE);
            }
            catch (CoreException e) {
                WorkItemIDEUIPlugin.getDefault().log(Messages.MarkupPresentationsManager_ERROR_CREATING_MARKUP, e);
            }
        }
        return null;
    }

    public MarkupLayout getLayout(String id) {
        return this.fLayouts.get(id);
    }

    public void handleExtensionAdded(IConfigurationElement element, Object descriptor) throws Exception {
        String id = element.getAttribute(MARKUP_PRESENTATIONS_ID_ATTRIBUTE);
        this.fPresentations.put(id, element);
    }

    public void handleExtensionRemoved(IConfigurationElement element, Object descriptor) throws Exception {
        String id = element.getAttribute(MARKUP_PRESENTATIONS_ID_ATTRIBUTE);
        this.fPresentations.remove(id);
    }

    public void handleBundleStarted(String bundleSymbolicName, List<IConfigurationElement> elements, List<Object> descriptors) throws Exception {
    }

    public void handleBundleStopped(String bundleSymbolicName, List<IConfigurationElement> elements, List<Object> descriptors) throws Exception {
    }
}

