/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.preview.presentations;

import com.ibm.team.foundation.common.LinkDetector;
import com.ibm.team.foundation.common.TextLinkDetector;
import com.ibm.team.foundation.common.TextLinkDetectorManager;
import com.ibm.team.foundation.common.URILinkDetector;
import com.ibm.team.jface.preview.IDomainAdapter;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.client.IAuditableClient;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.IWorkItemCommon;
import com.ibm.team.workitem.common.internal.WorkItemCommon;
import com.ibm.team.workitem.common.internal.model.WorkItemAttributes;
import com.ibm.team.workitem.common.internal.presentations.AbstractPresentationDescriptor;
import com.ibm.team.workitem.common.internal.presentations.AttributeTypePresentationIdBindingManager;
import com.ibm.team.workitem.common.internal.presentations.PresentationDescriptor;
import com.ibm.team.workitem.common.internal.presentations.SectionDescriptor;
import com.ibm.team.workitem.common.internal.presentations.TabDescriptor;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.Identifier;
import com.ibm.team.workitem.ide.ui.internal.WorkItemIDEUIPlugin;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.PresentationsManager;
import com.ibm.team.workitem.ide.ui.internal.preview.presentations.AttributeMarkupPart;
import com.ibm.team.workitem.ide.ui.internal.preview.presentations.MarkupBuilder;
import com.ibm.team.workitem.ide.ui.internal.preview.presentations.MarkupPart;
import com.ibm.team.workitem.ide.ui.internal.preview.presentations.MarkupPresentationsManager;
import com.ibm.team.workitem.ide.ui.internal.preview.presentations.Messages;
import com.ibm.team.workitem.ide.ui.internal.preview.presentations.PresentationMarkupPart;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MarkupLayout {
    private static final LinkDetector fgLinkDetector = MarkupLayout.createLinkDetector();
    private Map<String, List<AbstractPresentationDescriptor>> fPresentationMap;
    private IWorkItem fItem;
    private IDomainAdapter.Info fInfo;

    public abstract void layout(TabDescriptor var1, Map<String, String> var2, StringBuilder var3, IProgressMonitor var4) throws TeamRepositoryException;

    public void init(IWorkItem item, IDomainAdapter.Info info, Map<String, List<AbstractPresentationDescriptor>> presentationMap) {
        this.fItem = item;
        this.fInfo = info;
        this.fPresentationMap = presentationMap;
    }

    public Map<String, List<AbstractPresentationDescriptor>> getPresentationMap() {
        return this.fPresentationMap;
    }

    public IWorkItem getItem() {
        return this.fItem;
    }

    public IDomainAdapter.Info getInfo() {
        return this.fInfo;
    }

    protected Map<String, List<SectionDescriptor>> groupBySlot(List<AbstractPresentationDescriptor> sections) {
        HashMap<String, List<SectionDescriptor>> mapSlotToSections = new HashMap<String, List<SectionDescriptor>>();
        for (SectionDescriptor sectionDescriptor : sections) {
            ArrayList<SectionDescriptor> slotSections = (ArrayList<SectionDescriptor>)mapSlotToSections.get(sectionDescriptor.getSlot());
            if (slotSections == null) {
                slotSections = new ArrayList<SectionDescriptor>();
                mapSlotToSections.put(sectionDescriptor.getSlot(), slotSections);
            }
            slotSections.add(sectionDescriptor);
        }
        return mapSlotToSections;
    }

    protected void fillPresentation(MarkupBuilder buffer, Map<String, String> headDefinitions, IWorkItem item, PresentationDescriptor desc, PresentationSlot position, boolean forceRequiresAttribute, IProgressMonitor monitor) throws TeamRepositoryException {
        if (desc.getKind() != null) {
            if ("com.ibm.team.workitem.kind.special.doNotShow".equals(desc.getKind())) {
                return;
            }
            if (PresentationsManager.needsAttribute(desc.getKind()) || forceRequiresAttribute) {
                if (desc.getAttributeId() == null) {
                    WorkItemIDEUIPlugin.getDefault().log((IStatus)new Status(4, "com.ibm.team.workitem.ide.ui", NLS.bind((String)Messages.MarkupLayout_PRESENTATION_REQUIRES_ATTRIBUTE, (Object)desc.getKind(), (Object[])new Object[]{desc.getElementId()})));
                    return;
                }
                this.fillAttributePart(desc.getKind(), buffer, headDefinitions, item, desc, position, monitor);
            } else {
                this.fillPresentationPart(desc.getKind(), buffer, headDefinitions, item, desc, position, monitor);
            }
        } else {
            if (desc.getAttributeId() == null) {
                WorkItemIDEUIPlugin.getDefault().log((IStatus)new Status(4, "com.ibm.team.workitem.ide.ui", NLS.bind((String)Messages.MarkupLayout_KIND_AND_ATTRIBUTE_ID_MISSING, (Object)desc.getElementId(), (Object[])new Object[0])));
                return;
            }
            IAttribute attribute = this.getAttribute(item, desc, monitor);
            if (attribute == null) {
                return;
            }
            String kind = AttributeTypePresentationIdBindingManager.getAttributeTypePresentationId((String)attribute.getAttributeType());
            if (kind == null) {
                WorkItemIDEUIPlugin.getDefault().log((IStatus)new Status(4, "com.ibm.team.workitem.ide.ui", NLS.bind((String)Messages.MarkupLayout_NO_DEFAULT_PRESENTATION, (Object)attribute.getIdentifier(), (Object[])new Object[]{attribute.getAttributeType()})));
                return;
            }
            this.fillAttributePart(kind, buffer, headDefinitions, item, desc, position, monitor);
        }
    }

    protected void fillPresentationPart(String kind, MarkupBuilder buffer, Map<String, String> headDefinitions, IWorkItem item, PresentationDescriptor desc, PresentationSlot position, IProgressMonitor monitor) throws TeamRepositoryException {
        MarkupPart part = MarkupPresentationsManager.getInstance().getPart(kind);
        if (part instanceof PresentationMarkupPart) {
            PresentationMarkupPart pPart = (PresentationMarkupPart)part;
            pPart.initialize(item, desc, fgLinkDetector, headDefinitions);
            switch (position) {
                case NAME: {
                    pPart.fillPartName(buffer, monitor);
                    break;
                }
                case CONTENT: {
                    pPart.fillPartContent(buffer, monitor);
                }
            }
        }
    }

    protected void fillAttributePart(String kind, MarkupBuilder buffer, Map<String, String> headDefinitions, IWorkItem item, PresentationDescriptor desc, PresentationSlot position, IProgressMonitor monitor) throws TeamRepositoryException {
        MarkupPart part = MarkupPresentationsManager.getInstance().getPart(kind);
        if (part instanceof AttributeMarkupPart) {
            AttributeMarkupPart aPart = (AttributeMarkupPart)part;
            IAttribute attribute = this.getAttribute(item, desc, monitor);
            if (attribute == null) {
                return;
            }
            if (!item.hasAttribute(attribute)) {
                return;
            }
            if (desc.getProperties() != null && "true".equalsIgnoreCase((String)desc.getProperties().get("hideIfEmpty"))) {
                ITeamRepository repository = (ITeamRepository)item.getOrigin();
                IAuditableClient auditableClient = (IAuditableClient)repository.getClientLibrary(IAuditableClient.class);
                Object value = item.getValue(attribute);
                Object nullValue = attribute.getNullValue((IAuditableCommon)auditableClient, null);
                if (nullValue == value || nullValue != null && nullValue.equals(value)) {
                    return;
                }
                if (value instanceof IItemHandle && nullValue instanceof IItemHandle && ((IItemHandle)value).sameItemId((IItemHandle)nullValue)) {
                    return;
                }
            }
            aPart.initialize(item, attribute, desc, fgLinkDetector, headDefinitions);
            switch (position) {
                case NAME: {
                    aPart.fillPartName(buffer, monitor);
                    break;
                }
                case CONTENT: {
                    aPart.fillPartContent(buffer, monitor);
                }
            }
        }
    }

    private IAttribute getAttribute(IWorkItem item, PresentationDescriptor desc, IProgressMonitor monitor) throws TeamRepositoryException {
        ITeamRepository repository = (ITeamRepository)item.getOrigin();
        WorkItemCommon wiCommon = (WorkItemCommon)repository.getClientLibrary(IWorkItemCommon.class);
        Identifier attributeId = desc.getAttributeId();
        String attributeIdVal = WorkItemAttributes.getAttributeId((Identifier)attributeId);
        return wiCommon.findAttribute(item.getProjectArea(), attributeIdVal, monitor);
    }

    private static LinkDetector createLinkDetector() {
        LinkDetector linkDetector = TextLinkDetectorManager.getDefault().createLinkDetector(false);
        linkDetector.addTextLinkDetector((TextLinkDetector)new URILinkDetector());
        return linkDetector;
    }

    protected void layoutInColumns(int numColumns, Map<String, String> headDefinitions, StringBuilder buffer, List<SectionDescriptor> sections, boolean wrapText, boolean createTable, IProgressMonitor monitor) throws TeamRepositoryException {
        for (SectionDescriptor section : sections) {
            boolean noHeader;
            boolean renderSection = false;
            StringBuilder sectionBuffer = new StringBuilder();
            if (createTable) {
                sectionBuffer.append("<table class=\"section\">");
            }
            boolean bl = noHeader = section.getProperties() != null && "true".equalsIgnoreCase((String)section.getProperties().get("noHeader"));
            if (!noHeader) {
                sectionBuffer.append("<tr><th>").append(section.getTitle()).append("</th></tr>");
            }
            List<AbstractPresentationDescriptor> presentations = this.getPresentationMap().get(section.getElementId());
            ArrayList<StringBuilder> renderedPresentations = new ArrayList<StringBuilder>();
            if (presentations != null) {
                for (AbstractPresentationDescriptor next : presentations) {
                    if (!(next instanceof PresentationDescriptor)) continue;
                    PresentationDescriptor presentation = (PresentationDescriptor)next;
                    StringBuilder presentationBuffer = new StringBuilder();
                    boolean renderPresentation = false;
                    boolean nameShown = false;
                    boolean forceLabelVisible = presentation.getProperties() != null && "true".equalsIgnoreCase((String)presentation.getProperties().get("labelVisible"));
                    boolean hideName = !forceLabelVisible && presentations.size() == 1;
                    MarkupBuilder builder = new MarkupBuilder();
                    if (!hideName) {
                        this.fillPresentation(builder, headDefinitions, this.getItem(), presentation, PresentationSlot.NAME, false, monitor);
                        if (builder.length() > 0) {
                            renderPresentation = true;
                            nameShown = true;
                            presentationBuffer.append("<td valign=\"top\" class=\"" + (wrapText ? "sectionContent" : "sectionContentNoWrap") + "\">");
                            presentationBuffer.append((Object)builder).append(":");
                            presentationBuffer.append("</td>");
                        }
                    }
                    if (nameShown) {
                        presentationBuffer.append("<td valign=\"top\" class=\"" + (wrapText ? "sectionContent" : "sectionContentNoWrap") + "\">");
                    } else {
                        presentationBuffer.append("<td valign=\"top\" class=\"" + (wrapText ? "sectionContent" : "sectionContentNoWrap") + "\" colspan=\"2\">");
                    }
                    builder = new MarkupBuilder();
                    this.fillPresentation(builder, headDefinitions, this.getItem(), presentation, PresentationSlot.CONTENT, false, monitor);
                    if (builder.length() > 0) {
                        renderPresentation = true;
                    }
                    presentationBuffer.append((Object)builder);
                    presentationBuffer.append("</td>");
                    if (!renderPresentation) continue;
                    renderedPresentations.add(presentationBuffer);
                    renderSection = true;
                }
                int pivot = (renderedPresentations.size() + 1) / numColumns;
                int i = 0;
                while (i < pivot) {
                    boolean renderColumn = false;
                    StringBuilder columnBuffer = new StringBuilder();
                    columnBuffer.append("<tr>");
                    int j = 0;
                    while (j < numColumns) {
                        if (i + j * pivot < renderedPresentations.size()) {
                            StringBuilder builder = (StringBuilder)renderedPresentations.get(i + j * pivot);
                            columnBuffer.append((CharSequence)builder);
                            renderColumn = true;
                        }
                        ++j;
                    }
                    columnBuffer.append("</tr>");
                    if (renderColumn) {
                        sectionBuffer.append((CharSequence)columnBuffer);
                    }
                    ++i;
                }
            }
            if (createTable) {
                sectionBuffer.append("</table>");
            }
            if (!renderSection) continue;
            buffer.append((CharSequence)sectionBuffer);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum PresentationSlot {
        NAME,
        CONTENT;

    }
}

