/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.preview.presentations;

import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.common.internal.presentations.AbstractPresentationDescriptor;
import com.ibm.team.workitem.common.internal.presentations.SectionDescriptor;
import com.ibm.team.workitem.common.internal.presentations.TabDescriptor;
import com.ibm.team.workitem.ide.ui.internal.preview.presentations.MarkupLayout;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinksMarkupLayout
extends MarkupLayout {
    private static final String ATTACHMENTS_SLOT = "attachments";
    private static final String SUBSCRIBERS_SLOT = "subscribers";
    private static final String LINKS_SLOT = "links";

    @Override
    public void layout(TabDescriptor descriptor, Map<String, String> headDefinitions, StringBuilder builder, IProgressMonitor monitor) throws TeamRepositoryException {
        List<AbstractPresentationDescriptor> sections = this.getPresentationMap().get(descriptor.getElementId());
        Map<String, List<SectionDescriptor>> mapSlotToSections = this.groupBySlot(sections);
        if (mapSlotToSections.containsKey(ATTACHMENTS_SLOT)) {
            this.layoutAttachments(headDefinitions, builder, monitor, mapSlotToSections);
        }
        if (mapSlotToSections.containsKey(SUBSCRIBERS_SLOT)) {
            this.layoutSubscribers(headDefinitions, builder, monitor, mapSlotToSections);
        }
        if (mapSlotToSections.containsKey(LINKS_SLOT)) {
            this.layoutLinks(headDefinitions, builder, monitor, mapSlotToSections);
        }
    }

    private void layoutAttachments(Map<String, String> headDefinitions, StringBuilder buffer, IProgressMonitor monitor, Map<String, List<SectionDescriptor>> mapSlotToSections) throws TeamRepositoryException {
        List<SectionDescriptor> attachmentsSections = mapSlotToSections.get(ATTACHMENTS_SLOT);
        this.layoutInColumns(1, headDefinitions, buffer, attachmentsSections, false, true, monitor);
    }

    private void layoutSubscribers(Map<String, String> headDefinitions, StringBuilder buffer, IProgressMonitor monitor, Map<String, List<SectionDescriptor>> mapSlotToSections) throws TeamRepositoryException {
        List<SectionDescriptor> attachmentsSections = mapSlotToSections.get(SUBSCRIBERS_SLOT);
        this.layoutInColumns(1, headDefinitions, buffer, attachmentsSections, true, true, monitor);
    }

    private void layoutLinks(Map<String, String> headDefinitions, StringBuilder buffer, IProgressMonitor monitor, Map<String, List<SectionDescriptor>> mapSlotToSections) throws TeamRepositoryException {
        List<SectionDescriptor> attachmentsSections = mapSlotToSections.get(LINKS_SLOT);
        this.layoutInColumns(1, headDefinitions, buffer, attachmentsSections, true, true, monitor);
    }
}

