/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.preview.presentations;

import com.ibm.team.jface.JazzResources;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.client.IAuditableClient;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemType;
import com.ibm.team.workitem.common.model.Identifier;
import com.ibm.team.workitem.common.model.ItemProfile;
import com.ibm.team.workitem.ide.ui.internal.WorkItemIDEUIPlugin;
import com.ibm.team.workitem.ide.ui.internal.preview.presentations.AttributeMarkupPart;
import com.ibm.team.workitem.ide.ui.internal.preview.presentations.MarkupBuilder;
import com.ibm.team.workitem.ide.ui.internal.preview.presentations.Messages;
import java.io.IOException;
import java.net.URL;
import org.eclipse.core.runtime.IProgressMonitor;

public class EnumerationAttributeMarkupPart
extends AttributeMarkupPart {
    public void fillPartContent(MarkupBuilder builder, IProgressMonitor monitor) throws TeamRepositoryException {
        try {
            this.internalFillPartContent(builder, monitor);
        }
        catch (TeamRepositoryException e) {
            this.handleException(builder, e);
        }
    }

    private void internalFillPartContent(MarkupBuilder builder, IProgressMonitor monitor) throws TeamRepositoryException {
        block10: {
            Object value = this.getNonNullAttributeValue(monitor);
            if (value instanceof Identifier) {
                this.fillLiteral(builder, (Identifier)value, monitor);
            } else if (value instanceof String && this.getAttribute().getIdentifier().equals(IWorkItem.TYPE_PROPERTY)) {
                String type;
                IProjectArea projectArea;
                IAuditableClient auditableClient = this.getAuditableClient();
                IWorkItemClient workItemService = this.getWorkItemClient();
                IWorkItemType workItemType = workItemService.findWorkItemType((IProjectAreaHandle)(projectArea = (IProjectArea)auditableClient.resolveAuditable((IAuditableHandle)this.getItem().getProjectArea(), ItemProfile.PROJECT_AREA_DEFAULT, monitor)), type = (String)value, null);
                if (workItemType != null) {
                    try {
                        URL iconURL = JazzResources.createImageURL((URL)workItemType.getIconURL());
                        if (iconURL != null) {
                            builder.image(iconURL.toString(), workItemType.getDisplayName());
                            builder.imageLabel(workItemType.getDisplayName());
                            break block10;
                        }
                        builder.plain(workItemType.getDisplayName());
                    }
                    catch (IOException e) {
                        WorkItemIDEUIPlugin.getDefault().log(Messages.EnumerationAttributeMarkupPart_ERROR_SAVING_TMP_IMG, e);
                    }
                } else {
                    builder.plain(type);
                }
            } else if (value != null) {
                builder.plain(value.toString());
            }
        }
    }
}

