/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.preview;

import com.ibm.icu.text.DateFormat;
import com.ibm.team.foundation.common.DetectedTextLink;
import com.ibm.team.foundation.common.LinkDetector;
import com.ibm.team.foundation.common.TextLinkDetector;
import com.ibm.team.foundation.common.TextLinkDetectorManager;
import com.ibm.team.foundation.common.URILinkDetector;
import com.ibm.team.foundation.common.text.XMLString;
import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.MultiHyperlinkHandler;
import com.ibm.team.foundation.rcp.core.text.ReferencePosition;
import com.ibm.team.foundation.rcp.core.text.StyledDocument;
import com.ibm.team.jface.JazzResources;
import com.ibm.team.jface.itemview.MarkupUtil;
import com.ibm.team.jface.preview.HTMLGenerator;
import com.ibm.team.jface.preview.IDomainAdapter;
import com.ibm.team.process.common.IIteration;
import com.ibm.team.process.common.IIterationHandle;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.rcp.ui.teamnavigator.ConnectedProjectAreaRegistry;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.Location;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.client.IAuditableClient;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.client.URIService;
import com.ibm.team.workitem.client.WorkflowUtilities;
import com.ibm.team.workitem.common.internal.model.DefaultModel;
import com.ibm.team.workitem.common.internal.util.ImageURLPool;
import com.ibm.team.workitem.common.internal.util.Utils;
import com.ibm.team.workitem.common.model.Duration;
import com.ibm.team.workitem.common.model.DurationFormat;
import com.ibm.team.workitem.common.model.IApprovalDescriptor;
import com.ibm.team.workitem.common.model.IApprovalState;
import com.ibm.team.workitem.common.model.IApprovals;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.IAttributeHandle;
import com.ibm.team.workitem.common.model.ICategory;
import com.ibm.team.workitem.common.model.ICategoryHandle;
import com.ibm.team.workitem.common.model.IComment;
import com.ibm.team.workitem.common.model.IEnumeration;
import com.ibm.team.workitem.common.model.ILiteral;
import com.ibm.team.workitem.common.model.IPriority;
import com.ibm.team.workitem.common.model.ISeverity;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemType;
import com.ibm.team.workitem.common.model.Identifier;
import com.ibm.team.workitem.common.model.ItemProfile;
import com.ibm.team.workitem.common.model.WorkItemApprovals;
import com.ibm.team.workitem.common.text.WorkItemTextUtilities;
import com.ibm.team.workitem.common.workflow.IWorkflowInfo;
import com.ibm.team.workitem.ide.ui.internal.WorkItemIDEUIPlugin;
import com.ibm.team.workitem.ide.ui.internal.editor.comments.ILineBasedSubstitutionScanner;
import com.ibm.team.workitem.ide.ui.internal.editor.comments.LineBasedSubstitutionScannerRegistry;
import com.ibm.team.workitem.ide.ui.internal.preview.Messages;
import com.ibm.team.workitem.ide.ui.internal.preview.presentations.MarkupBuilder;
import com.ibm.team.workitem.rcp.ui.WorkItemUI;
import com.ibm.team.workitem.rcp.ui.internal.ImagePool;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;

public class WorkItemHTMLGenerator
extends HTMLGenerator {
    private static final String GENERAL_CSS = "GENERAL_WORKITEM_CSS";
    private static final String UNASSIGNED = Messages.WorkItemHTMLGenerator_UNASSIGNED;
    private static final int MAX_COMMENTS_IN_HOVER_TOOLTIP = 3;
    private static final int MAX_COMMENT_LENGTH_IN_HOVER_TOOLTIP = 200;
    private static final int MAX_COMMENT_LENGTH = 500;
    private static final int MAX_DESCRIPTION_LENGTH = 400;
    private DateFormat fDateFormatter = DateFormat.getDateInstance((int)2);
    private DateFormat fTimeFormatter = DateFormat.getTimeInstance((int)3);
    private IWorkItem fWorkItem;

    public WorkItemHTMLGenerator(IWorkItem workItem) {
        this.fWorkItem = workItem;
    }

    protected void createControl(HTMLGenerator.Composite composite) {
    }

    public void generate(HashMap headDefinitions, StringBuffer buffer, IDomainAdapter.Info info) {
        try {
            MarkupBuilder builder = new MarkupBuilder();
            this.generate(headDefinitions, builder, info, null);
            buffer.append((Object)builder);
        }
        catch (TeamRepositoryException teamRepositoryException) {}
        this.generateHead(headDefinitions);
    }

    public void generateComment(HashMap headDefinitions, StringBuffer buffer, IComment comment, IDomainAdapter.Info info) {
        try {
            MarkupBuilder builder = new MarkupBuilder();
            this.generateComment(headDefinitions, builder, comment, info, null);
            buffer.append((Object)builder);
        }
        catch (TeamRepositoryException teamRepositoryException) {}
        this.generateHead(headDefinitions);
    }

    protected void generateHead(HashMap map) {
        if (map.containsKey(GENERAL_CSS)) {
            return;
        }
        StringBuffer css = new StringBuffer();
        css.append("<style type=\"text/css\">");
        css.append("body { overflow: auto; margin: 0; }\n");
        css.append(".{ ").append(MarkupUtil.getGlobalFont()).append(" }");
        css.append("table{ ").append(MarkupUtil.getFont()).append(" }");
        css.append("a:link { color:#000000; text-decoration: none; }");
        css.append("a:visited { color:#000000; text-decoration: none; }");
        css.append("a:hover { text-decoration: underline; }");
        css.append("td.sectionTitle { padding-top:5px;font-weight:bold;padding-right:10px;vertical-align:top; }");
        css.append("td.sectionContent { padding-left:5px;padding-right:10px;vertical-align:top;}");
        css.append("td.sectionColumn {padding-right:15px;vertical-align:top;}");
        css.append("td.commentTitle {padding-left:5px;padding-top:2px;vertical-align:top;}");
        css.append("td.commentContent {padding-left:15px;padding-bottom:5px;padding-top:2px;vertical-align:top;}");
        css.append("td.approvalTitle {padding-top:5px;font-weight:bold;padding-right:10px;vertical-align:top; }");
        css.append("td.approvalColumn {padding-top:5px;vertical-align:top; }");
        css.append("td.approvalImage {padding-left:5px;vertical-align:top;}");
        css.append("td.approvalContent {vertical-align:top;}");
        css.append("span.imageLabel {padding-left:3px;vertical-align:top;}");
        css.append("</style>");
        map.put(GENERAL_CSS, css.toString());
    }

    private void generate(HashMap headDefinitions, MarkupBuilder buffer, IDomainAdapter.Info info, IProgressMonitor monitor) throws TeamRepositoryException {
        ITeamRepository origin = (ITeamRepository)this.fWorkItem.getOrigin();
        if (info.isHoverTooltip) {
            XMLString htmlDescription = Utils.sanitize((XMLString)this.fWorkItem.getHTMLDescription());
            String description = htmlDescription.getPlainText().length() > 400 ? MarkupUtil.trim((String)htmlDescription.getXMLText(), (int)400) : htmlDescription.getXMLText();
            if (this.canShowType()) {
                IWorkItemClient workItemService = (IWorkItemClient)origin.getClientLibrary(IWorkItemClient.class);
                IAuditableClient auditableClient = (IAuditableClient)origin.getClientLibrary(IAuditableClient.class);
                IProjectArea projectArea = (IProjectArea)auditableClient.resolveAuditable((IAuditableHandle)this.fWorkItem.getProjectArea(), ItemProfile.PROJECT_AREA_DEFAULT, monitor);
                String workItemType = this.fWorkItem.getWorkItemType();
                IWorkItemType type = workItemService.findWorkItemType((IProjectAreaHandle)projectArea, workItemType, null);
                boolean isClosed = false;
                boolean isPending = false;
                boolean dimWithCSS = false;
                String id = String.valueOf(this.fWorkItem.getId());
                String typeIcon = null;
                String typeOverlay = null;
                if (type != null) {
                    try {
                        IWorkflowInfo wfi;
                        if (this.fWorkItem.isPropertySet(IWorkItem.WORKFLOW_SURROGATE_PROPERTY) && this.fWorkItem.isPropertySet(IWorkItem.STATE_PROPERTY) && (wfi = WorkflowUtilities.findCachedWorkflowInfo((IWorkItem)this.fWorkItem)) != null) {
                            int stateGroup = wfi.getStateGroup(this.fWorkItem.getState2());
                            isClosed = stateGroup == 2;
                            boolean bl = isPending = stateGroup == 4;
                        }
                        if (type.getIconURL() != null) {
                            URL typeUrl = null;
                            if (isClosed) {
                                typeUrl = JazzResources.createImageURL((URL)(type.getDimmedIconURL() != null ? type.getDimmedIconURL() : type.getIconURL()));
                                dimWithCSS = type.getDimmedIconURL() == null;
                            } else {
                                typeUrl = JazzResources.createImageURL((URL)type.getIconURL());
                            }
                            if (typeUrl != null) {
                                typeIcon = typeUrl.toString();
                            }
                        }
                        if (isClosed) {
                            typeOverlay = JazzResources.createImageURL((URL)ImageURLPool.WORKITEM_COMPLETE_OVR).toString();
                        } else if (isPending) {
                            typeOverlay = JazzResources.createImageURL((URL)ImageURLPool.WORKITEM_IN_PROGRESS_OVR).toString();
                        }
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                    }
                    catch (IOException iOException) {}
                }
                if (typeIcon == null) {
                    typeIcon = JazzResources.createURL((ImageDescriptor)ImagePool.WORKITEM_TITLE).toString();
                    dimWithCSS = isClosed;
                }
                MarkupBuilder assignmentBuilder = new MarkupBuilder();
                if (!isClosed && this.canShowAssignment()) {
                    IEnumeration enumeration;
                    String owner = null;
                    IContributorHandle ownerHandle = this.fWorkItem.getOwner();
                    if (ownerHandle != null && !DefaultModel.NULL_CONTRIBUTOR_ITEM_ID.equals((Object)ownerHandle.getItemId())) {
                        IContributor resolvedOwner = (IContributor)auditableClient.resolveAuditable((IAuditableHandle)ownerHandle, ItemProfile.CONTRIBUTOR_DEFAULT, monitor);
                        owner = resolvedOwner.getName();
                    }
                    String plannedFor = null;
                    IIterationHandle iterationHandle = this.fWorkItem.getTarget();
                    if (iterationHandle != null) {
                        IIteration iteration = (IIteration)auditableClient.resolveAuditable((IAuditableHandle)iterationHandle, ItemProfile.ITERATION_DEFAULT, monitor);
                        plannedFor = iteration.getLabel();
                    }
                    String priority = null;
                    Identifier priorityId = this.fWorkItem.getPriority();
                    if (priorityId != null && (enumeration = workItemService.resolveEnumeration((IAttributeHandle)workItemService.findAttribute((IProjectAreaHandle)projectArea, IWorkItem.PRIORITY_PROPERTY, monitor), monitor)) != null) {
                        ILiteral priorityLiteral = enumeration.findEnumerationLiteral(priorityId);
                        priority = priorityLiteral != null ? priorityLiteral.getName() : priorityId.getStringIdentifier();
                    }
                    assignmentBuilder.xml("<b>").plain(Messages.WorkItemHTMLGenerator_ASSIGNMENT_LABEL).xml("</b>");
                    if (owner == null && plannedFor == null) {
                        assignmentBuilder.plain(Messages.WorkItemHTMLGenerator_UNASSIGNED);
                    } else if (owner != null && plannedFor != null && priority != null) {
                        assignmentBuilder.plain(NLS.bind((String)Messages.WorkItemHTMLGenerator_OWNER_PLANNED_PRIORITY_1, (Object)owner, (Object[])new Object[]{plannedFor, priority}));
                    } else if (owner != null && plannedFor == null && priority == null) {
                        assignmentBuilder.plain(NLS.bind((String)Messages.WorkItemHTMLGenerator_OWNER_PLANNED_PRIORITY_3, (Object)owner, (Object[])new Object[0]));
                    } else if (owner == null && plannedFor != null && priority == null) {
                        assignmentBuilder.plain(NLS.bind((String)Messages.WorkItemHTMLGenerator_OWNER_PLANNED_PRIORITY_4, (Object)plannedFor, (Object[])new Object[0]));
                    } else if (owner != null && plannedFor != null) {
                        assignmentBuilder.plain(NLS.bind((String)Messages.WorkItemHTMLGenerator_OWNER_PLANNED_PRIORITY_6, (Object)owner, (Object[])new Object[]{plannedFor}));
                    } else if (plannedFor != null && priority != null) {
                        assignmentBuilder.plain(NLS.bind((String)Messages.WorkItemHTMLGenerator_OWNER_PLANNED_PRIORITY_7, (Object)plannedFor, (Object[])new Object[]{priority}));
                    } else if (owner != null && priority != null) {
                        assignmentBuilder.plain(NLS.bind((String)Messages.WorkItemHTMLGenerator_OWNER_PLANNED_PRIORITY_8, (Object)owner, (Object[])new Object[]{priority}));
                    }
                }
                buffer.xml("<table style=\"margin-bottom: 0;\">");
                buffer.xml("<tr><td>");
                if (dimWithCSS) {
                    buffer.xml("<img style=\"filter: alpha(opacity=30); -moz-opacity: 0.3; opacity: 0.3;\" src=\"").plain(typeIcon).xml("\" />");
                } else {
                    buffer.xml("<img src=\"").plain(typeIcon).xml("\" />");
                }
                if (typeOverlay != null) {
                    buffer.xml("<img src=\"").plain(typeOverlay).xml("\" style=\"position: absolute; left: 4px; top: 12px;\" />");
                }
                buffer.xml("<span style=\"padding-left:3px;vertical-align:top;\">");
                if (isClosed) {
                    buffer.xml("<strike>").plain(id).xml("</strike>: ");
                } else {
                    buffer.plain(NLS.bind((String)Messages.WorkItemHTMLGenerator_DEFECT_ID, (Object)id, (Object[])new Object[0]));
                }
                buffer.append(Utils.sanitize((XMLString)this.fWorkItem.getHTMLSummary()));
                buffer.xml("</span>");
                buffer.xml("</td></tr>");
                buffer.xml("</table>");
                if (assignmentBuilder.length() > 0) {
                    buffer.xml("<table style=\"margin-bottom: 0;\">");
                    buffer.xml("<tr><td>");
                    buffer.append(assignmentBuilder.getXMLString());
                    buffer.xml("</td></tr>");
                    buffer.xml("</table>");
                }
                if (description.length() > 0) {
                    buffer.xml("<table>");
                    buffer.xml("<tr><td><b>").plain(NLS.bind((String)Messages.WorkItemHTMLGenerator_ATTRIBUTE_COLON, (Object)Messages.WorkItemHTMLGenerator_DESCRIPTION, (Object[])new Object[0])).xml("</b>").xml(description).xml("</td></tr>");
                    buffer.xml("</table>");
                }
            } else {
                buffer.xml("<table style=\"margin-bottom: 0;\">");
                buffer.xml("<tr><td><b>").plain(NLS.bind((String)Messages.WorkItemHTMLGenerator_ATTRIBUTE_COLON, (Object)Messages.WorkItemHTMLGenerator_SUMMARY, (Object[])new Object[0])).xml("</b>").append(Utils.sanitize((XMLString)this.fWorkItem.getHTMLSummary())).xml("</td></tr>");
                buffer.xml("<tr><td height='2'></td></tr>");
                buffer.xml("</table>");
                if (description.length() > 0) {
                    buffer.xml("<table>");
                    buffer.xml("<tr><td><b>").plain(NLS.bind((String)Messages.WorkItemHTMLGenerator_ATTRIBUTE_COLON, (Object)Messages.WorkItemHTMLGenerator_DESCRIPTION, (Object[])new Object[0])).xml("</b>").xml(description).xml("</td></tr>");
                    buffer.xml("</table>");
                }
            }
            return;
        }
        if (info.isEmbeddeble) {
            Location location = Location.itemLocation((IItemHandle)this.fWorkItem, (String)origin.getRepositoryURI(), null, null);
            URI uri = location.toAbsoluteUri();
            if (uri != null) {
                buffer.xml("<a href=\"");
                buffer.plain(uri.toString());
                buffer.xml("\">");
                buffer.plain(WorkItemTextUtilities.getWorkItemText((IWorkItem)this.fWorkItem));
                buffer.xml("</a>");
            }
            return;
        }
        LinkDetector linkDetector = TextLinkDetectorManager.getDefault().createLinkDetector(false);
        try {
            linkDetector.addTextLinkDetector((TextLinkDetector)new URILinkDetector());
            ITeamRepository teamRepository = (ITeamRepository)this.fWorkItem.getOrigin();
            linkDetector.setBaseURI(Location.itemLocation((IItemHandle)this.fWorkItem, (String)teamRepository.getRepositoryURI()).toAbsoluteUri());
            this.generateHTML(headDefinitions, buffer, info, linkDetector, monitor);
        }
        finally {
            linkDetector.dispose();
        }
    }

    private boolean canShowType() {
        return this.fWorkItem.isPropertySet(IWorkItem.PROJECT_AREA_PROPERTY) && this.fWorkItem.isPropertySet(IWorkItem.ID_PROPERTY) && this.fWorkItem.isPropertySet(IWorkItem.TYPE_PROPERTY) && this.fWorkItem.getWorkItemType() != null;
    }

    private boolean canShowAssignment() {
        return this.fWorkItem.isPropertySet(IWorkItem.OWNER_PROPERTY) && this.fWorkItem.isPropertySet(IWorkItem.PRIORITY_PROPERTY) && this.fWorkItem.isPropertySet(IWorkItem.TARGET_PROPERTY);
    }

    private void generateHTML(HashMap headDefinitions, MarkupBuilder buffer, IDomainAdapter.Info info, LinkDetector linkDetector, IProgressMonitor monitor) throws TeamRepositoryException {
        int commentsLimit;
        Duration duration;
        URL url;
        Identifier state;
        ICategory category;
        String categoryName;
        String projectAreaName;
        ITeamRepository origin = (ITeamRepository)this.fWorkItem.getOrigin();
        IAuditableClient auditableClient = (IAuditableClient)origin.getClientLibrary(IAuditableClient.class);
        IWorkItemClient workItemService = (IWorkItemClient)origin.getClientLibrary(IWorkItemClient.class);
        this.fWorkItem = (IWorkItem)auditableClient.resolveAuditable((IAuditableHandle)this.fWorkItem, IWorkItem.FULL_PROFILE, monitor);
        IProjectArea projectArea = (IProjectArea)auditableClient.resolveAuditable((IAuditableHandle)this.fWorkItem.getProjectArea(), ItemProfile.PROJECT_AREA_DEFAULT, monitor);
        String workItemType = this.fWorkItem.getWorkItemType();
        IWorkItemType type = workItemType != null ? workItemService.findWorkItemType((IProjectAreaHandle)projectArea, workItemType, null) : null;
        IContributor fCreator = (IContributor)auditableClient.resolveAuditable((IAuditableHandle)this.fWorkItem.getCreator(), ItemProfile.CONTRIBUTOR_DEFAULT, monitor);
        IContributor fOwner = (IContributor)auditableClient.resolveAuditable((IAuditableHandle)this.fWorkItem.getOwner(), ItemProfile.CONTRIBUTOR_DEFAULT, monitor);
        IIteration fTarget = null;
        IIterationHandle targetHandle = this.fWorkItem.getTarget();
        if (targetHandle != null) {
            fTarget = (IIteration)auditableClient.resolveAuditable((IAuditableHandle)targetHandle, ItemProfile.ITERATION_DEFAULT, monitor);
        }
        if ((projectAreaName = ConnectedProjectAreaRegistry.getDefault().getProjectAreaName((IProjectAreaHandle)projectArea)) == null) {
            projectAreaName = projectArea.getName();
        }
        if ((categoryName = workItemService.resolveHierarchicalName((ICategoryHandle)(category = (ICategory)auditableClient.resolveAuditable((IAuditableHandle)this.fWorkItem.getCategory(), ICategory.SMALL_PROFILE, monitor)), monitor)) == null) {
            categoryName = UNASSIGNED;
        }
        IAttribute priorityAttribute = workItemService.findAttribute((IProjectAreaHandle)projectArea, IWorkItem.PRIORITY_PROPERTY, monitor);
        IEnumeration priorityEnumeration = workItemService.resolveEnumeration((IAttributeHandle)priorityAttribute, monitor);
        Identifier priority2 = this.fWorkItem.getPriority();
        IPriority priority = (IPriority)priorityEnumeration.findEnumerationLiteral(priority2);
        IAttribute severityAttribute = workItemService.findAttribute((IProjectAreaHandle)projectArea, IWorkItem.SEVERITY_PROPERTY, monitor);
        IEnumeration severityEnumeration = workItemService.resolveEnumeration((IAttributeHandle)severityAttribute, monitor);
        Identifier severity2 = this.fWorkItem.getSeverity();
        ISeverity severity = (ISeverity)severityEnumeration.findEnumerationLiteral(severity2);
        IWorkflowInfo workflow = workItemService.findWorkflowInfo(this.fWorkItem, monitor);
        Identifier[] stateResolutions = workflow.getStateResolutionIds(state = this.fWorkItem.getState2());
        boolean showResolution = stateResolutions.length > 0;
        buffer.xml("<table><tr>");
        buffer.xml("<td class='sectionTitle'>").plain(Messages.WorkItemHTMLGenerator_STATE).xml("</td>");
        if (showResolution) {
            buffer.xml("<td class='sectionTitle'>").plain(Messages.WorkItemHTMLGenerator_RESOLUTION).xml("</td>");
        }
        buffer.xml("<td class='sectionTitle'><b>").plain(Messages.WorkItemHTMLGenerator_SUMMARY).xml("</b></td>");
        buffer.xml("</tr><tr>");
        buffer.xml("<td class='sectionContent'>");
        String stateName = workflow.getStateName(state);
        if (stateName == null) {
            stateName = state != null ? state.getStringIdentifier() : "";
        }
        if ((url = workflow.getStateIconName(state)) != null) {
            this.appendImage(buffer, this.getLocalUrl(url), stateName);
        }
        buffer.xml("<span class='imageLabel'>").plain(stateName).xml("</span>");
        buffer.xml("</td>");
        if (showResolution) {
            buffer.xml("<td class='sectionContent'>");
            Identifier resolution = this.fWorkItem.getResolution2();
            String resolutionName = workflow.getResolutionName(resolution);
            if (resolutionName == null) {
                resolutionName = resolution != null ? resolution.getStringIdentifier() : "";
            }
            if ((url = workflow.getResolutionIconName(resolution)) != null) {
                this.appendImage(buffer, this.getLocalUrl(url), resolutionName);
            }
            buffer.xml("<span class='imageLabel'>").plain(resolutionName).xml("</span>");
            buffer.xml("</td>");
        }
        buffer.xml("<td class='sectionContent'>");
        buffer.xml(this.decorate(linkDetector, this.fWorkItem.getHTMLSummary()).getXMLText());
        buffer.xml("</td>");
        buffer.xml("</tr></table>");
        buffer.xml("<table cellspacing='0' cellpadding='0'>");
        buffer.xml("<tr><td valign='top' class='sectionColumn'><table>");
        this.appendSectionTitle(buffer, Messages.WorkItemHTMLGenerator_CREATION, 3);
        this.appendAttributeValuePair(buffer, 1, Messages.WorkItemHTMLGenerator_TYPE, type != null ? type.getDisplayName() : UNASSIGNED, WorkItemUI.createImageURL((IWorkItemType)type));
        this.appendAttributeValuePair(buffer, 1, Messages.WorkItemHTMLGenerator_SEVERITY, severity != null ? severity.getName() : severity2.getStringIdentifier(), WorkItemUI.createImageURL((ISeverity)severity));
        Timestamp creationDate = this.fWorkItem.getCreationDate();
        this.appendAttributeValuePair(buffer, 2, Messages.WorkItemHTMLGenerator_CREATED, creationDate != null ? this.formatDate(creationDate, true) : UNASSIGNED, null);
        MarkupBuilder creator = new MarkupBuilder();
        this.appendUserName(creator, fCreator);
        this.appendAttributeValuePair(buffer, 2, Messages.WorkItemHTMLGenerator_CREATOR, creator.toString(), null);
        this.appendAttributeValuePair(buffer, 1, Messages.WorkItemHTMLGenerator_PROJECT, projectAreaName, null);
        String tags = this.fWorkItem.getTags();
        if (tags != null && tags.trim().length() > 0) {
            this.appendAttributeValuePair(buffer, 1, Messages.WorkItemHTMLGenerator_TAGS, tags, null);
        }
        buffer.xml("</table></td><td valign='top' class='sectionColumn'><table>");
        this.appendSectionTitle(buffer, Messages.WorkItemHTMLGenerator_ASSIGNMENT, 3);
        this.appendAttributeValuePair(buffer, 2, Messages.WorkItemHTMLGenerator_CATEGORY, categoryName, null);
        this.appendAttributeValuePair(buffer, 1, Messages.WorkItemHTMLGenerator_PRIORITY, priority != null ? priority.getName() : priority2.getStringIdentifier(), WorkItemUI.createImageURL((IPriority)priority));
        this.appendAttributeValuePair(buffer, 2, Messages.WorkItemHTMLGenerator_PLANNED_FOR, fTarget != null ? fTarget.getLabel() : IWorkItem.UNASSIGNED_TARGET_NAME, null);
        Timestamp dueDate = this.fWorkItem.getDueDate();
        if (dueDate != null) {
            this.appendAttributeValuePair(buffer, 1, Messages.WorkItemHTMLGenerator_DUE, this.formatDate(dueDate, true), null);
        }
        if ((duration = new Duration(this.fWorkItem.getDuration())).isSpecified()) {
            DurationFormat format = DurationFormat.getInstance();
            format.setUpperBoundOutputUnit(DurationFormat.Units.Hours);
            this.appendAttributeValuePair(buffer, 1, Messages.WorkItemHTMLGenerator_ESTIMATE, format.format(duration), null);
        }
        MarkupBuilder owner = new MarkupBuilder();
        this.appendUserName(owner, fOwner);
        this.appendAttributeValuePair(buffer, 1, Messages.WorkItemHTMLGenerator_OWNER, owner.toString(), null);
        buffer.xml("</td></tr></table></tr></td></table>");
        IApprovals approvals = this.fWorkItem.getApprovals();
        List descriptors = approvals.getDescriptors();
        if (descriptors.size() > 0) {
            buffer.xml("<table>");
            int n = descriptors.size();
            buffer.xml("<tr><td colspan='2' class='approvalTitle'>").plain(Integer.toString(n)).xml("&nbsp;").plain(Messages.WorkItemHTMLGenerator_APPROVAL).xml("</td>");
            buffer.xml("<td colspan='2' class='approvalColumn'>").plain(Messages.WorkItemHTMLGenerator_STATE).xml("</td>");
            buffer.xml("</tr>");
            for (IApprovalDescriptor desc : descriptors) {
                buffer.xml("<tr>");
                URL typeImg = JazzResources.createURL((ImageDescriptor)WorkItemUI.getImageDescriptor((URL)WorkItemApprovals.getType((String)desc.getTypeIdentifier()).getIconURL()));
                buffer.xml("<td class='approvalImage'><img src='");
                buffer.plain(JazzResources.getConformingURL((URL)typeImg));
                buffer.xml("' border='0' alt='");
                buffer.plain(WorkItemApprovals.getType((String)desc.getTypeIdentifier()).getDisplayName());
                buffer.xml("' /></td>");
                buffer.xml("<td class='approvalContent'>").plain(desc.getName() != null ? desc.getName() : UNASSIGNED).xml("</td>");
                IApprovalState approvalState = WorkItemApprovals.getState((String)desc.getCumulativeStateIdentifier());
                URL stateImg = JazzResources.createURL((ImageDescriptor)WorkItemUI.getImageDescriptor((URL)approvalState.getIconURL()));
                buffer.xml("<td class='approvalImage'><img src='");
                buffer.plain(JazzResources.getConformingURL((URL)stateImg));
                buffer.xml("' border='0' alt='");
                buffer.plain(approvalState.getDisplayName());
                buffer.xml("' /></td>");
                buffer.xml("<td class='approvalContent'>").plain(approvalState.getDisplayName()).xml("</td>");
                buffer.xml("</tr>");
            }
            buffer.xml("</table>");
        }
        buffer.xml("<table>");
        this.appendSectionTitle(buffer, Messages.WorkItemHTMLGenerator_DESCRIPTION, 1);
        String description = WorkItemHTMLGenerator.fixAPOS(this.decorate(linkDetector, this.fWorkItem.getHTMLDescription()).getXMLText());
        this.appendSectionContent(buffer, this.format(description));
        buffer.xml("</table>");
        IComment[] comments = this.fWorkItem.getComments().getContents();
        int n = commentsLimit = info.isHoverTooltip ? 3 : comments.length;
        if (commentsLimit > comments.length) {
            commentsLimit = comments.length;
        }
        int workItemId = this.fWorkItem.getId();
        buffer.xml("<table>");
        this.appendSectionTitle(buffer, NLS.bind((String)Messages.WorkItemHTMLGenerator_COMMENTS, (Object)comments.length, (Object[])new Object[0]), 1);
        int expandId = 0;
        ArrayList<String> contentOfClippedItems = new ArrayList<String>();
        int i = 0;
        while (i < commentsLimit) {
            IComment comment = comments[i];
            String content = this.format(this.decorate(linkDetector, comment.getHTMLContent()).getXMLText());
            int maxCommentLength = info.isHoverTooltip ? 200 : 500;
            boolean trimmed = content.length() > maxCommentLength;
            String id = "workItem" + workItemId + ".comment" + expandId;
            String strId = trimmed ? "id='" + id + "'" : "";
            IContributor commenter = this.ensureResolved(auditableClient, comment.getCreator(), monitor);
            buffer.xml("<tr><td class='commentTitle'><i>");
            this.appendUserName(buffer, commenter);
            buffer.xml("</i>").plain(" (" + this.formatDate(comment.getCreationDate(), false) + "):").xml("</td></tr>");
            buffer.xml("<tr><td " + strId + " class='commentContent'>");
            if (trimmed) {
                buffer.xml(MarkupUtil.trim((String)content, (int)200));
                buffer.xml("[<a href=\"javascript:expandWorkItemComment" + workItemId + "('" + expandId + NLS.bind((String)"')\">{0}</a>]", (Object)Messages.WorkItemHTMLGenerator_MORE, (Object[])new Object[0]));
                contentOfClippedItems.add(content);
                ++expandId;
            } else {
                buffer.xml(content);
            }
            buffer.xml("</td></tr>");
            ++i;
        }
        if (contentOfClippedItems.size() > 0) {
            MarkupBuilder javascript = new MarkupBuilder();
            javascript.xml("<script type=\"text/javascript\">");
            this.appendJavascriptStringArray(javascript, "workItemComments" + workItemId, contentOfClippedItems);
            javascript.xml("function expandWorkItemComment" + workItemId + "(commentIndex) {");
            javascript.xml("  document.getElementById('workItem" + workItemId + ".comment' + commentIndex).innerHTML = workItemComments" + workItemId + "[commentIndex];");
            javascript.xml("}");
            javascript.xml("</script>");
            headDefinitions.put("workItemComments" + workItemId, javascript.toString());
        }
    }

    private XMLString decorate(LinkDetector linkDetector, XMLString xml) {
        StyledDocument document = new StyledDocument(xml);
        try {
            int line = 0;
            int lines = document.getNumberOfLines();
            while (line < lines) {
                IRegion lineInfo = document.getLineInformation(line);
                int offset = lineInfo.getOffset();
                String text = document.get(offset, lineInfo.getLength());
                List results = linkDetector.match(text);
                for (DetectedTextLink result : results) {
                    List uris = result.createURIs();
                    if (uris.size() == 0) continue;
                    URI uri = uris.size() > 1 ? MultiHyperlinkHandler.createMultiURI((List)uris) : (URI)uris.get(0);
                    int positionOffset = offset + result.getOffset();
                    int positionLength = result.getLength();
                    ReferencePosition position = new ReferencePosition(positionOffset, positionLength, uri, false);
                    document.setReferencePosition(position);
                }
                ++line;
            }
        }
        catch (BadLocationException x) {
            WorkItemIDEUIPlugin.getDefault().log(x.getMessage(), x);
        }
        return document.getHTML();
    }

    private void generateComment(HashMap headDefinitions, MarkupBuilder buffer, IComment comment, IDomainAdapter.Info info, IProgressMonitor monitor) throws TeamRepositoryException {
        ITeamRepository origin = (ITeamRepository)this.fWorkItem.getOrigin();
        IAuditableClient auditableClient = (IAuditableClient)origin.getClientLibrary(IAuditableClient.class);
        buffer.xml("<table>");
        IContributor contrib = this.ensureResolved(auditableClient, comment.getCreator(), monitor);
        String uri = URIService.createAuditableURI((ITeamRepository)((ITeamRepository)contrib.getOrigin()), (IItemHandle)contrib).toString();
        if (info.isFocusTooltip) {
            buffer.xml("<tr><td><a href='").plain(uri).xml("'>").plain(contrib.getName()).xml("</a>").plain(Messages.WorkItemHTMLGenerator_COLON).xml("<font color='gray'>").plain(this.formatDate(comment.getCreationDate(), false)).xml("</font></td></tr>");
        } else {
            buffer.xml("<tr><td>").plain(NLS.bind((String)Messages.WorkItemHTMLGenerator_ATTRIBUTE_COLON, (Object)contrib.getName(), (Object[])new Object[0])).xml("<font color='gray'>").plain(this.formatDate(comment.getCreationDate(), false)).xml("</font></td></tr>");
        }
        buffer.xml("<tr><td>");
        buffer.xml(this.format(comment.getHTMLContent().getXMLText()));
        buffer.xml("</td></tr>");
        buffer.xml("</table>");
    }

    private IContributor ensureResolved(IAuditableClient auditableClient, IContributorHandle handle, IProgressMonitor monitor) throws TeamRepositoryException {
        if (handle == null) {
            return null;
        }
        return (IContributor)auditableClient.resolveAuditable((IAuditableHandle)handle, ItemProfile.CONTRIBUTOR_DEFAULT, monitor);
    }

    private static String fixAPOS(String s) {
        return s.replaceAll("&apos;", "'");
    }

    private String getLocalUrl(URL url) {
        ImageDescriptor imageDescriptor = WorkItemUI.getImageDescriptor((URL)url);
        URL url2 = JazzResources.createURL((ImageDescriptor)imageDescriptor);
        return JazzResources.getConformingURL((URL)url2);
    }

    private void appendSectionContent(MarkupBuilder buffer, String content) {
        buffer.xml("\n<tr><td class='sectionContent'>");
        buffer.xml(content);
        buffer.xml("</td></tr>");
    }

    private String format(String text) {
        try {
            StringBuilder buffer = new StringBuilder();
            String[] lines = text.split("\\n");
            int i = 0;
            while (i < lines.length) {
                ReferencePosition refPos = this.scanLine(lines[i]);
                if (refPos != null) {
                    char[] chars = lines[i].toCharArray();
                    int refOffset = refPos.getOffset();
                    int refLength = refPos.getLength();
                    buffer.append(chars, 0, refOffset);
                    this.appendLink(buffer, new String(chars, refOffset, refLength), refPos.getReference().toString());
                    buffer.append(chars, refOffset + refLength, lines[i].length() - refOffset - refLength);
                } else {
                    buffer.append(lines[i]);
                }
                if (i < lines.length - 1) {
                    buffer.append("<br/>");
                }
                ++i;
            }
            return buffer.toString();
        }
        catch (Exception e) {
            WorkItemIDEUIPlugin.getDefault().log(Messages.WorkItemHTMLGenerator_EXCEPTION_CREATING_HTML_LINKS, e);
            return text;
        }
    }

    private void appendJavascriptStringArray(MarkupBuilder buffer, String varName, ArrayList strings) {
        buffer.xml("var " + varName + " =new Array(");
        int i = 0;
        while (i < strings.size()) {
            String content = (String)strings.get(i);
            if (i > 0) {
                buffer.xml(",");
            }
            buffer.xml("\"");
            this.escapeJavascriptString(buffer, content);
            buffer.xml("\"");
            ++i;
        }
        buffer.xml(");");
    }

    private ReferencePosition scanLine(String line) {
        List<ILineBasedSubstitutionScanner> scanners = LineBasedSubstitutionScannerRegistry.getDefault().getScanners();
        Iterator<ILineBasedSubstitutionScanner> iterator = scanners.iterator();
        while (iterator.hasNext()) {
            int j = 0;
            ILineBasedSubstitutionScanner scanner = iterator.next();
            ReferencePosition[] positions = scanner.scan(line);
            if (j >= positions.length) continue;
            return positions[j];
        }
        return null;
    }

    private void escapeJavascriptString(MarkupBuilder buffer, String string) {
        int i = 0;
        while (i < string.length()) {
            char c = string.charAt(i);
            if (c == '\'' || c == '\"') {
                buffer.xml("\\");
                buffer.xml(String.valueOf(c));
            } else if (c == '\n') {
                buffer.xml("\\n");
            } else {
                buffer.xml(String.valueOf(c));
            }
            ++i;
        }
    }

    private void appendSectionTitle(MarkupBuilder buffer, String title, int colspan) {
        buffer.xml("<tr><td colspan='" + colspan + "' class='sectionTitle'>");
        buffer.plain(title);
        buffer.xml("</td></tr>");
    }

    private void appendLink(StringBuilder buffer, String title, String href) {
        buffer.append("<a href='" + href + "'>");
        buffer.append(title);
        buffer.append("</a>");
    }

    private void appendAttributeValuePair(MarkupBuilder buffer, int colspan, String title, String content, URL image) {
        buffer.xml("<tr>");
        buffer.xml("<td valign='top' class='sectionContent'>").plain(NLS.bind((String)Messages.WorkItemHTMLGenerator_ATTRIBUTE_COLON, (Object)title, (Object[])new Object[0])).xml("</td>");
        if (image != null) {
            buffer.xml("<td width='1%'>");
            this.appendImage(buffer, JazzResources.getConformingURL((URL)image), content);
            buffer.xml("</td><td colspan='1'>");
        } else {
            buffer.xml("<td colspan='2'>");
        }
        buffer.plain(content);
        buffer.xml("</td></tr>");
    }

    private void appendImage(MarkupBuilder buffer, String href, String alt) {
        buffer.xml("<img src='").plain(href).xml("' border='0' alt='").plain(alt).xml("' />");
    }

    private String formatDate(Date date, boolean onlyDate) {
        if (date != null) {
            return onlyDate ? this.fDateFormatter.format(date) : String.valueOf(this.fDateFormatter.format(date)) + Messages.WorkItemHTMLGenerator_DATE_TIME_SPEPARATOR_WITHBLANK + this.fTimeFormatter.format(date);
        }
        return UNASSIGNED;
    }

    private void appendUserName(MarkupBuilder xml, IContributor c) {
        String name = c == null ? UNASSIGNED : (c.isArchived() ? NLS.bind((String)Messages.WorkItemHTMLGenerator_ARCHIVED, (Object)c.getName(), (Object[])new Object[0]) : c.getName());
        xml.plain(name);
    }
}

