/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.preview;

import com.ibm.team.jface.preview.IDomainAdapter;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IManagedItem;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.PermissionDeniedException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.common.model.IComment;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.common.model.ItemProfile;
import com.ibm.team.workitem.common.text.WorkItemTextUtilities;
import com.ibm.team.workitem.ide.ui.internal.WorkItemIDEUIPlugin;
import com.ibm.team.workitem.ide.ui.internal.preview.Messages;
import com.ibm.team.workitem.ide.ui.internal.preview.RestWorkItemHTMLGenerator;
import com.ibm.team.workitem.ide.ui.internal.preview.WorkItemHTMLGenerator;
import com.ibm.team.workitem.rcp.ui.internal.preview.ResolveDomainAdapter;
import java.util.HashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EObject;

public class WorkItemDomainAdapter
extends ResolveDomainAdapter {
    private static final boolean USE_REST_WORK_ITEM_GENERATOR = true;

    public String generateContentAsText(Object input) {
        try {
            input = this.resolve(input, IWorkItem.SMALL_PROFILE);
        }
        catch (PermissionDeniedException permissionDeniedException) {
            return this.permissionDenied();
        }
        if (input instanceof IWorkItem) {
            return ((IWorkItem)input).getHTMLSummary().getPlainText();
        }
        if (input instanceof IComment) {
            return ((IComment)input).getHTMLContent().getPlainText();
        }
        if (input instanceof String) {
            return (String)input;
        }
        return "";
    }

    public void generateContentAsHTML(HashMap head, StringBuffer body, Object input, IDomainAdapter.Info info) {
        this.generateContentAsHTML(head, body, input, info, (IProgressMonitor)new NullProgressMonitor());
    }

    public void generateContentAsHTML(HashMap head, StringBuffer body, Object input, IDomainAdapter.Info info, IProgressMonitor monitor) {
        EObject container;
        try {
            input = this.resolve(input, IWorkItem.FULL_PROFILE);
        }
        catch (PermissionDeniedException permissionDeniedException) {
            body.append(this.permissionDenied());
            return;
        }
        if (input instanceof IWorkItem) {
            if (!info.isHoverTooltip) {
                new RestWorkItemHTMLGenerator().generate((IWorkItem)input, head, body, info, monitor);
            } else {
                new WorkItemHTMLGenerator((IWorkItem)input).generate(head, body, info);
            }
        }
        if (input instanceof IComment && (container = ((EObject)input).eContainer()) instanceof IWorkItem) {
            new WorkItemHTMLGenerator((IWorkItem)container).generateComment(head, body, (IComment)input, info);
        }
        if (input instanceof String) {
            body.append(input);
        }
    }

    public String generateTitle(Object input) {
        try {
            input = this.resolve(input, IWorkItem.SMALL_PROFILE);
        }
        catch (PermissionDeniedException permissionDeniedException) {
            return this.permissionDenied();
        }
        if (input instanceof IWorkItem) {
            return WorkItemTextUtilities.getWorkItemText((IWorkItem)((IWorkItem)input));
        }
        return "";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object resolve(Object input, ItemProfile itemProfile) throws PermissionDeniedException {
        if (input instanceof IManagedItem && ((IManagedItem)input).isNewItem()) {
            return input;
        }
        if (input instanceof IWorkItemHandle) {
            IWorkItemHandle wih = (IWorkItemHandle)input;
            try {
                ITeamRepository teamRepository = (ITeamRepository)wih.getOrigin();
                if (teamRepository == null) return Messages.WorkItemDomainAdapter_COULD_NOT_RESOLVE;
                if (!teamRepository.loggedIn()) {
                    return Messages.WorkItemDomainAdapter_NOT_LOGGED_IN;
                }
                if (teamRepository.getErrorState() == 0) return ((IWorkItemClient)teamRepository.getClientLibrary(IWorkItemClient.class)).resolveWorkItem(wih, itemProfile, null);
                return Messages.WorkItemDomainAdapter_COULD_NOT_CONNECT;
            }
            catch (ItemNotFoundException itemNotFoundException) {
                return Messages.WorkItemDomainAdapter_COULD_NOT_RESOLVE;
            }
            catch (PermissionDeniedException e) {
                throw e;
            }
            catch (TeamRepositoryException x) {
                WorkItemIDEUIPlugin.getDefault().log(Messages.WorkItemDomainAdapter_EXCEPTION_RESOLVING_WORKITEM, x);
                return Messages.WorkItemDomainAdapter_COULD_NOT_RESOLVE;
            }
        } else {
            if (!(input instanceof IComment)) return Messages.WorkItemDomainAdapter_COULD_NOT_RESOLVE;
            return input;
        }
    }

    public String generateJobInfo(Object input, IDomainAdapter.Info info) {
        IWorkItem workItem;
        if (info.isHoverTooltip) {
            return null;
        }
        if (input instanceof IWorkItem && (workItem = (IWorkItem)input).isPropertySet(IWorkItem.ID_PROPERTY) && workItem.isPropertySet(IWorkItem.SUMMARY_PROPERTY)) {
            return NLS.bind((String)Messages.WorkItemDomainAdapter_RESOLVING, (Object)WorkItemTextUtilities.getWorkItemText((IWorkItem)workItem), (Object[])new Object[0]);
        }
        return Messages.WorkItemDomainAdapter_RESOLVING_WORKITEM;
    }
}

