/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.mailconfig;

import com.ibm.team.repository.client.IContributorManager;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorDetails;
import com.ibm.team.repository.common.IContributorDetailsHandle;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.ide.ui.internal.WorkItemIDEUIPlugin;
import com.ibm.team.workitem.ide.ui.internal.mailconfig.Messages;
import java.util.Collections;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPersistableElement;

public class MailConfigEditorInput
extends PlatformObject
implements IEditorInput {
    private IContributor fContributor;
    private IContributorManager fContributorManager;
    private IItemManager fItemManager;

    public MailConfigEditorInput(IContributor contributor) {
        Assert.isNotNull((Object)contributor);
        Assert.isLegal((boolean)(contributor.getOrigin() instanceof ITeamRepository), (String)Messages.MailConfigEditorInput_ORIGIN_NOT_TEAMREPOSITORY);
        this.fContributor = contributor;
        this.fContributorManager = ((ITeamRepository)this.fContributor.getOrigin()).contributorManager();
        this.fItemManager = ((ITeamRepository)this.fContributor.getOrigin()).itemManager();
    }

    IContributorDetails loadContributorDetails(IProgressMonitor monitor) throws TeamRepositoryException {
        IContributorDetailsHandle detailsHandle;
        if (!this.fContributor.isNewItem()) {
            this.fContributor = (IContributor)this.fItemManager.fetchCompleteItem((IItemHandle)this.fContributor, 1, (IProgressMonitor)new SubProgressMonitor(monitor, 100, 2));
        }
        if ((detailsHandle = this.fContributor.getDetails()) != null) {
            SubProgressMonitor subProgressMonitor = new SubProgressMonitor(monitor, 100, 2);
            return (IContributorDetails)this.fItemManager.fetchPartialItem((IItemHandle)detailsHandle, 1, Collections.singleton("com.ibm.team.repository.item.allStateExtensions"), (IProgressMonitor)subProgressMonitor);
        }
        return (IContributorDetails)IContributorDetails.ITEM_TYPE.createItem((Object)this.fItemManager.teamRepository());
    }

    void saveContributorDetails(IProgressMonitor monitor, IContributorDetails details) {
        try {
            this.fContributorManager.setContributorDetails((IContributorHandle)this.fContributor, details, monitor);
        }
        catch (TeamRepositoryException e) {
            WorkItemIDEUIPlugin.getDefault().log(e.getMessage(), e);
        }
    }

    public boolean exists() {
        return true;
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public String getName() {
        return this.fContributor.getName();
    }

    public String getToolTipText() {
        return this.fContributor.getName();
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public boolean equals(Object obj) {
        if (obj instanceof MailConfigEditorInput) {
            MailConfigEditorInput input = (MailConfigEditorInput)((Object)obj);
            return input.fContributor.sameItemId((IItemHandle)this.fContributor);
        }
        return false;
    }

    public int hashCode() {
        return this.fContributor.getItemId().hashCode();
    }
}

