/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.integration;

import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProcessConfigurationElement;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.ide.ui.IAttributeValueProposalProvider;
import com.ibm.team.process.ide.ui.IProcessCompletionProposal;
import com.ibm.team.process.ide.ui.IProcessProposalContext;
import com.ibm.team.process.ide.ui.ProcessCompletionProposalFactory;
import com.ibm.team.process.internal.common.model.specification.ConfigurationDataElement;
import com.ibm.team.process.internal.common.model.specification.DataElement;
import com.ibm.team.process.internal.common.model.specification.ProcessSpecificationModel;
import com.ibm.team.process.internal.common.model.specification.ProjectConfigurationElement;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.client.IAuditableClient;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.internal.RequiredPropertiesManager;
import com.ibm.team.workitem.common.internal.model.WorkItemAttributes;
import com.ibm.team.workitem.common.internal.presentations.EditorPresentationManager;
import com.ibm.team.workitem.common.internal.presentations.QuickInformationConfigurationManager;
import com.ibm.team.workitem.common.internal.util.CollectionUtils;
import com.ibm.team.workitem.common.model.AttributeType;
import com.ibm.team.workitem.common.model.AttributeTypes;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.IWorkItemType;
import com.ibm.team.workitem.common.model.Identifier;
import com.ibm.team.workitem.ide.ui.internal.WorkItemIDEUIPlugin;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.PresentationsManager;
import com.ibm.team.workitem.ide.ui.internal.editor.quickinformation.QuickInformationManager;
import com.ibm.team.workitem.ide.ui.internal.integration.Messages;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IDocument;

public class WorkItemProcessProposalProvider
implements IAttributeValueProposalProvider {
    private static final String WORK_ITEM_TYPE_URI = "http://com.ibm.team.workitem/workitemTypes";
    private static final String REQUIRED_PROPERTIES_URI = "http://com.ibm.team.workitem/requiredProperties";
    private static final String PRESENTATIONS_URI = "http://com.ibm.team.workitem.editor/presentations";
    private static final String EDITOR_BINDING_URI = "http://com.ibm.team.workitem.editor/workitemTypeEditorIdBinding";
    private static final String QUICKINFORMATION_URI = "http://com.ibm.team.workitem.editor/quickinformation";
    private static final String TYPE_ELEMENT = "type";
    private static final String CUSTOM_ATTRIBUTES_ELEMENT = "customAttributes";
    private static final String CUSTOM_ATTRIBUTE_ELEMENT = "customAttribute";
    private static final String PROPERTIES_ELEMENT = "properties";
    private static final String PROPERTY_ELEMENT = "property";
    private static final String CATEGORY_ATTRIBUTE = "category";
    private static final String TYPE_ATTRIBUTE = "type";
    private static final String WORK_ITEM_TYPE_ATTRIBUTE = "workItemType";
    private static final String WORK_ITEM_TYPE_CATEGORY_ATTRIBUTE = "workItemTypeCategory";
    private static final String ID_ATTRIBUTE = "id";

    public IProcessCompletionProposal[] computeProposals(IProcessArea processArea, IProcessProposalContext context, IProgressMonitor monitor) {
        try {
            return this.internalComputeProposals(processArea, context, monitor);
        }
        catch (TeamRepositoryException x) {
            WorkItemIDEUIPlugin.getDefault().log("Exception computing completion proposals", x);
            return new IProcessCompletionProposal[0];
        }
    }

    public IProcessCompletionProposal[] internalComputeProposals(IProcessArea processArea, IProcessProposalContext context, IProgressMonitor monitor) throws TeamRepositoryException {
        if (processArea != null && context.namespaceURI().equals(REQUIRED_PROPERTIES_URI) && context.getElement().equals(PROPERTIES_ELEMENT) && context.getAttribute().equals(WORK_ITEM_TYPE_ATTRIBUTE)) {
            return this.computeWorkItemTypeProposals(processArea, context, monitor);
        }
        if (processArea != null && context.namespaceURI().equals(REQUIRED_PROPERTIES_URI) && context.getElement().equals(PROPERTIES_ELEMENT) && context.getAttribute().equals(WORK_ITEM_TYPE_CATEGORY_ATTRIBUTE)) {
            return this.computeWorkItemTypeCategoryProposals(processArea, context, monitor);
        }
        if (context.namespaceURI().equals(REQUIRED_PROPERTIES_URI) && context.getElement().equals(PROPERTY_ELEMENT) && context.getAttribute().equals(ID_ATTRIBUTE)) {
            return this.computeAttributeProposals(context);
        }
        if (processArea != null && context.namespaceURI().equals(WORK_ITEM_TYPE_URI) && context.getElement().equals("type") && context.getAttribute().equals(CATEGORY_ATTRIBUTE)) {
            return this.computeWorkItemTypeCategoryProposals(processArea, context, monitor);
        }
        if (processArea != null && context.namespaceURI().equals(WORK_ITEM_TYPE_URI) && context.getElement().equals(CUSTOM_ATTRIBUTES_ELEMENT) && context.getAttribute().equals(CATEGORY_ATTRIBUTE)) {
            return this.computeWorkItemTypeCategoryProposals(processArea, context, monitor);
        }
        if (context.namespaceURI().equals(WORK_ITEM_TYPE_URI) && context.getElement().equals(CUSTOM_ATTRIBUTE_ELEMENT) && context.getAttribute().equals("type")) {
            return this.computeAttributeTypeProposals(context);
        }
        if (context.namespaceURI().equals(PRESENTATIONS_URI) && context.getElement().equals("presentation") && context.getAttribute().equals("attributeId")) {
            return this.computePresentationsAttributeIdProposals(processArea, context, monitor);
        }
        if (context.namespaceURI().equals(PRESENTATIONS_URI) && context.getElement().equals("presentation") && context.getAttribute().equals("kind")) {
            return this.computePresentationsPresentationProposals(context);
        }
        if (context.namespaceURI().equals(PRESENTATIONS_URI) && context.getElement().equals(PROPERTY_ELEMENT) && context.getAttribute().equals("key")) {
            return this.computePresentationsKeyProposals(context);
        }
        if (context.namespaceURI().equals(PRESENTATIONS_URI) && context.getElement().equals(PROPERTY_ELEMENT) && context.getAttribute().equals("value")) {
            return this.computePresentationsValueProposals(processArea, context, monitor);
        }
        if (context.namespaceURI().equals(QUICKINFORMATION_URI) && context.getElement().equals(PROPERTY_ELEMENT) && context.getAttribute().equals("key")) {
            return this.computeQuickinformationKeyProposals(context);
        }
        if (context.namespaceURI().equals(EDITOR_BINDING_URI) && context.getElement().equals("workitemTypeEditorIdBinding") && context.getAttribute().equals("editorId")) {
            return this.computePresentationEditorIdProposals(processArea, context, monitor);
        }
        if (context.namespaceURI().equals(EDITOR_BINDING_URI) && context.getElement().equals("workitemTypeEditorIdBinding") && context.getAttribute().equals("workitemType")) {
            return this.computeWorkItemTypeProposals(processArea, context, monitor);
        }
        if (context.namespaceURI().equals(PRESENTATIONS_URI) && context.getElement().equals("tab") && context.getAttribute().equals("tabId")) {
            return this.computePresentationTabIdProposals(processArea, context, monitor);
        }
        if (context.namespaceURI().equals(PRESENTATIONS_URI) && context.getElement().equals("section") && context.getAttribute().equals("sectionId")) {
            return this.computePresentationSectionIdProposals(processArea, context, monitor);
        }
        if (context.namespaceURI().equals(QUICKINFORMATION_URI) && context.getElement().equals("presentation") && context.getAttribute().equals("kind")) {
            return this.computeQuickinformationPresentationProposals(context);
        }
        return new IProcessCompletionProposal[0];
    }

    private IProcessCompletionProposal[] computeWorkItemTypeCategoryProposals(IProcessArea processArea, IProcessProposalContext context, IProgressMonitor monitor) throws TeamRepositoryException {
        ITeamRepository teamRepository = (ITeamRepository)processArea.getOrigin();
        IWorkItemClient workItemClient = (IWorkItemClient)teamRepository.getClientLibrary(IWorkItemClient.class);
        List types = workItemClient.findWorkItemTypes(processArea.getProjectArea(), monitor);
        HashSet<String> categories = new HashSet<String>();
        for (IWorkItemType type : types) {
            categories.add(type.getCategory());
        }
        ArrayList<IProcessCompletionProposal> proposals = new ArrayList<IProcessCompletionProposal>();
        for (String category : categories) {
            proposals.add(ProcessCompletionProposalFactory.createProposal((IProcessProposalContext)context, (String)category));
        }
        return proposals.toArray(new IProcessCompletionProposal[proposals.size()]);
    }

    private IProcessCompletionProposal[] computeAttributeProposals(IProcessProposalContext context) {
        ArrayList<IProcessCompletionProposal> proposals = new ArrayList<IProcessCompletionProposal>();
        for (String property : RequiredPropertiesManager.SUPPORTED_BUILT_IN_ATTRIBUTES) {
            proposals.add(ProcessCompletionProposalFactory.createProposal((IProcessProposalContext)context, (String)WorkItemAttributes.getPropertyIdentifier((String)property).getStringIdentifier()));
        }
        return proposals.toArray(new IProcessCompletionProposal[proposals.size()]);
    }

    private IProcessCompletionProposal[] computeAttributeTypeProposals(IProcessProposalContext context) {
        HashSet<String> typeIds = new HashSet<String>();
        ArrayList<IProcessCompletionProposal> proposals = new ArrayList<IProcessCompletionProposal>();
        DataElement data = this.findConfigurationData(context);
        if (data != null) {
            ConfigurationDataElement[] configurationDataElementArray = data.getConfigurationData();
            int n = configurationDataElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                ConfigurationDataElement enumerationsData = configurationDataElementArray[n2];
                if ("com.ibm.team.workitem.configuration.enumerations".equals(enumerationsData.getId())) {
                    IProcessConfigurationElement[] iProcessConfigurationElementArray = enumerationsData.getElements();
                    int n3 = iProcessConfigurationElementArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String typeId;
                        IProcessConfigurationElement enumeration = iProcessConfigurationElementArray[n4];
                        if ("enumeration".equals(enumeration.getName()) && (typeId = enumeration.getAttribute("attributeTypeId")) != null && typeId.length() > 0 && !typeIds.contains(typeId)) {
                            proposals.add(ProcessCompletionProposalFactory.createProposal((IProcessProposalContext)context, (String)typeId));
                            typeIds.add(typeId);
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        List attributeTypes = AttributeTypes.getAttributeTypes();
        for (AttributeType type : attributeTypes) {
            String typeId = type.getIdentifier();
            if (AttributeTypes.isEnumerationAttributeType((String)typeId) || !AttributeTypes.isSupportedCustomAttributeType((String)typeId) || typeIds.contains(typeId)) continue;
            proposals.add(ProcessCompletionProposalFactory.createProposal((IProcessProposalContext)context, (String)typeId));
            typeIds.add(typeId);
        }
        return proposals.toArray(new IProcessCompletionProposal[proposals.size()]);
    }

    private DataElement findConfigurationData(IProcessProposalContext context) {
        IDocument specification = context.getDocument();
        if (specification == null) {
            return null;
        }
        ProcessSpecificationModel model = new ProcessSpecificationModel();
        model.initialize(specification);
        ProjectConfigurationElement configuration = model.getProjectConfiguration();
        if (configuration == null) {
            return null;
        }
        DataElement data = configuration.getData();
        if (data == null) {
            return null;
        }
        return data;
    }

    private IProcessCompletionProposal[] computePresentationsKeyProposals(IProcessProposalContext context) {
        ArrayList<IProcessCompletionProposal> proposals = new ArrayList<IProcessCompletionProposal>();
        String[] stringArray = EditorPresentationManager.ALL_KEYS;
        int n = EditorPresentationManager.ALL_KEYS.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            proposals.add(ProcessCompletionProposalFactory.createProposal((IProcessProposalContext)context, (String)key));
            ++n2;
        }
        proposals.add(ProcessCompletionProposalFactory.createProposal((IProcessProposalContext)context, (String)"quickinformationConfiguration"));
        return proposals.toArray(new IProcessCompletionProposal[proposals.size()]);
    }

    private IProcessCompletionProposal[] computePresentationsValueProposals(IProcessArea processArea, IProcessProposalContext context, IProgressMonitor monitor) throws TeamRepositoryException {
        ArrayList<IProcessCompletionProposal> proposals = new ArrayList<IProcessCompletionProposal>();
        String[] stringArray = EditorPresentationManager.ALL_VALUES;
        int n = EditorPresentationManager.ALL_VALUES.length;
        int n2 = 0;
        while (n2 < n) {
            String value = stringArray[n2];
            if (value.equals("")) {
                proposals.add(ProcessCompletionProposalFactory.createProposal((IProcessProposalContext)context, (String)value, (String)Messages.WorkItemProcessProposalProvider_EMPTY_ENTRY));
            } else {
                proposals.add(ProcessCompletionProposalFactory.createProposal((IProcessProposalContext)context, (String)value));
            }
            ++n2;
        }
        ITeamRepository teamRepository = (ITeamRepository)processArea.getOrigin();
        IAuditableClient auditableClient = (IAuditableClient)teamRepository.getClientLibrary(IAuditableClient.class);
        QuickInformationConfigurationManager mgr = new QuickInformationConfigurationManager((IAuditableCommon)auditableClient);
        for (String qi : mgr.getQuickinformationConfigurationIds(processArea.getProjectArea(), monitor)) {
            proposals.add(ProcessCompletionProposalFactory.createProposal((IProcessProposalContext)context, (String)qi));
        }
        return proposals.toArray(new IProcessCompletionProposal[proposals.size()]);
    }

    private IProcessCompletionProposal[] computeQuickinformationKeyProposals(IProcessProposalContext context) {
        ArrayList<IProcessCompletionProposal> proposals = new ArrayList<IProcessCompletionProposal>();
        proposals.add(ProcessCompletionProposalFactory.createProposal((IProcessProposalContext)context, (String)"endpointId"));
        proposals.add(ProcessCompletionProposalFactory.createProposal((IProcessProposalContext)context, (String)"linkTarget"));
        return proposals.toArray(new IProcessCompletionProposal[proposals.size()]);
    }

    private IProcessCompletionProposal[] computePresentationsPresentationProposals(IProcessProposalContext context) {
        ArrayList<IProcessCompletionProposal> proposals = new ArrayList<IProcessCompletionProposal>();
        for (String presentation : PresentationsManager.getPresentations()) {
            if (presentation.equals("com.ibm.team.workitem.kind.internal.linksSummary")) continue;
            proposals.add(ProcessCompletionProposalFactory.createProposal((IProcessProposalContext)context, (String)presentation));
        }
        proposals.add(ProcessCompletionProposalFactory.createProposal((IProcessProposalContext)context, (String)"com.ibm.team.workitem.kind.special.doNotShow"));
        return proposals.toArray(new IProcessCompletionProposal[proposals.size()]);
    }

    private IProcessCompletionProposal[] computeQuickinformationPresentationProposals(IProcessProposalContext context) {
        ArrayList<IProcessCompletionProposal> proposals = new ArrayList<IProcessCompletionProposal>();
        for (String presentation : QuickInformationManager.getQuickInformationEntries()) {
            proposals.add(ProcessCompletionProposalFactory.createProposal((IProcessProposalContext)context, (String)presentation));
        }
        return proposals.toArray(new IProcessCompletionProposal[proposals.size()]);
    }

    private IProcessCompletionProposal[] computePresentationSectionIdProposals(IProcessArea processArea, IProcessProposalContext context, IProgressMonitor monitor) throws TeamRepositoryException {
        if (!(processArea instanceof IProjectAreaHandle)) {
            return new IProcessCompletionProposal[0];
        }
        ITeamRepository teamRepository = (ITeamRepository)processArea.getOrigin();
        IAuditableClient auditableClient = (IAuditableClient)teamRepository.getClientLibrary(IAuditableClient.class);
        EditorPresentationManager mgr = new EditorPresentationManager((IAuditableCommon)auditableClient);
        ArrayList<IProcessCompletionProposal> proposals = new ArrayList<IProcessCompletionProposal>();
        for (String id : mgr.getSectionIds((IProjectAreaHandle)processArea, monitor)) {
            proposals.add(ProcessCompletionProposalFactory.createProposal((IProcessProposalContext)context, (String)id));
        }
        return proposals.toArray(new IProcessCompletionProposal[proposals.size()]);
    }

    private IProcessCompletionProposal[] computePresentationTabIdProposals(IProcessArea processArea, IProcessProposalContext context, IProgressMonitor monitor) throws TeamRepositoryException {
        if (!(processArea instanceof IProjectAreaHandle)) {
            return new IProcessCompletionProposal[0];
        }
        ITeamRepository teamRepository = (ITeamRepository)processArea.getOrigin();
        IAuditableClient auditableClient = (IAuditableClient)teamRepository.getClientLibrary(IAuditableClient.class);
        EditorPresentationManager mgr = new EditorPresentationManager((IAuditableCommon)auditableClient);
        ArrayList<IProcessCompletionProposal> proposals = new ArrayList<IProcessCompletionProposal>();
        for (String id : mgr.getTabIds((IProjectAreaHandle)processArea, monitor)) {
            proposals.add(ProcessCompletionProposalFactory.createProposal((IProcessProposalContext)context, (String)id));
        }
        return proposals.toArray(new IProcessCompletionProposal[proposals.size()]);
    }

    private IProcessCompletionProposal[] computePresentationEditorIdProposals(IProcessArea processArea, IProcessProposalContext context, IProgressMonitor monitor) throws TeamRepositoryException {
        if (!(processArea instanceof IProjectAreaHandle)) {
            return new IProcessCompletionProposal[0];
        }
        ITeamRepository teamRepository = (ITeamRepository)processArea.getOrigin();
        IAuditableClient auditableClient = (IAuditableClient)teamRepository.getClientLibrary(IAuditableClient.class);
        EditorPresentationManager mgr = new EditorPresentationManager((IAuditableCommon)auditableClient);
        ArrayList<IProcessCompletionProposal> proposals = new ArrayList<IProcessCompletionProposal>();
        for (String id : mgr.getEditorIds((IProjectAreaHandle)processArea, monitor)) {
            proposals.add(ProcessCompletionProposalFactory.createProposal((IProcessProposalContext)context, (String)id));
        }
        return proposals.toArray(new IProcessCompletionProposal[proposals.size()]);
    }

    private IProcessCompletionProposal[] computeWorkItemTypeProposals(IProcessArea processArea, IProcessProposalContext context, IProgressMonitor monitor) throws TeamRepositoryException {
        ArrayList<IProcessCompletionProposal> proposals = new ArrayList<IProcessCompletionProposal>();
        ITeamRepository teamRepository = (ITeamRepository)processArea.getOrigin();
        IWorkItemClient workItemClient = (IWorkItemClient)teamRepository.getClientLibrary(IWorkItemClient.class);
        List types = workItemClient.findWorkItemTypes(processArea.getProjectArea(), monitor);
        for (IWorkItemType type : types) {
            proposals.add(ProcessCompletionProposalFactory.createProposal((IProcessProposalContext)context, (String)type.getIdentifier(), (String)type.getDisplayName()));
        }
        return proposals.toArray(new IProcessCompletionProposal[proposals.size()]);
    }

    private IProcessCompletionProposal[] computePresentationsAttributeIdProposals(IProcessArea processArea, IProcessProposalContext context, IProgressMonitor monitor) throws TeamRepositoryException {
        ArrayList<IProcessCompletionProposal> proposals = new ArrayList<IProcessCompletionProposal>();
        ITeamRepository teamRepository = (ITeamRepository)processArea.getOrigin();
        IAuditableClient auditableClient = (IAuditableClient)teamRepository.getClientLibrary(IAuditableClient.class);
        List attributes = CollectionUtils.removeNulls((List)auditableClient.findAuditables(IAttribute.DEFAULT_PROFILE, monitor));
        HashSet<Identifier> idents = new HashSet<Identifier>();
        for (IAttribute att : attributes) {
            if (!att.getProjectArea().sameItemId((IItemHandle)processArea.getProjectArea())) continue;
            idents.add(WorkItemAttributes.getPropertyIdentifier((String)att.getIdentifier()));
        }
        for (Identifier id : idents) {
            proposals.add(ProcessCompletionProposalFactory.createProposal((IProcessProposalContext)context, (String)id.getStringIdentifier()));
        }
        return proposals.toArray(new IProcessCompletionProposal[proposals.size()]);
    }
}

