/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.integration;

import com.ibm.team.foundation.common.DetectedTextLink;
import com.ibm.team.foundation.common.LinkDetector;
import com.ibm.team.foundation.common.TextLinkDetectorManager;
import com.ibm.team.workitem.ide.ui.internal.integration.WorkItemHyperLink;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.text.hyperlink.URLHyperlinkDetector;

public class WorkItemHyperlinkDetector
extends URLHyperlinkDetector {
    private static final LinkDetector fgDetector = TextLinkDetectorManager.getDefault().createLinkDetector();

    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        IDocument document = textViewer.getDocument();
        ArrayList<WorkItemHyperLink> matches = new ArrayList<WorkItemHyperLink>();
        try {
            int line = document.getLineOfOffset(region.getOffset());
            int start = document.getLineOffset(line);
            int length = document.getLineLength(line);
            String text = document.get(start, length);
            List results = fgDetector.match(text);
            for (DetectedTextLink link : results) {
                if (start + link.getOffset() > region.getOffset() || start + link.getOffset() + link.getLength() <= region.getOffset()) continue;
                matches.add(new WorkItemHyperLink(link, start));
            }
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
        return matches.size() > 0 ? matches.toArray(new WorkItemHyperLink[0]) : null;
    }
}

