/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.integration;

import com.ibm.team.workitem.ide.ui.internal.editor.comments.ILineBasedSubstitutionScanner;
import com.ibm.team.workitem.ide.ui.internal.editor.comments.LineBasedSubstitutionScannerRegistry;
import java.util.List;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.ui.console.IConsoleView;
import org.eclipse.ui.console.TextConsole;

public class IntegrationUtils {
    public static String extractContentFromConsole(ITextSelection selection, IConsoleView view) {
        if (view.getConsole() instanceof TextConsole) {
            try {
                ITextSelection ts = selection;
                TextConsole tc = (TextConsole)view.getConsole();
                IDocument document = tc.getDocument();
                int startOffset = ts.getOffset();
                if (IntegrationUtils.matches(IntegrationUtils.getLines(document, ts.getStartLine(), 1))) {
                    int startLine = ts.getStartLine();
                    while (startLine > 0 && IntegrationUtils.matches(IntegrationUtils.getLines(document, startLine - 1, 1))) {
                        --startLine;
                    }
                    startOffset = IntegrationUtils.getLineStartOffset(document, startLine);
                }
                int endOffset = ts.getOffset() + ts.getLength();
                if (IntegrationUtils.matches(IntegrationUtils.getLines(document, ts.getEndLine(), 1))) {
                    int endLine = ts.getEndLine();
                    while (endLine + 1 < document.getNumberOfLines() && IntegrationUtils.matches(IntegrationUtils.getLines(document, endLine + 1, 1))) {
                        ++endLine;
                    }
                    endOffset = IntegrationUtils.getLineEndOffset(document, endLine);
                }
                if (startOffset == endOffset) {
                    startOffset = IntegrationUtils.getLineStartOffset(document, ts.getStartLine());
                    endOffset = IntegrationUtils.getLineEndOffset(document, ts.getEndLine());
                }
                return document.get(startOffset, endOffset - startOffset);
            }
            catch (BadLocationException x) {
                throw new RuntimeException(x);
            }
        }
        return null;
    }

    public static String getLines(IDocument document, int lineOffset, int lineLength) throws BadLocationException {
        int startOffset = IntegrationUtils.getLineStartOffset(document, lineOffset);
        int endOffset = IntegrationUtils.getLineEndOffset(document, lineOffset + lineLength - 1);
        return document.get(startOffset, endOffset - startOffset);
    }

    public static int getLineEndOffset(IDocument document, int lineOffset) throws BadLocationException {
        if (lineOffset >= document.getNumberOfLines()) {
            lineOffset = document.getNumberOfLines() - 1;
        }
        return IntegrationUtils.getLineStartOffset(document, lineOffset) + document.getLineInformation(lineOffset).getLength();
    }

    public static int getLineStartOffset(IDocument document, int lineOffset) throws BadLocationException {
        if (lineOffset >= document.getNumberOfLines()) {
            lineOffset = document.getNumberOfLines() - 1;
        }
        return document.getLineOffset(lineOffset);
    }

    private static boolean matches(String text) {
        StringBuilder buffer = new StringBuilder(text);
        IntegrationUtils.replace(buffer, "<", "&lt;");
        IntegrationUtils.replace(buffer, ">", "&gt;");
        List<ILineBasedSubstitutionScanner> scanners = LineBasedSubstitutionScannerRegistry.getDefault().getScanners();
        for (ILineBasedSubstitutionScanner scanner : scanners) {
            if (!scanner.substitute(text, buffer, 0)) continue;
            return true;
        }
        return false;
    }

    private static void replace(StringBuilder buffer, String string, String replacement) {
        int i = buffer.indexOf(string);
        while (i != -1) {
            buffer.replace(i, i + string.length(), replacement);
            i = buffer.indexOf(string, i);
        }
    }
}

