/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.integration;

import com.ibm.team.foundation.common.text.XMLString;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.client.WorkItemOperation;
import com.ibm.team.workitem.client.WorkItemWorkingCopy;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.ide.ui.internal.integration.InitializeWorkItemOperation;
import com.ibm.team.workitem.ide.ui.internal.integration.LogEntry;
import com.ibm.team.workitem.ide.ui.internal.integration.Messages;
import com.ibm.team.workitem.rcp.ui.IWorkItemUIWorkingCopy;
import com.ibm.team.workitem.rcp.ui.WorkItemUI;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;

public class CreateWorkItemFromErrorLog
implements IViewActionDelegate {
    private IWorkbenchPart fPart;

    public void run(IAction action) {
        if (this.fPart == null || this.fPart.getSite().getSelectionProvider() == null) {
            return;
        }
        ISelection selection = this.fPart.getSite().getSelectionProvider().getSelection();
        final LogEntry logEntry = this.getLogEntry(selection);
        if (logEntry == null) {
            return;
        }
        InitializeWorkItemOperation operation = new InitializeWorkItemOperation(Messages.CreateWorkItemAction_CREATING_WORKITEM, this.fPart){

            protected void execute(WorkItemWorkingCopy workingCopy, IProgressMonitor monitor) throws TeamRepositoryException {
                CreateWorkItemFromErrorLog.this.initialize(workingCopy, logEntry, true);
            }
        };
        WorkItemUI.createWorkItem((Shell)this.fPart.getSite().getShell(), null, (WorkItemOperation)operation);
    }

    public void init(IViewPart part) {
        this.fPart = part;
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    private void initialize(WorkItemWorkingCopy workingCopy, LogEntry logEntry, boolean useSession) {
        String content;
        IWorkItem workItem = workingCopy.getWorkItem();
        String message = logEntry.getMessage();
        if (message != null) {
            workItem.setHTMLSummary(XMLString.createFromPlainText((String)message.trim()));
        }
        String sessionData = logEntry.getSessionData();
        if (useSession && sessionData != null) {
            workItem.setHTMLDescription(XMLString.createFromPlainText((String)sessionData.trim()));
        }
        String string = content = (content = logEntry.getStack()) != null ? content.trim() : "";
        if (content.length() > 0) {
            IWorkItemUIWorkingCopy uiCopy = (IWorkItemUIWorkingCopy)workingCopy.getAdapter(IWorkItemUIWorkingCopy.class);
            uiCopy.getNewComment().set(content);
        }
    }

    private LogEntry getLogEntry(ISelection selection) {
        if (selection instanceof IStructuredSelection && ((IStructuredSelection)selection).size() == 1) {
            Object element = ((IStructuredSelection)selection).getFirstElement();
            return LogEntry.create(element);
        }
        return null;
    }
}

