/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.integration;

import com.ibm.team.foundation.common.text.XMLString;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.client.WorkItemOperation;
import com.ibm.team.workitem.client.WorkItemWorkingCopy;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.ide.ui.internal.integration.InitializeWorkItemOperation;
import com.ibm.team.workitem.ide.ui.internal.integration.IntegrationUtils;
import com.ibm.team.workitem.ide.ui.internal.integration.Messages;
import com.ibm.team.workitem.rcp.ui.IWorkItemUIWorkingCopy;
import com.ibm.team.workitem.rcp.ui.WorkItemUI;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;

public abstract class CreateWorkItemAction
implements IViewActionDelegate,
IObjectActionDelegate {
    private static final int DESCRIPTION_LINES = 5;
    private IWorkbenchPart fPart;
    private ISelection fSelection;

    protected abstract void updateEnablement(IAction var1, ISelection var2);

    protected abstract String extractContent(ISelection var1);

    protected void initializeWorkItem(WorkItemWorkingCopy workingCopy, ISelection selection, IProgressMonitor monitor) throws TeamRepositoryException {
        try {
            String content = this.extractContent(selection);
            if (content == null) {
                return;
            }
            Document document = new Document(content);
            IWorkItem workItem = workingCopy.getWorkItem();
            workItem.setHTMLSummary(XMLString.createFromPlainText((String)IntegrationUtils.getLines((IDocument)document, 0, 1).trim()));
            String description = IntegrationUtils.getLines((IDocument)document, 0, 5);
            if (content.length() > description.length()) {
                description = String.valueOf(description) + "\n...";
            }
            workItem.setHTMLDescription(XMLString.createFromPlainText((String)description));
            IWorkItemUIWorkingCopy uiCopy = (IWorkItemUIWorkingCopy)workingCopy.getAdapter(IWorkItemUIWorkingCopy.class);
            uiCopy.getNewComment().set(content);
        }
        catch (BadLocationException x) {
            throw new RuntimeException(x);
        }
    }

    protected IWorkbenchPart getPart() {
        return this.fPart;
    }

    public void init(IViewPart view) {
        this.fPart = view;
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.fPart = targetPart;
    }

    public void run(IAction action) {
        ISelectionProvider selectionProvider = this.fPart.getSite().getSelectionProvider();
        if (selectionProvider != null) {
            this.selectionChanged(action, selectionProvider.getSelection());
        }
        InitializeWorkItemOperation operation = new InitializeWorkItemOperation(Messages.CreateWorkItemAction_CREATING_WORKITEM, this.fPart){

            protected void execute(WorkItemWorkingCopy workingCopy, IProgressMonitor monitor) throws TeamRepositoryException {
                CreateWorkItemAction.this.initializeWorkItem(workingCopy, CreateWorkItemAction.this.fSelection, monitor);
            }
        };
        WorkItemUI.createWorkItem((Shell)this.fPart.getSite().getShell(), null, (WorkItemOperation)operation);
    }

    public void selectionChanged(IAction action, ISelection selection) {
        ISelectionProvider selectionProvider = this.fPart != null ? this.fPart.getSite().getSelectionProvider() : null;
        this.fSelection = selectionProvider != null ? selectionProvider.getSelection() : selection;
        this.updateEnablement(action, this.fSelection);
    }
}

