/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.history;

import com.ibm.team.process.common.IIterationHandle;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.model.ItemHandle;
import com.ibm.team.workitem.ide.ui.internal.WorkItemIDEUIPlugin;
import com.ibm.team.workitem.ide.ui.internal.history.IntervalSelectionHistory;
import com.ibm.team.workitem.ide.ui.internal.models.IntervalHistory;
import com.ibm.team.workitem.ide.ui.internal.models.IntervalHistoryEntry;
import com.ibm.team.workitem.ide.ui.internal.models.ModelsFactory;
import com.ibm.team.workitem.ide.ui.internal.models.WorkItemIDEUIModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class IntervalSelectionHistoryManager {
    private static Map<String, Map<UUID, IntervalSelectionHistory>> fgRepositoryToHashMap = new HashMap<String, Map<UUID, IntervalSelectionHistory>>();
    private static boolean initialized = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IntervalSelectionHistory getHistory(IProjectAreaHandle projectArea) {
        Map<String, Map<UUID, IntervalSelectionHistory>> map = fgRepositoryToHashMap;
        synchronized (map) {
            IntervalSelectionHistory history;
            if (!initialized) {
                IntervalSelectionHistoryManager.readCompleteHistory();
                initialized = true;
            }
            if (projectArea == null) {
                return new IntervalSelectionHistory();
            }
            String repository = ((ITeamRepository)projectArea.getOrigin()).getRepositoryURI();
            Map<UUID, IntervalSelectionHistory> projectToHistory = fgRepositoryToHashMap.get(repository);
            if (projectToHistory == null) {
                projectToHistory = new HashMap<UUID, IntervalSelectionHistory>();
                history = new IntervalSelectionHistory();
                projectToHistory.put(projectArea.getItemId(), history);
                fgRepositoryToHashMap.put(repository, projectToHistory);
            } else {
                history = projectToHistory.get(projectArea.getItemId());
                if (history == null) {
                    history = new IntervalSelectionHistory();
                    projectToHistory.put(projectArea.getItemId(), history);
                }
            }
            IntervalSelectionHistoryManager.patchHistory(history, (ITeamRepository)projectArea.getOrigin());
            return history;
        }
    }

    private static void patchHistory(IntervalSelectionHistory history, ITeamRepository repository) {
        for (IItemHandle handle : history.fHistory) {
            if (handle.getOrigin() != null) continue;
            ((ItemHandle)handle).setOrigin((Object)repository);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeHistories() {
        Map<String, Map<UUID, IntervalSelectionHistory>> map = fgRepositoryToHashMap;
        synchronized (map) {
            WorkItemIDEUIModel wim;
            IntervalHistory hist;
            if (!initialized) {
                IntervalSelectionHistoryManager.readCompleteHistory();
                initialized = true;
            }
            if ((hist = (wim = WorkItemIDEUIPlugin.getDefault().getModel()).getIntervalHistory()) == null) {
                ModelsFactory factory = ModelsFactory.eINSTANCE;
                hist = factory.createIntervalHistory();
                wim.setIntervalHistory(hist);
            }
            List internalContents = hist.getInternalContents();
            internalContents.clear();
            for (Map.Entry<String, Map<UUID, IntervalSelectionHistory>> repo : fgRepositoryToHashMap.entrySet()) {
                for (Map.Entry<UUID, IntervalSelectionHistory> history : repo.getValue().entrySet()) {
                    List<IItemHandle> handles;
                    if (history.getValue().hasUnresolvedEntries()) {
                        handles = history.getValue().getRawValues();
                    } else {
                        IItem[] intervals = history.getValue().getHistory();
                        handles = new ArrayList<IItemHandle>();
                        IItem[] iItemArray = intervals;
                        int n = intervals.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IItem intv = iItemArray[n2];
                            handles.add((IItemHandle)((IIterationHandle)intv.getItemHandle()));
                            ++n2;
                        }
                    }
                    for (IItemHandle handle : handles) {
                        if (!(handle instanceof IIterationHandle)) continue;
                        ModelsFactory factory = ModelsFactory.eINSTANCE;
                        IntervalHistoryEntry entry = null;
                        entry = factory.createIntervalHistoryEntry();
                        entry.setRepository(repo.getKey());
                        entry.setProjectArea((IProjectAreaHandle)IProjectArea.ITEM_TYPE.createItemHandle(history.getKey(), null));
                        entry.setInterval((IIterationHandle)handle);
                        internalContents.add(entry);
                    }
                }
            }
        }
    }

    private static void readCompleteHistory() {
        WorkItemIDEUIModel wim = WorkItemIDEUIPlugin.getDefault().getModel();
        IntervalHistory hist = wim.getIntervalHistory();
        if (hist == null) {
            ModelsFactory factory = ModelsFactory.eINSTANCE;
            hist = factory.createIntervalHistory();
            wim.setIntervalHistory(hist);
            return;
        }
        for (Object element : hist.getInternalContents()) {
            IntervalSelectionHistory history;
            IntervalHistoryEntry entry = (IntervalHistoryEntry)element;
            String repo = entry.getRepository();
            IProjectAreaHandle project = entry.getProjectArea();
            IIterationHandle iteration = entry.getInterval();
            if (repo == null || project == null || iteration == null) continue;
            Map<UUID, IntervalSelectionHistory> projectMap = fgRepositoryToHashMap.get(repo);
            if (projectMap == null) {
                projectMap = new HashMap<UUID, IntervalSelectionHistory>();
                fgRepositoryToHashMap.put(repo, projectMap);
            }
            if ((history = projectMap.get(project.getItemId())) == null) {
                history = new IntervalSelectionHistory();
                projectMap.put(project.getItemId(), history);
            }
            history.addLast((IItemHandle)((IIterationHandle)iteration.getItemType().createItemHandle(iteration.getItemId(), null)));
        }
    }
}

