/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.history;

import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.workitem.client.IAuditableClient;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.internal.util.CategoriesHelper;
import com.ibm.team.workitem.common.model.ICategory;
import com.ibm.team.workitem.common.model.ICategoryHandle;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.ItemProfile;
import com.ibm.team.workitem.ide.ui.internal.WorkItemIDEUIPlugin;
import com.ibm.team.workitem.ide.ui.internal.history.ItemSelectionHistory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

public class CategorySelectionHistory
extends ItemSelectionHistory {
    public static final String CATEGORY_SELECTION_HISTORY_SIZE = "com.ibm.team.workitem.ide.ui.CategorySelectionHistory.size";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resolveHistory(IWorkItem workItem, IProgressMonitor monitor) throws TeamRepositoryException {
        LinkedList element2;
        ArrayList copy;
        IProjectAreaHandle projectArea = workItem.getProjectArea();
        if (projectArea == null) {
            return;
        }
        ITeamRepository teamRepository = (ITeamRepository)projectArea.getOrigin();
        this.setResolving(true);
        LinkedList linkedList = this.fHistory;
        synchronized (linkedList) {
            copy = new ArrayList(this.fHistory);
        }
        HashMap<UUID, ICategory> categories = new HashMap<UUID, ICategory>();
        for (LinkedList element2 : copy) {
            if (!(element2 instanceof ICategoryHandle) || element2 instanceof ICategory) continue;
            try {
                ICategory category = (ICategory)teamRepository.itemManager().fetchCompleteItem((IItemHandle)element2, 0, monitor);
                categories.put(category.getItemId(), category);
            }
            catch (ItemNotFoundException itemNotFoundException) {}
        }
        element2 = this.fHistory;
        synchronized (element2) {
            int i = 0;
            while (i < this.fHistory.size()) {
                IItemHandle element3 = (IItemHandle)this.fHistory.get(i);
                if (!(element3 instanceof ICategory) || ((ICategory)element3).isArchived()) {
                    this.fHistory.remove(i);
                    ICategory category = (ICategory)categories.get(element3.getItemId());
                    if (category != null) {
                        if (this.historyContains((IItemHandle)category)) {
                            --i;
                        } else {
                            this.fHistory.add(i, category);
                        }
                    }
                }
                ++i;
            }
        }
        this.setResolving(false);
        if (this.getCurrentSize() < this.getMaxSize()) {
            LinkedList linkedList2;
            IAuditableClient auditableClient = (IAuditableClient)teamRepository.getClientLibrary(IAuditableClient.class);
            List valueSet = CategoriesHelper.findVisibleCategories((IAuditableCommon)auditableClient, (IProjectAreaHandle)projectArea, (IContributorHandle)auditableClient.getUser(), (ItemProfile)ICategory.DEFAULT_PROFILE, (IProgressMonitor)monitor);
            Collections.sort(valueSet, new Comparator<ICategory>(){

                @Override
                public int compare(ICategory o1, ICategory o2) {
                    return o1.getCategoryId().compareTo(o2.getCategoryId());
                }
            });
            for (ICategory cat : valueSet) {
                if (cat.getDepth() >= 1) continue;
                linkedList2 = this.fHistory;
                synchronized (linkedList2) {
                    if (this.getCurrentSize() >= this.getMaxSize()) {
                        break;
                    }
                    this.addLast((IItemHandle)cat);
                }
            }
            if (this.getCurrentSize() < this.getMaxSize()) {
                for (ICategory cat : valueSet) {
                    if (cat.getDepth() != 1) continue;
                    linkedList2 = this.fHistory;
                    synchronized (linkedList2) {
                        if (this.getCurrentSize() >= this.getMaxSize()) {
                            break;
                        }
                        this.addLast((IItemHandle)cat);
                    }
                }
                if (this.getCurrentSize() < this.getMaxSize()) {
                    for (ICategory cat : valueSet) {
                        if (cat.getDepth() != 2) continue;
                        linkedList2 = this.fHistory;
                        synchronized (linkedList2) {
                            if (this.getCurrentSize() >= this.getMaxSize()) {
                                break;
                            }
                            this.addLast((IItemHandle)cat);
                        }
                    }
                }
            }
        }
    }

    protected boolean isNullItem(IItem item) {
        return item == null || item.isPropertySet(ICategory.CATEGORY_ID) && ((ICategory)item).isUnassigned();
    }

    protected int getSize() {
        return WorkItemIDEUIPlugin.getDefault().getPreferenceStore().getInt(CATEGORY_SELECTION_HISTORY_SIZE);
    }

    protected void setSize(int size) {
        WorkItemIDEUIPlugin.getDefault().getPreferenceStore().setValue(CATEGORY_SELECTION_HISTORY_SIZE, size);
    }
}

