/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.editor.templates;

import com.ibm.team.foundation.ide.ui.internal.FoundationIDEUIPlugin;
import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.contentassist.AbstractContentAssistProposalComputer;
import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.contentassist.AdditionalInformationControl;
import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.contentassist.AdditionalInformationInput;
import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.contentassist.ContentAssistContext;
import com.ibm.team.workitem.ide.ui.internal.ImagePool;
import com.ibm.team.workitem.ide.ui.internal.WorkItemIDEUIPlugin;
import com.ibm.team.workitem.ide.ui.internal.editor.templates.HierarchicalContextType;
import com.ibm.team.workitem.ide.ui.internal.editor.templates.WorkItemTemplateManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.AbstractReusableInformationControlCreator;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension5;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateCompletionProcessor;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.jface.text.templates.TemplateProposal;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateProposalComputer
extends AbstractContentAssistProposalComputer {
    private final WorkItemTemplateComputer fDelegate;

    public TemplateProposalComputer(String contextTypeId) {
        this.fDelegate = new WorkItemTemplateComputer(WorkItemTemplateManager.getDefault().getContextType(contextTypeId));
    }

    public List<ICompletionProposal> computeCompletionProposals(ContentAssistContext context) {
        ICompletionProposal[] proposals = this.fDelegate.computeCompletionProposals(context.getTextViewer(), context.getOffset());
        return this.filter(context, Arrays.asList(proposals));
    }

    private static class TemplateProposalExtension
    extends TemplateProposal
    implements ICompletionProposalExtension5 {
        public TemplateProposalExtension(Template template, TemplateContext context, IRegion region, Image image, int relevance) {
            super(template, context, region, image, relevance);
        }

        public IInformationControlCreator getInformationControlCreator() {
            return new AbstractReusableInformationControlCreator(){

                protected IInformationControl doCreateInformationControl(Shell parent) {
                    return new AdditionalInformationControl(parent, false);
                }
            };
        }

        public Object getAdditionalProposalInfo(IProgressMonitor monitor) {
            String text = this.getAdditionalProposalInfo();
            return new AdditionalInformationInput(text, text);
        }

        public boolean isValidFor(IDocument document, int offset) {
            try {
                String prefix = TemplateProposalExtension.getPrefix(document, offset);
                return this.getDisplayString().toLowerCase().startsWith(prefix.toLowerCase());
            }
            catch (BadLocationException e) {
                FoundationIDEUIPlugin.getDefault().log(e.getMessage(), (Throwable)e);
                return false;
            }
        }

        private static String getPrefix(IDocument doc, int offset) throws BadLocationException {
            if (doc == null || offset > doc.getLength()) {
                return null;
            }
            int length = 0;
            while (--offset >= 0 && !Character.isWhitespace(doc.getChar(offset))) {
                ++length;
            }
            return doc.get(offset + 1, length);
        }
    }

    private static class WorkItemTemplateComputer
    extends TemplateCompletionProcessor {
        private final TemplateContextType fContextType;

        public WorkItemTemplateComputer(TemplateContextType contextType) {
            this.fContextType = contextType;
        }

        protected TemplateContextType getContextType(ITextViewer viewer, IRegion region) {
            return this.fContextType;
        }

        protected Image getImage(Template template) {
            return WorkItemIDEUIPlugin.getImage(ImagePool.TEXT_TEMPLATE);
        }

        protected Template[] getTemplates(String contextTypeId) {
            WorkItemTemplateManager workItemManager = WorkItemTemplateManager.getDefault();
            if (this.fContextType instanceof HierarchicalContextType) {
                ArrayList<Template> result = new ArrayList<Template>();
                TemplateContextType current = this.fContextType;
                do {
                    Template[] templates = workItemManager.getTemplates(current.getId());
                    result.addAll(Arrays.asList(templates));
                } while ((current = this.getSuperContext(current)) != null);
                return result.toArray(new Template[result.size()]);
            }
            return workItemManager.getTemplates(this.fContextType.getId());
        }

        public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
            String prefix;
            Region region;
            TemplateContext context;
            ITextSelection selection = (ITextSelection)viewer.getSelectionProvider().getSelection();
            if (selection.getOffset() == offset) {
                offset = selection.getOffset() + selection.getLength();
            }
            if ((context = this.createContext(viewer, (IRegion)(region = new Region(offset - (prefix = this.extractPrefix(viewer, offset)).length(), prefix.length())))) == null) {
                return new ICompletionProposal[0];
            }
            context.setVariable("selection", selection.getText());
            Template[] templates = this.getTemplates(context.getContextType().getId());
            ArrayList<TemplateProposal> matches = new ArrayList<TemplateProposal>();
            int i = 0;
            while (i < templates.length) {
                block7: {
                    Template template = templates[i];
                    try {
                        context.getContextType().validate(template.getPattern());
                    }
                    catch (TemplateException templateException) {
                        break block7;
                    }
                    TemplateContextType current = this.fContextType;
                    do {
                        if (template.matches(prefix, current.getId())) {
                            matches.add((TemplateProposal)this.createProposal(template, context, (IRegion)region, this.getRelevance(template, prefix)));
                            current = null;
                            continue;
                        }
                        current = this.getSuperContext(current);
                    } while (current != null);
                }
                ++i;
            }
            Collections.sort(matches, new ProposalComparator());
            return matches.toArray(new ICompletionProposal[matches.size()]);
        }

        protected ICompletionProposal createProposal(Template template, TemplateContext context, IRegion region, int relevance) {
            return new TemplateProposalExtension(template, context, region, this.getImage(template), relevance);
        }

        private TemplateContextType getSuperContext(TemplateContextType current) {
            if (!(current instanceof HierarchicalContextType)) {
                return null;
            }
            String superContextId = ((HierarchicalContextType)current).getSuperContextId();
            if (superContextId == null) {
                return null;
            }
            return WorkItemTemplateManager.getDefault().getContextType(superContextId);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static final class ProposalComparator
        implements Comparator<TemplateProposal> {
            private ProposalComparator() {
            }

            @Override
            public int compare(TemplateProposal o1, TemplateProposal o2) {
                return o2.getRelevance() - o1.getRelevance();
            }
        }
    }
}

