/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.editor.quickinformation;

import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.common.internal.presentations.QuickInformationConfigurationManager;
import com.ibm.team.workitem.ide.ui.internal.WorkItemIDEUIPlugin;
import com.ibm.team.workitem.ide.ui.internal.editor.quickinformation.AbstractQuickInformationEntry;
import com.ibm.team.workitem.ide.ui.internal.editor.quickinformation.Messages;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuickInformationManager {
    private static Map<String, IConfigurationElement> fgQuickInformationEntries;
    private static Map<String, String> fgDisplayNames;
    private static final String PRESENTATION_POINT = "com.ibm.team.workitem.ide.ui.quickinformationPresentation";
    private static final String ELEMENT_NAME = "quickinformationPresentation";
    private static final String CLASS_ATTRIBUTE = "class";
    private static final String KIND_ATTRIBUTE = "kind";
    private static final String NAME_ATTRIBUTE = "displayName";

    public static AbstractQuickInformationEntry getPresentation(String entryTypeId) {
        IConfigurationElement element;
        if (fgQuickInformationEntries == null) {
            QuickInformationManager.initializeEntries();
        }
        if ((element = fgQuickInformationEntries.get(entryTypeId)) != null) {
            Object o;
            try {
                o = element.createExecutableExtension(CLASS_ATTRIBUTE);
            }
            catch (CoreException e) {
                WorkItemIDEUIPlugin.getDefault().log(NLS.bind((String)Messages.QuickInformationManager_COULD_NOT_INITIALIZE_QUICKINFORMATION, (Object)entryTypeId, (Object[])new Object[]{element.getAttribute(CLASS_ATTRIBUTE)}), e);
                return null;
            }
            if (!(o instanceof AbstractQuickInformationEntry)) {
                WorkItemIDEUIPlugin.getDefault().log((IStatus)new Status(4, "com.ibm.team.workitem.ide.ui", NLS.bind((String)Messages.QuickInformationManager_QUICKINFORMATION_INHERITANCE_ERROR, (Object)entryTypeId, (Object[])new Object[]{element.getAttribute(CLASS_ATTRIBUTE)})));
                return null;
            }
            return (AbstractQuickInformationEntry)o;
        }
        return null;
    }

    public static Set<String> getQuickInformationEntries() {
        if (fgQuickInformationEntries == null) {
            QuickInformationManager.initializeEntries();
        }
        return fgQuickInformationEntries.keySet();
    }

    public static String getDisplayName(String kind) {
        if (fgDisplayNames == null) {
            QuickInformationManager.initializeEntries();
        }
        if (kind.equals("Hidden")) {
            return QuickInformationConfigurationManager.QuickInformationConfigurationEntry.HIDDEN_DISPLAY_NAME;
        }
        return fgDisplayNames.get(kind);
    }

    private static void initializeEntries() {
        fgQuickInformationEntries = new HashMap<String, IConfigurationElement>();
        fgDisplayNames = new HashMap<String, String>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] elements = registry.getConfigurationElementsFor(PRESENTATION_POINT);
        int i = 0;
        while (i < elements.length) {
            String kind;
            IConfigurationElement element = elements[i];
            if (ELEMENT_NAME.equals(element.getName()) && (kind = element.getAttribute(KIND_ATTRIBUTE)) != null) {
                fgQuickInformationEntries.put(kind, element);
                String name = element.getAttribute(NAME_ATTRIBUTE);
                if (name == null) {
                    name = kind;
                }
                fgDisplayNames.put(kind, name);
            }
            ++i;
        }
    }
}

