/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.editor.quickinformation;

import com.ibm.team.foundation.common.URIReference;
import com.ibm.team.foundation.common.text.XMLString;
import com.ibm.team.foundation.rcp.core.hyperlinks.Hyperlinks;
import com.ibm.team.fulltext.client.IFullTextClientLibrary;
import com.ibm.team.fulltext.common.model.IScoredResult;
import com.ibm.team.jface.OverlayIcon;
import com.ibm.team.jface.tooltip.TooltipSupport;
import com.ibm.team.jface.util.UIUpdaterJob;
import com.ibm.team.jface.viewerutilities.SelectionProvider;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.Location;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.client.IAuditableClient;
import com.ibm.team.workitem.client.IWorkItemListener;
import com.ibm.team.workitem.client.URIService;
import com.ibm.team.workitem.client.WorkItemChangeEvent;
import com.ibm.team.workitem.client.WorkItemWorkingCopy;
import com.ibm.team.workitem.client.WorkflowUtilities;
import com.ibm.team.workitem.client.internal.util.ClientUtils;
import com.ibm.team.workitem.common.model.IAttachment;
import com.ibm.team.workitem.common.model.IComment;
import com.ibm.team.workitem.common.model.IComments;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.common.model.ItemProfile;
import com.ibm.team.workitem.common.query.IResolvedResult;
import com.ibm.team.workitem.common.workflow.IWorkflowInfo;
import com.ibm.team.workitem.ide.ui.internal.ImagePool;
import com.ibm.team.workitem.ide.ui.internal.editor.LinkHelper;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemEditorToolkit;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemUIWorkingCopy;
import com.ibm.team.workitem.ide.ui.internal.editor.quickinformation.ItemizedQuickInformationEntry;
import com.ibm.team.workitem.ide.ui.internal.editor.quickinformation.Messages;
import com.ibm.team.workitem.ide.ui.internal.editor.quickinformation.WorkItemQuickInformationEntry;
import com.ibm.team.workitem.rcp.ui.IWorkItemUIWorkingCopy;
import com.ibm.team.workitem.rcp.ui.QueriesUI;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PotentialDuplicatesQuickinformationEntry
extends ItemizedQuickInformationEntry<IResolvedResult<IWorkItem>> {
    public static final String KIND_ID = "com.ibm.team.workitem.quickinformation.kind.potentialDuplicates";
    private static final String WORKITEM_TYPE = String.valueOf(IWorkItem.ITEM_TYPE.getNamespaceURI()) + "." + IWorkItem.ITEM_TYPE.getName();
    private static final String ATTACHMENT_TYPE = String.valueOf(IAttachment.ITEM_TYPE.getNamespaceURI()) + "." + IAttachment.ITEM_TYPE.getName();
    private RetrieveDuplicatesJob fJob;
    private List<IResolvedResult<IWorkItem>> fDuplicates = new ArrayList<IResolvedResult<IWorkItem>>();
    private int fQueryCount = -1;
    private HyperlinkAdapter fURILinks;
    private WorkItemListener fWorkItemListener = new WorkItemListener();
    private HyperlinkAdapter fTitleLink;
    private boolean fLoading = false;
    private Label fImageLabel;
    private ItemProfile<IWorkItem> fSmallProfile = ItemProfile.createProfile((IItemType)IWorkItem.ITEM_TYPE, (String[])new String[]{IWorkItem.ID_PROPERTY, IWorkItem.TYPE_PROPERTY, IWorkItem.SUMMARY_PROPERTY, IWorkItem.STATE_PROPERTY, IWorkItem.PROJECT_AREA_PROPERTY});

    @Override
    public void init() {
        this.fURILinks = new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                if (e.getHref() instanceof URI) {
                    Hyperlinks.openHyperlink((URI)((URI)e.getHref()));
                }
            }
        };
        this.fTitleLink = new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                if (PotentialDuplicatesQuickinformationEntry.this.getWorkingCopy() != null) {
                    QueriesUI.showRelatedWorkItems((IWorkbenchWindow)PotentialDuplicatesQuickinformationEntry.this.getQuickInformationPart().getSite().getWorkbenchPage().getWorkbenchWindow(), (WorkItemWorkingCopy)PotentialDuplicatesQuickinformationEntry.this.getWorkingCopy());
                }
            }
        };
        if (this.fJob == null) {
            this.fJob = new RetrieveDuplicatesJob(Messages.PotentialDuplicatesQuickinformationEntry_SEARCHING_DUPLICATES);
        }
        if (this.getQuickInformationPart().getUIListener() != null) {
            this.getQuickInformationPart().getUIListener().addListener((IWorkItemListener)this.fWorkItemListener, IWorkItem.SUMMARY_PROPERTY);
            this.getQuickInformationPart().getUIListener().addListener((IWorkItemListener)this.fWorkItemListener, IWorkItem.DESCRIPTION_PROPERTY);
            this.getQuickInformationPart().getUIListener().addListener((IWorkItemListener)this.fWorkItemListener, IWorkItem.COMMENTS_PROPERTY);
        }
        this.scheduleJob(150);
    }

    @Override
    public boolean canShow() {
        return this.getWorkingCopy().getWorkItem().isNewItem() || !PotentialDuplicatesQuickinformationEntry.isStateClosed(this.getWorkingCopy().getWorkItem());
    }

    @Override
    public boolean showNumberOfItems() {
        return false;
    }

    @Override
    public void adaptElementLink(Hyperlink link, IResolvedResult<IWorkItem> element) {
        this.adaptItemHyperlink(link, (IWorkItem)element.getItem());
        new ItemizedQuickInformationEntry.ItemDragSupport((Control)link, (IItemHandle)element.getItem());
    }

    @Override
    public void adaptLDotsLink(Hyperlink link) {
        this.getQuickInformationPart().getLinkGroup().add(link);
        IHyperlinkListener hyperlinkListener = this.getQuickInformationPart().getPartActivator(this.getConfigurationEntry().getProperty("linkTarget"));
        if (hyperlinkListener != null) {
            link.addHyperlinkListener(hyperlinkListener);
        }
        List<IResolvedResult<IWorkItem>> elements = this.getElements();
        ArrayList<IWorkItem> workItems = new ArrayList<IWorkItem>(elements.size());
        for (IResolvedResult<IWorkItem> wi : elements) {
            workItems.add((IWorkItem)wi.getItem());
        }
        new WorkItemQuickInformationEntry.WorkItemToolTipSupport((Control)link, this.getTitle(), workItems.size(), workItems){

            protected WorkItemWorkingCopy getWorkingCopy() {
                return PotentialDuplicatesQuickinformationEntry.this.getWorkingCopy();
            }
        };
    }

    @Override
    public void adaptTitleLink(Hyperlink titleLink, Label imageLabel) {
        this.getQuickInformationPart().getLinkGroup().add(titleLink);
        titleLink.addHyperlinkListener((IHyperlinkListener)this.fTitleLink);
        List<IResolvedResult<IWorkItem>> elements = this.getElements();
        ArrayList<IWorkItem> workItems = new ArrayList<IWorkItem>(elements.size());
        for (IResolvedResult<IWorkItem> wi : elements) {
            workItems.add((IWorkItem)wi.getItem());
        }
        new WorkItemQuickInformationEntry.WorkItemToolTipSupport((Control)titleLink, this.getTitle(), workItems.size(), workItems){

            protected WorkItemWorkingCopy getWorkingCopy() {
                return PotentialDuplicatesQuickinformationEntry.this.getWorkingCopy();
            }
        };
        new WorkItemQuickInformationEntry.WorkItemToolTipSupport((Control)imageLabel, this.getTitle(), workItems.size(), workItems){

            protected WorkItemWorkingCopy getWorkingCopy() {
                return PotentialDuplicatesQuickinformationEntry.this.getWorkingCopy();
            }
        };
        this.createItemContextMenu((Control)titleLink);
        this.createItemContextMenu((Control)imageLabel);
    }

    private void createItemContextMenu(Control control) {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        SelectionProvider selectionProvider = new SelectionProvider(){

            public ISelection getSelection() {
                return StructuredSelection.EMPTY;
            }
        };
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                Action action = new Action(Messages.PotentialDuplicatesQuickinformationEntry_REFRESH){

                    public void run() {
                        if (PotentialDuplicatesQuickinformationEntry.this.fJob != null) {
                            PotentialDuplicatesQuickinformationEntry.this.scheduleJob(0);
                        }
                    }
                };
                action.setImageDescriptor(ImagePool.REFRESH);
                manager.add((IAction)action);
            }
        });
        this.getQuickInformationPart().getSite().registerContextMenu(this.getQuickInformationPart().getId(), menuMgr, (ISelectionProvider)selectionProvider);
        Menu menu = menuMgr.createContextMenu(control);
        control.setMenu(menu);
    }

    @Override
    public List<IResolvedResult<IWorkItem>> getElements() {
        if (this.fDuplicates.isEmpty()) {
            return new ArrayList<IResolvedResult<IWorkItem>>();
        }
        return new ArrayList<IResolvedResult<IWorkItem>>(this.fDuplicates);
    }

    @Override
    public void createContent(Composite parent) {
        WorkItemEditorToolkit toolkit = (WorkItemEditorToolkit)this.getQuickInformationPart().getSite().getToolkit();
        this.fImageLabel = toolkit.createLabel(parent, null);
        this.setAppropriateImage();
        this.fImageLabel.setBackground(null);
        Composite links = toolkit.createComposite(parent);
        links.setBackground(null);
        RowLayout rl = new RowLayout();
        rl.marginLeft = 0;
        rl.marginRight = 0;
        rl.marginTop = 0;
        rl.marginBottom = 0;
        rl.spacing = 0;
        rl.center = true;
        links.setLayout((Layout)rl);
        if (this.getElements().size() == 0) {
            Hyperlink link = toolkit.createCustomHyperlink(links, NLS.bind((String)Messages.PotentialDuplicatesQuickinformationEntry_LINKS_NONE, (Object)this.getTitle(), (Object[])new Object[0]), 0);
            this.adaptTitleLink(link, this.fImageLabel);
            String text = Messages.PotentialDuplicatesQuickinformationEntry_BLANK_NONE;
            Label label = toolkit.createLabel(links, text);
            label.setBackground(null);
        } else {
            GC gc = new GC((Drawable)parent);
            gc.setFont(parent.getFont());
            int availableSpace = parent.getBounds().width - 12;
            availableSpace = availableSpace - this.fImageLabel.computeSize((int)-1, (int)-1).x - 5;
            String nOfItems = "";
            if (this.fQueryCount != -1) {
                nOfItems = NLS.bind((String)" ({0})", (Object)this.fQueryCount, (Object[])new Object[0]);
            }
            Hyperlink link = toolkit.createCustomHyperlink(links, NLS.bind((String)Messages.PotentialDuplicatesQuickinformationEntry_LINKS_PRESENT, (Object)this.getTitle(), (Object[])new Object[]{nOfItems}), 0);
            this.adaptTitleLink(link, this.fImageLabel);
            boolean first = true;
            availableSpace -= link.computeSize((int)-1, (int)-1).x;
            int displayableArtifacts = 0;
            ArrayList<IResolvedResult<IWorkItem>> elements = new ArrayList<IResolvedResult<IWorkItem>>(this.getElements());
            for (IResolvedResult iResolvedResult : elements) {
                Label l;
                if (displayableArtifacts == 5) break;
                String linkText = this.getShortIdentifier((IResolvedResult<IWorkItem>)iResolvedResult);
                if (linkText == null || linkText.length() == 0) continue;
                if (availableSpace - gc.stringExtent((String)linkText).x - gc.stringExtent((String)" ").x - 2 < 0) {
                    l = toolkit.createLabel(links, " ");
                    l.setBackground(null);
                    break;
                }
                ++displayableArtifacts;
                if (first) {
                    first = false;
                    l = toolkit.createLabel(links, " ");
                    l.setBackground(null);
                    availableSpace -= l.computeSize((int)-1, (int)-1).x;
                } else {
                    l = toolkit.createLabel(links, ", ");
                    l.setBackground(null);
                    availableSpace -= l.computeSize((int)-1, (int)-1).x;
                }
                Hyperlink elementLink = toolkit.createCustomHyperlink(links, linkText, 0);
                this.adaptElementLink(elementLink, (IResolvedResult<IWorkItem>)iResolvedResult);
                this.getQuickInformationPart().addInvalidDropTarget((Control)elementLink);
                availableSpace -= elementLink.computeSize((int)-1, (int)-1).x;
            }
            gc.dispose();
            if (displayableArtifacts == 0 && link.getText().lastIndexOf(58) > 0) {
                link.setText(link.getText().substring(0, link.getText().lastIndexOf(58)));
            }
        }
    }

    @Override
    public Image getImage() {
        return null;
    }

    @Override
    public String getShortIdentifier(IResolvedResult<IWorkItem> element) {
        return NLS.bind((String)Messages.PotentialDuplicatesQuickinformationEntry_ID_SCORE, (Object)((IWorkItem)element.getItem()).getId(), (Object[])new Object[]{(int)(element.getScore() * 100.0)});
    }

    private void adaptItemHyperlink(Hyperlink link, final IWorkItem item) {
        if (!item.isNewItem() && PotentialDuplicatesQuickinformationEntry.isStateClosed(item)) {
            this.getQuickInformationPart().getClosedGroup().add(link);
        } else {
            this.getQuickInformationPart().getLinkGroup().add(link);
        }
        final URI uri = URIService.createAuditableURI((ITeamRepository)this.getWorkingCopy().getTeamRepository(), (IItemHandle)item);
        link.setHref((Object)uri);
        link.addHyperlinkListener((IHyperlinkListener)this.fURILinks);
        new TooltipSupport((Control)link, true, true){

            protected Object mapElement(int x, int y) {
                return item;
            }

            protected void openRequested(Object element) {
                Hyperlinks.openHyperlink((URI)uri);
            }
        };
        SelectionProvider selectionProvider = new SelectionProvider(){

            public ISelection getSelection() {
                return item == null ? StructuredSelection.EMPTY : new StructuredSelection((Object)item);
            }
        };
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                LinkHelper.addSelectionActions(PotentialDuplicatesQuickinformationEntry.this.getQuickInformationPart().getSite().getWorkbenchPage(), manager, new LinkHelper.InputSelectionProvider(PotentialDuplicatesQuickinformationEntry.this.getWorkingCopy(), (ISelection)new StructuredSelection((Object)item)));
            }
        });
        this.getQuickInformationPart().getSite().registerContextMenu(this.getQuickInformationPart().getId(), menuMgr, (ISelectionProvider)selectionProvider);
        Menu menu = menuMgr.createContextMenu((Control)link);
        link.setMenu(menu);
    }

    private static boolean isStateClosed(IWorkItem workitem) {
        IWorkflowInfo workflowInfo;
        if (workitem.isPropertySet(IWorkItem.TYPE_PROPERTY) && workitem.isPropertySet(IWorkItem.PROJECT_AREA_PROPERTY) && (workflowInfo = WorkflowUtilities.findCachedWorkflowInfo((IWorkItem)workitem)) != null) {
            return workflowInfo.getStateGroup(workitem.getState2()) == 2;
        }
        return false;
    }

    private void scheduleJob(int millis) {
        Assert.isNotNull((Object)Display.getCurrent());
        if (this.fJob != null) {
            this.setLoadingState(true);
            this.fJob.schedule(millis);
        }
    }

    private void setLoadingState(boolean loading) {
        boolean load = this.fLoading;
        this.fLoading = loading;
        if (load != loading) {
            this.setAppropriateImage();
        }
    }

    private void setAppropriateImage() {
        Assert.isNotNull((Object)Display.getCurrent());
        if (this.fImageLabel != null && !this.fImageLabel.isDisposed()) {
            ImageDescriptor desc;
            if (this.fLoading) {
                ImageDescriptor overlay = ImagePool.REFRESH_OVR;
                ImageDescriptor[] imageDescriptorArray = new ImageDescriptor[2];
                imageDescriptorArray[1] = overlay;
                desc = new OverlayIcon(ImagePool.FIND_DUPLICATES_ENABLED, imageDescriptorArray, 131200);
            } else {
                desc = ImagePool.FIND_DUPLICATES_ENABLED;
            }
            this.fImageLabel.setImage(this.getQuickInformationPart().getResourceManager().createImage(desc));
        }
    }

    @Override
    public String getTitle() {
        if (this.getConfigurationEntry().getTitle() != null) {
            return this.getConfigurationEntry().getTitle();
        }
        return Messages.PotentialDuplicatesQuickinformationEntry_POTENTIAL_DUPLICATES;
    }

    @Override
    public void dispose() {
        if (this.getQuickInformationPart().getUIListener() != null) {
            this.getQuickInformationPart().getUIListener().removeListener((IWorkItemListener)this.fWorkItemListener, IWorkItem.SUMMARY_PROPERTY);
            this.getQuickInformationPart().getUIListener().removeListener((IWorkItemListener)this.fWorkItemListener, IWorkItem.DESCRIPTION_PROPERTY);
            this.getQuickInformationPart().getUIListener().removeListener((IWorkItemListener)this.fWorkItemListener, IWorkItem.COMMENTS_PROPERTY);
        }
        if (this.fJob != null) {
            this.fJob.cancel();
            this.fJob = null;
        }
    }

    private IResolvedResult<IWorkItem> toResolvedResult(IAuditableClient client, IScoredResult result, IProgressMonitor monitor) throws TeamRepositoryException {
        IWorkItem item = null;
        double score = 0.0;
        URIReference reference = result.getResult();
        IItemHandle itemHandle = Location.location((URI)reference.getURI()).getItemHandle();
        if (itemHandle instanceof IWorkItemHandle) {
            item = (IWorkItem)client.resolveAuditable((IAuditableHandle)((IWorkItemHandle)itemHandle), this.fSmallProfile, monitor);
        }
        score = (double)result.getScore() / 100000.0;
        if (item != null) {
            return new ResolvedResult<IWorkItem>(item, score);
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ResolvedResult<T>
    implements IResolvedResult<T> {
        private final T fItem;
        private final double fScore;

        public ResolvedResult(T item, double score) {
            this.fItem = item;
            this.fScore = score;
        }

        public T getItem() {
            return this.fItem;
        }

        public double getScore() {
            return this.fScore;
        }
    }

    private class RetrieveDuplicatesJob
    extends UIUpdaterJob {
        public RetrieveDuplicatesJob(String name) {
            super(name);
        }

        public IStatus runInBackground(IProgressMonitor monitor) {
            try {
                ITeamRepository teamRepository = PotentialDuplicatesQuickinformationEntry.this.getWorkingCopy().getTeamRepository();
                IFullTextClientLibrary lib = (IFullTextClientLibrary)teamRepository.getClientLibrary(IFullTextClientLibrary.class);
                String[] searchScope = new String[]{WORKITEM_TYPE, ATTACHMENT_TYPE};
                IWorkItem workItem = PotentialDuplicatesQuickinformationEntry.this.getWorkingCopy().getWorkItem();
                IProjectAreaHandle projectArea = workItem.getProjectArea();
                UUID[] context = null;
                if (projectArea != null) {
                    context = new UUID[]{projectArea.getItemId()};
                }
                boolean isDirty = PotentialDuplicatesQuickinformationEntry.this.getWorkingCopy().isDirty();
                IScoredResult[] results = null;
                if (isDirty) {
                    IComments comments;
                    IWorkItemUIWorkingCopy uiCopy = (IWorkItemUIWorkingCopy)PotentialDuplicatesQuickinformationEntry.this.getWorkingCopy().getAdapter(IWorkItemUIWorkingCopy.class);
                    ((WorkItemUIWorkingCopy)uiCopy).synchronizeDocumentChanges();
                    UUID itemId = workItem.getItemId();
                    StringBuilder summaryBuilder = new StringBuilder();
                    if (workItem.getHTMLSummary() != null) {
                        summaryBuilder.append(workItem.getHTMLSummary().getPlainText());
                    }
                    StringBuilder contentBuilder = new StringBuilder();
                    if (workItem.getHTMLDescription() != null) {
                        contentBuilder.append(workItem.getHTMLDescription().getPlainText());
                    }
                    if ((comments = workItem.getComments()) != null) {
                        IComment[] contents;
                        IComment[] iCommentArray = contents = comments.getContents();
                        int n = contents.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IComment comment = iCommentArray[n2];
                            contentBuilder.append("\n").append(comment.getHTMLContent().getPlainText());
                            ++n2;
                        }
                    }
                    if (uiCopy.getNewComment().getLength() > 0) {
                        contentBuilder.append("\n").append(XMLString.createFromPlainText((String)uiCopy.getNewComment().get()).getPlainText());
                    }
                    String summary = summaryBuilder.toString();
                    String content = contentBuilder.toString();
                    if (itemId == null || workItem.isNewItem() || workItem.getId() == -1) {
                        results = lib.findDuplicate(summary, content, WORKITEM_TYPE, searchScope, context, monitor);
                    } else {
                        Location itemLocation = Location.itemLocation((IItemHandle)workItem, (String)teamRepository.getRepositoryURI());
                        URI uri = itemLocation.toRelativeUri();
                        URIReference reference = new URIReference(summary, summary, WORKITEM_TYPE, uri);
                        results = lib.findDuplicate(reference, summary, content, searchScope, context, monitor);
                    }
                } else if (!workItem.isNewItem() && workItem.getId() != -1) {
                    Location itemLocation = Location.itemLocation((IItemHandle)workItem, (String)teamRepository.getRepositoryURI());
                    URI uri = itemLocation.toRelativeUri();
                    URIReference reference = new URIReference(uri.toString(), uri.toString(), WORKITEM_TYPE, uri);
                    results = lib.findDuplicate(reference, null, null, searchScope, context, monitor);
                }
                IAuditableClient client = (IAuditableClient)ClientUtils.getClientLibrary((IItemHandle)PotentialDuplicatesQuickinformationEntry.this.getWorkingCopy().getWorkItem(), IAuditableClient.class);
                ArrayList<IResolvedResult> duplicates = new ArrayList<IResolvedResult>();
                if (results != null) {
                    IScoredResult[] iScoredResultArray = results;
                    int n = results.length;
                    int n3 = 0;
                    while (n3 < n) {
                        IScoredResult result = iScoredResultArray[n3];
                        IResolvedResult resolvedResult = PotentialDuplicatesQuickinformationEntry.this.toResolvedResult(client, result, monitor);
                        if (resolvedResult != null) {
                            duplicates.add(resolvedResult);
                        }
                        ++n3;
                    }
                }
                PotentialDuplicatesQuickinformationEntry.this.fQueryCount = duplicates.size();
                PotentialDuplicatesQuickinformationEntry.this.fDuplicates = duplicates;
            }
            catch (TeamRepositoryException teamRepositoryException) {
                PotentialDuplicatesQuickinformationEntry.this.fDuplicates.clear();
                PotentialDuplicatesQuickinformationEntry.this.fQueryCount = -1;
                return Status.CANCEL_STATUS;
            }
            return super.runInBackground(monitor);
        }

        public IStatus runInUI(IProgressMonitor monitor) {
            PotentialDuplicatesQuickinformationEntry.this.setLoadingState(false);
            PotentialDuplicatesQuickinformationEntry.this.getQuickInformationPart().updateItems(false);
            return super.runInUI(monitor);
        }
    }

    private class WorkItemListener
    implements IWorkItemListener {
        private WorkItemListener() {
        }

        public void workItemAttributeChanged(WorkItemChangeEvent event) {
            if (!event.affects((IWorkItemHandle)PotentialDuplicatesQuickinformationEntry.this.getWorkingCopy().getWorkItem()) || PotentialDuplicatesQuickinformationEntry.this.fJob == null) {
                return;
            }
            if (event.affects(IWorkItem.SUMMARY_PROPERTY) || event.affects(IWorkItem.DESCRIPTION_PROPERTY) || event.affects(IWorkItem.COMMENTS_PROPERTY)) {
                PotentialDuplicatesQuickinformationEntry.this.scheduleJob(300);
            }
        }

        public void workItemAttributeDependencyChanged(WorkItemChangeEvent event) {
        }
    }
}

