/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.editor.quickinformation;

import com.ibm.team.foundation.common.internal.util.Dates;
import com.ibm.team.foundation.common.text.XMLString;
import com.ibm.team.foundation.rcp.core.hyperlinks.Hyperlinks;
import com.ibm.team.foundation.rcp.ui.dnd.DragSupport;
import com.ibm.team.jface.tooltip.TooltipSupport;
import com.ibm.team.jface.viewerutilities.SelectionProvider;
import com.ibm.team.links.common.IItemReference;
import com.ibm.team.links.common.IReference;
import com.ibm.team.links.common.IURIReference;
import com.ibm.team.links.common.registry.IEndPointDescriptor;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.Location;
import com.ibm.team.workitem.client.IWorkItemListener;
import com.ibm.team.workitem.client.URIService;
import com.ibm.team.workitem.client.WorkItemChangeEvent;
import com.ibm.team.workitem.client.WorkItemWorkingCopy;
import com.ibm.team.workitem.common.internal.presentations.QuickInformationConfigurationManager;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.common.model.ReferencesChangeDetails;
import com.ibm.team.workitem.common.model.WorkItemLinkTypes;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.AspectEditorUtil;
import com.ibm.team.workitem.ide.ui.internal.editor.LinkHelper;
import com.ibm.team.workitem.ide.ui.internal.editor.links.LinkContentProvider;
import com.ibm.team.workitem.ide.ui.internal.editor.part.LinksPart;
import com.ibm.team.workitem.ide.ui.internal.editor.quickinformation.ItemizedQuickInformationEntry;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.views.navigator.LocalSelectionTransfer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumeratingReferenceQuickInformationEntry
extends ItemizedQuickInformationEntry<IReference> {
    private IEndPointDescriptor fEndPoint;
    private LinkContentProvider fLinkContentProvider = new LinkContentProvider(true);
    private WorkItemListener fWorkItemListener = new WorkItemListener();
    private boolean fShowState = false;
    private HyperlinkAdapter fURILinks;

    @Override
    public boolean canShow() {
        return this.fEndPoint != null && this.fLinkContentProvider.getChildren(this.fEndPoint).length > 0;
    }

    @Override
    public void shown(boolean reflow) {
        if (reflow) {
            this.fShowState = true;
        }
    }

    @Override
    public void adaptElementLink(Hyperlink link, final IReference element) {
        this.getQuickInformationPart().getLinkGroup().add(link);
        if (element.isItemReference()) {
            final IItemHandle item = ((IItemReference)element).getReferencedItem();
            final URI uri = URIService.createAuditableURI((ITeamRepository)this.getWorkingCopy().getTeamRepository(), (IItemHandle)item);
            link.setHref((Object)uri);
            link.addHyperlinkListener((IHyperlinkListener)this.fURILinks);
            new TooltipSupport((Control)link, true, true){

                protected Object mapElement(int x, int y) {
                    return item;
                }

                protected void openRequested(Object element) {
                    Hyperlinks.openHyperlink((URI)uri);
                }
            };
            SelectionProvider selectionProvider = new SelectionProvider(){

                public ISelection getSelection() {
                    return item == null ? StructuredSelection.EMPTY : new StructuredSelection((Object)item);
                }
            };
            MenuManager menuMgr = new MenuManager("#PopupMenu");
            menuMgr.setRemoveAllWhenShown(true);
            menuMgr.addMenuListener(new IMenuListener(){

                public void menuAboutToShow(IMenuManager manager) {
                    LinkHelper.addSelectionActions(EnumeratingReferenceQuickInformationEntry.this.getQuickInformationPart().getSite().getWorkbenchPage(), manager, new LinkHelper.InputSelectionProvider(EnumeratingReferenceQuickInformationEntry.this.getWorkingCopy(), (ISelection)new StructuredSelection((Object)element)));
                }
            });
            this.getQuickInformationPart().getSite().registerContextMenu(this.getQuickInformationPart().getId(), menuMgr, (ISelectionProvider)selectionProvider);
            Menu menu = menuMgr.createContextMenu((Control)link);
            link.setMenu(menu);
            new ItemizedQuickInformationEntry.ItemDragSupport((Control)link, item);
        } else if (element.isURIReference()) {
            final URI uri = ((IURIReference)element).getURI();
            link.setHref((Object)uri);
            link.addHyperlinkListener((IHyperlinkListener)this.fURILinks);
            new TooltipSupport((Control)link, true, true){

                protected Object mapElement(int x, int y) {
                    return element;
                }

                protected void openRequested(Object element2) {
                    Hyperlinks.openHyperlink((URI)uri);
                }

                protected String getMarkup(Object el, boolean isFocus) {
                    String text = AspectEditorUtil.safeGetLinkText(element, EnumeratingReferenceQuickInformationEntry.this.getQuickInformationPart().getLinkLableProvider());
                    if (isFocus) {
                        return "<a href='" + uri.toASCIIString() + "'>" + text + "</a>";
                    }
                    return text;
                }
            };
            SelectionProvider selectionProvider = new SelectionProvider(){

                public ISelection getSelection() {
                    return element == null ? StructuredSelection.EMPTY : new StructuredSelection((Object)element);
                }
            };
            MenuManager menuMgr = new MenuManager("#PopupMenu");
            menuMgr.setRemoveAllWhenShown(true);
            menuMgr.addMenuListener(new IMenuListener(){

                public void menuAboutToShow(IMenuManager manager) {
                    LinkHelper.addSelectionActions(EnumeratingReferenceQuickInformationEntry.this.getQuickInformationPart().getSite().getWorkbenchPage(), manager, new LinkHelper.InputSelectionProvider(EnumeratingReferenceQuickInformationEntry.this.getWorkingCopy(), (ISelection)new StructuredSelection((Object)element)));
                }
            });
            this.getQuickInformationPart().getSite().registerContextMenu(this.getQuickInformationPart().getId(), menuMgr, (ISelectionProvider)selectionProvider);
            Menu menu = menuMgr.createContextMenu((Control)link);
            link.setMenu(menu);
            new URIDragSupport((Control)link, (IURIReference)element);
        }
    }

    @Override
    public void adaptLDotsLink(Hyperlink link) {
        this.getQuickInformationPart().getLinkGroup().add(link);
        IHyperlinkListener hyperlinkListener = this.getQuickInformationPart().getPartActivator(this.getConfigurationEntry().getProperty("linkTarget"));
        if (hyperlinkListener != null) {
            link.addHyperlinkListener(hyperlinkListener);
        }
        new ReferenceToolTipSupport((Control)link, this.getTitle(), this.getElements());
    }

    @Override
    public void adaptTitleLink(Hyperlink titleLink, Label imageLabel) {
        this.getQuickInformationPart().getLinkGroup().add(titleLink);
        IHyperlinkListener hyperlinkListener = this.getQuickInformationPart().getPartActivator(this.getConfigurationEntry().getProperty("linkTarget"));
        if (hyperlinkListener != null) {
            titleLink.addHyperlinkListener(hyperlinkListener);
        }
        new ReferenceToolTipSupport((Control)titleLink, this.getTitle(), this.getElements());
        new ReferenceToolTipSupport((Control)imageLabel, this.getTitle(), this.getElements());
        this.createContextMenu((Control)titleLink, this.fEndPoint);
        this.createContextMenu((Control)imageLabel, this.fEndPoint);
        this.addItemDropTarget((Control)titleLink, this.fEndPoint);
        this.addItemDropTarget((Control)imageLabel, this.fEndPoint);
    }

    private void createContextMenu(Control control, final IEndPointDescriptor endPoint) {
        if (!WorkItemLinkTypes.isUserWritable((IEndPointDescriptor)endPoint)) {
            return;
        }
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        SelectionProvider selectionProvider = new SelectionProvider(){

            public ISelection getSelection() {
                return StructuredSelection.EMPTY;
            }
        };
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                LinkHelper.addSelectionActions(EnumeratingReferenceQuickInformationEntry.this.getQuickInformationPart().getSite().getWorkbenchPage(), manager, new LinkHelper.InputSelectionProvider(EnumeratingReferenceQuickInformationEntry.this.getWorkingCopy(), (ISelection)new StructuredSelection((Object)endPoint)));
            }
        });
        this.getQuickInformationPart().getSite().registerContextMenu(this.getQuickInformationPart().getId(), menuMgr, (ISelectionProvider)selectionProvider);
        Menu menu = menuMgr.createContextMenu(control);
        control.setMenu(menu);
    }

    private void addItemDropTarget(final Control control, final IEndPointDescriptor endPoint) {
        DropTarget target = new DropTarget(control, 7);
        target.setTransfer(new Transfer[]{LocalSelectionTransfer.getInstance()});
        target.addDropListener((DropTargetListener)new LinksPart.LinkDropTargetListener(){

            public void dragEnter(DropTargetEvent event) {
                super.dragEnter(event);
                if (control instanceof Hyperlink && event.detail != 0) {
                    ((Hyperlink)control).setUnderlined(true);
                }
            }

            public void dragLeave(DropTargetEvent event) {
                super.dragLeave(event);
                if (control instanceof Hyperlink) {
                    ((Hyperlink)control).setUnderlined(false);
                }
            }

            protected IEndPointDescriptor getEndPoint(DropTargetEvent event) {
                return endPoint;
            }

            protected WorkItemWorkingCopy getWorkingCopy() {
                return EnumeratingReferenceQuickInformationEntry.this.getWorkingCopy();
            }
        });
    }

    @Override
    public void dispose() {
        if (this.fLinkContentProvider != null) {
            this.fLinkContentProvider.dispose();
            this.fLinkContentProvider = null;
        }
        if (this.getQuickInformationPart().getUIListener() != null) {
            this.getQuickInformationPart().getUIListener().removeListener((IWorkItemListener)this.fWorkItemListener, "references");
        }
    }

    @Override
    public List<IReference> getElements() {
        ArrayList<IReference> references = new ArrayList<IReference>();
        Object[] objectArray = this.fLinkContentProvider.getChildren(this.fEndPoint);
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (o instanceof IReference) {
                references.add((IReference)o);
            }
            ++n2;
        }
        Collections.sort(references, new Comparator<IReference>(){

            @Override
            public int compare(IReference o1, IReference o2) {
                if (o1 == null) {
                    return 1;
                }
                if (o2 == null) {
                    return -1;
                }
                Date modified1 = o1.getLink().modified();
                Date modified2 = o2.getLink().modified();
                if (modified1 == null) {
                    return 1;
                }
                if (modified2 == null) {
                    return -1;
                }
                return Dates.compareTo((Date)modified1, (Date)modified2);
            }
        });
        return references;
    }

    @Override
    public Image getImage() {
        return this.getQuickInformationPart().getLinkLableProvider().getColumnImage(this.fEndPoint, 0);
    }

    @Override
    public String getShortIdentifier(IReference element) {
        int index = this.getElements().indexOf(element);
        if (index == -1) {
            return null;
        }
        return String.valueOf(index + 1);
    }

    @Override
    public String getTitle() {
        if (this.getConfigurationEntry().getTitle() != null) {
            return this.getConfigurationEntry().getTitle();
        }
        return this.fEndPoint.getDisplayName();
    }

    @Override
    public void init() {
        this.fLinkContentProvider.inputChanged(null, null, this.getWorkingCopy());
        this.fURILinks = new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                if (e.getHref() instanceof URI) {
                    Hyperlinks.openHyperlink((URI)((URI)e.getHref()));
                }
            }
        };
        this.assignDescriptor();
        if (this.getQuickInformationPart().getUIListener() != null) {
            this.getQuickInformationPart().getUIListener().addListener((IWorkItemListener)this.fWorkItemListener, "references");
        }
    }

    private void assignDescriptor() {
        List descriptors = this.getWorkingCopy().getReferences().getTypes();
        String combinedId = this.getConfigurationEntry().getProperty("endpointId");
        this.fEndPoint = QuickInformationConfigurationManager.findEndpointDescriptor((List)descriptors, (String)combinedId);
    }

    private void triggerUpdate() {
        boolean show = this.canShow();
        if (show != this.fShowState) {
            this.getQuickInformationPart().updateItems(true);
            this.fShowState = show;
        } else {
            this.getQuickInformationPart().updateItems(false);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ReferenceToolTipSupport
    extends TooltipSupport {
        private List<IReference> fReferences;
        private String fTitle;

        public ReferenceToolTipSupport(Control control, String title, List<IReference> references) {
            super(control, true, false);
            this.fTitle = title;
            this.fReferences = references;
        }

        protected Object mapElement(int x, int y) {
            return this.fReferences;
        }

        protected String getMarkup(Object element, boolean isFocus) {
            StringBuffer result = new StringBuffer();
            result.append("<ul>");
            for (IReference r : this.fReferences) {
                String uri = null;
                if (isFocus && EnumeratingReferenceQuickInformationEntry.this.getWorkingCopy() != null) {
                    if (r.isItemReference()) {
                        if (((IItemReference)r).getReferencedItem() != null) {
                            uri = URIService.createAuditableURI((ITeamRepository)((ITeamRepository)EnumeratingReferenceQuickInformationEntry.this.getWorkingCopy().getWorkItem().getOrigin()), (IItemHandle)((IItemReference)r).getReferencedItem()).toString();
                        }
                    } else if (r.isURIReference() && r.getLink() != null && r.getLink().getOrigin() != null) {
                        URI context = Location.itemLocation((IItemHandle)r.getLink(), (String)((ITeamRepository)r.getLink().getOrigin()).getRepositoryURI()).toAbsoluteUri();
                        uri = Hyperlinks.resolveURI((URI)((IURIReference)r).getURI(), (URI)context).toString();
                    }
                }
                String text = AspectEditorUtil.safeGetLinkText(r, EnumeratingReferenceQuickInformationEntry.this.getQuickInformationPart().getLinkLableProvider());
                if (uri == null) {
                    result.append("<li>" + text + "</li>");
                    continue;
                }
                result.append("<li><a href='" + uri + "'>" + text + "</a></li>");
            }
            result.append("</ul>");
            String title = "<b>" + XMLString.createFromPlainText((String)this.fTitle).getXMLText() + ": " + this.fReferences.size() + "</b><br />";
            return String.valueOf(title) + result.toString();
        }
    }

    private static class URIDragSupport
    extends DragSupport {
        private final IURIReference fUri;

        public URIDragSupport(Control control, IURIReference uri) {
            super(control);
            this.fUri = uri;
        }

        protected boolean validateSelection(ISelection selection) {
            if (super.validateSelection(selection)) {
                IStructuredSelection structured = (IStructuredSelection)selection;
                Object[] objectArray = structured.toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object element = objectArray[n2];
                    if (!(element instanceof IURIReference)) {
                        return false;
                    }
                    ++n2;
                }
                return true;
            }
            return false;
        }

        public ISelection getSelection() {
            return new StructuredSelection((Object)this.fUri);
        }
    }

    private class WorkItemListener
    implements IWorkItemListener {
        private WorkItemListener() {
        }

        public void workItemAttributeChanged(WorkItemChangeEvent event) {
            if (!event.affects((IWorkItemHandle)EnumeratingReferenceQuickInformationEntry.this.getWorkingCopy().getWorkItem())) {
                return;
            }
            if (event.affects("references")) {
                IEndPointDescriptor desc;
                if (EnumeratingReferenceQuickInformationEntry.this.fEndPoint == null) {
                    EnumeratingReferenceQuickInformationEntry.this.assignDescriptor();
                }
                if (EnumeratingReferenceQuickInformationEntry.this.fEndPoint == null) {
                    return;
                }
                IAdaptable details = event.getAttributeChangeDetails("references");
                if (details == null) {
                    return;
                }
                ReferencesChangeDetails change = (ReferencesChangeDetails)details.getAdapter(ReferencesChangeDetails.class);
                if (change == null) {
                    return;
                }
                for (IReference ref : change.getAdded()) {
                    desc = WorkItemLinkTypes.getEndPointDescriptor((IReference)ref);
                    if (!desc.equals(EnumeratingReferenceQuickInformationEntry.this.fEndPoint)) continue;
                    EnumeratingReferenceQuickInformationEntry.this.triggerUpdate();
                    return;
                }
                for (IReference ref : change.getRemoved()) {
                    desc = WorkItemLinkTypes.getEndPointDescriptor((IReference)ref);
                    if (!desc.equals(EnumeratingReferenceQuickInformationEntry.this.fEndPoint)) continue;
                    EnumeratingReferenceQuickInformationEntry.this.triggerUpdate();
                    return;
                }
            }
        }

        public void workItemAttributeDependencyChanged(WorkItemChangeEvent event) {
        }
    }
}

