/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.editor.quickinformation;

import com.ibm.team.foundation.common.text.XMLString;
import com.ibm.team.foundation.rcp.core.hyperlinks.Hyperlinks;
import com.ibm.team.jface.tooltip.TooltipSupport;
import com.ibm.team.links.common.IItemReference;
import com.ibm.team.links.common.IReference;
import com.ibm.team.links.common.IURIReference;
import com.ibm.team.links.common.registry.IEndPointDescriptor;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.Location;
import com.ibm.team.workitem.client.IWorkItemListener;
import com.ibm.team.workitem.client.URIService;
import com.ibm.team.workitem.client.WorkItemChangeEvent;
import com.ibm.team.workitem.common.internal.presentations.QuickInformationConfigurationManager;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.common.model.ReferencesChangeDetails;
import com.ibm.team.workitem.common.model.WorkItemEndPoints;
import com.ibm.team.workitem.common.model.WorkItemLinkTypes;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemEditorToolkit;
import com.ibm.team.workitem.ide.ui.internal.editor.links.LinkContentProvider;
import com.ibm.team.workitem.ide.ui.internal.editor.quickinformation.AbstractQuickInformationEntry;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectorQuickInformationEntry
extends AbstractQuickInformationEntry<IReference> {
    private List<IEndPointDescriptor> fDescriptors = new ArrayList<IEndPointDescriptor>();
    private LinkContentProvider fLinkContentProvider = new LinkContentProvider(true);
    private Set<String> fAllDescriptorIds = new HashSet<String>();
    private int fSize = 0;
    private WorkItemListener fWorkItemListener = new WorkItemListener();

    @Override
    public boolean canShow() {
        return this.fDescriptors.size() > 0;
    }

    public void setAllEntries(List<QuickInformationConfigurationManager.QuickInformationConfigurationEntry> allEntries) {
        this.fAllDescriptorIds = new HashSet<String>();
        for (QuickInformationConfigurationManager.QuickInformationConfigurationEntry entry : allEntries) {
            if (entry.getProperty("endpointId") != null) {
                this.fAllDescriptorIds.add(entry.getProperty("endpointId"));
                continue;
            }
            if (!"com.ibm.team.workitem.quickinformation.kind.artifact".equals(entry.getKind())) continue;
            this.fAllDescriptorIds.add(WorkItemEndPoints.ATTACHMENT.getId());
        }
    }

    public void adaptTitleLink(IEndPointDescriptor desc, Hyperlink titleLink, Label imageLabel) {
        this.getQuickInformationPart().getLinkGroup().add(titleLink);
        IHyperlinkListener hyperlinkListener = this.getQuickInformationPart().getPartActivator(this.getConfigurationEntry().getProperty("linkTarget"));
        if (hyperlinkListener != null) {
            titleLink.addHyperlinkListener(hyperlinkListener);
        }
        new ReferenceToolTipSupport((Control)titleLink, this.getTitle(desc), this.getElements(desc));
        new ReferenceToolTipSupport((Control)imageLabel, this.getTitle(desc), this.getElements(desc));
        this.getQuickInformationPart().addInvalidDropTarget((Control)titleLink);
        this.getQuickInformationPart().addInvalidDropTarget((Control)imageLabel);
    }

    @Override
    public void createContent(Composite parent) {
        WorkItemEditorToolkit toolkit = (WorkItemEditorToolkit)this.getQuickInformationPart().getSite().getToolkit();
        for (IEndPointDescriptor desc : this.fDescriptors) {
            if (this.getElements(desc).size() == 0) continue;
            Label label = toolkit.createLabel(parent, null);
            label.setImage(this.getImage(desc));
            label.setBackground(null);
            Composite links = toolkit.createComposite(parent);
            links.setBackground(null);
            RowLayout rl = new RowLayout();
            rl.marginLeft = 0;
            rl.marginRight = 0;
            rl.marginTop = 0;
            rl.marginBottom = 0;
            rl.spacing = 0;
            links.setLayout((Layout)rl);
            String nOfItems = "";
            nOfItems = " (" + this.getElements(desc).size() + ")";
            Hyperlink link = toolkit.createCustomHyperlink(links, String.valueOf(this.getTitle(desc)) + nOfItems, 0);
            this.adaptTitleLink(desc, link, label);
        }
    }

    @Override
    public void dispose() {
        if (this.fLinkContentProvider != null) {
            this.fLinkContentProvider.dispose();
            this.fLinkContentProvider = null;
        }
        if (this.getQuickInformationPart().getUIListener() != null) {
            this.getQuickInformationPart().getUIListener().removeListener((IWorkItemListener)this.fWorkItemListener, "references");
        }
    }

    public List<IReference> getElements(IEndPointDescriptor desc) {
        ArrayList<IReference> references = new ArrayList<IReference>();
        Object[] objectArray = this.fLinkContentProvider.getChildren(desc);
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (o instanceof IReference) {
                references.add((IReference)o);
            }
            ++n2;
        }
        return references;
    }

    public Image getImage(IEndPointDescriptor desc) {
        return this.getQuickInformationPart().getLinkLableProvider().getColumnImage(desc, 0);
    }

    public String getTitle(IEndPointDescriptor desc) {
        return desc.getDisplayName();
    }

    @Override
    public void init() {
        this.fLinkContentProvider.inputChanged(null, null, this.getWorkingCopy());
        this.assignDescriptors();
        if (this.getQuickInformationPart().getUIListener() != null) {
            this.getQuickInformationPart().getUIListener().addListener((IWorkItemListener)this.fWorkItemListener, "references");
        }
    }

    private boolean assignDescriptors() {
        ArrayList descriptors = new ArrayList(this.getWorkingCopy().getReferences().getTypes());
        ArrayList<IEndPointDescriptor> handled = new ArrayList<IEndPointDescriptor>();
        for (String id : this.fAllDescriptorIds) {
            IEndPointDescriptor the = QuickInformationConfigurationManager.findEndpointDescriptor(descriptors, (String)id);
            if (the == null) continue;
            handled.add(the);
        }
        descriptors.removeAll(handled);
        boolean changed = false;
        for (IEndPointDescriptor desc : descriptors) {
            if (this.fDescriptors.contains(desc)) continue;
            this.fDescriptors.add(desc);
            changed = true;
        }
        if (!changed && !descriptors.containsAll(this.fDescriptors)) {
            changed = true;
        }
        return changed;
    }

    private void triggerUpdate() {
        int size = this.fDescriptors.size();
        if (this.fSize != size) {
            this.getQuickInformationPart().updateItems(true);
            this.fSize = size;
        } else {
            this.getQuickInformationPart().updateItems(false);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ReferenceToolTipSupport
    extends TooltipSupport {
        private List<IReference> fReferences;
        private String fTitle;

        public ReferenceToolTipSupport(Control control, String title, List<IReference> references) {
            super(control, true, false);
            this.fTitle = title;
            this.fReferences = references;
        }

        protected Object mapElement(int x, int y) {
            return this.fReferences;
        }

        protected String getMarkup(Object element, boolean isFocus) {
            StringBuffer result = new StringBuffer();
            result.append("<ul>");
            for (IReference r : this.fReferences) {
                String uri = null;
                if (isFocus && CollectorQuickInformationEntry.this.getWorkingCopy() != null) {
                    if (r.isItemReference()) {
                        if (((IItemReference)r).getReferencedItem() != null) {
                            uri = URIService.createAuditableURI((ITeamRepository)((ITeamRepository)CollectorQuickInformationEntry.this.getWorkingCopy().getWorkItem().getOrigin()), (IItemHandle)((IItemReference)r).getReferencedItem()).toString();
                        }
                    } else if (r.isURIReference() && r.getLink() != null && r.getLink().getOrigin() != null) {
                        URI context = Location.itemLocation((IItemHandle)r.getLink(), (String)((ITeamRepository)r.getLink().getOrigin()).getRepositoryURI()).toAbsoluteUri();
                        uri = Hyperlinks.resolveURI((URI)((IURIReference)r).getURI(), (URI)context).toString();
                    }
                }
                String text = CollectorQuickInformationEntry.this.getQuickInformationPart().getLinkLableProvider().getText(r);
                text = XMLString.createFromPlainText((String)text).getXMLText();
                if (uri == null) {
                    result.append("<li>" + text + "</li>");
                    continue;
                }
                result.append("<li><a href='" + uri + "'>" + text + "</a></li>");
            }
            result.append("</ul>");
            String title = "<b>" + XMLString.createFromPlainText((String)this.fTitle).getXMLText() + ": " + this.fReferences.size() + "</b><br />";
            return String.valueOf(title) + result.toString();
        }
    }

    private class WorkItemListener
    implements IWorkItemListener {
        private WorkItemListener() {
        }

        public void workItemAttributeChanged(WorkItemChangeEvent event) {
            if (!event.affects((IWorkItemHandle)CollectorQuickInformationEntry.this.getWorkingCopy().getWorkItem())) {
                return;
            }
            if (event.affects("references")) {
                IEndPointDescriptor desc;
                if (CollectorQuickInformationEntry.this.assignDescriptors()) {
                    CollectorQuickInformationEntry.this.triggerUpdate();
                    return;
                }
                IAdaptable details = event.getAttributeChangeDetails("references");
                if (details == null) {
                    return;
                }
                ReferencesChangeDetails change = (ReferencesChangeDetails)details.getAdapter(ReferencesChangeDetails.class);
                if (change == null) {
                    return;
                }
                for (IReference ref : change.getAdded()) {
                    desc = WorkItemLinkTypes.getEndPointDescriptor((IReference)ref);
                    if (!CollectorQuickInformationEntry.this.fDescriptors.contains(desc)) continue;
                    CollectorQuickInformationEntry.this.triggerUpdate();
                    return;
                }
                for (IReference ref : change.getRemoved()) {
                    desc = WorkItemLinkTypes.getEndPointDescriptor((IReference)ref);
                    if (!CollectorQuickInformationEntry.this.fDescriptors.contains(desc)) continue;
                    CollectorQuickInformationEntry.this.triggerUpdate();
                    return;
                }
            }
        }

        public void workItemAttributeDependencyChanged(WorkItemChangeEvent event) {
        }
    }
}

