/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.editor.quickinformation;

import com.ibm.icu.text.Collator;
import com.ibm.team.foundation.common.text.XMLString;
import com.ibm.team.foundation.rcp.core.hyperlinks.Hyperlinks;
import com.ibm.team.foundation.rcp.ui.dnd.DragSupport;
import com.ibm.team.jface.labelProviders.ElementRemovedNotifierImpl;
import com.ibm.team.jface.labelProviders.IElementRemovedNotifier;
import com.ibm.team.jface.labelProviders.StandardLabelProvider;
import com.ibm.team.jface.tooltip.TooltipSupport;
import com.ibm.team.jface.viewerutilities.SelectionProvider;
import com.ibm.team.links.common.IItemReference;
import com.ibm.team.links.common.IReference;
import com.ibm.team.links.common.registry.IEndPointDescriptor;
import com.ibm.team.workitem.client.IWorkItemListener;
import com.ibm.team.workitem.client.WorkItemChangeEvent;
import com.ibm.team.workitem.client.WorkItemWorkingCopy;
import com.ibm.team.workitem.client.internal.ArtifactLink;
import com.ibm.team.workitem.client.internal.util.ClientUtils;
import com.ibm.team.workitem.common.model.IAttachmentHandle;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.common.model.ItemURI;
import com.ibm.team.workitem.common.model.ReferencesChangeDetails;
import com.ibm.team.workitem.common.model.WorkItemEndPoints;
import com.ibm.team.workitem.common.model.WorkItemLinkTypes;
import com.ibm.team.workitem.ide.ui.internal.editor.LinkHelper;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemUIWorkingCopy;
import com.ibm.team.workitem.ide.ui.internal.editor.part.AttachmentsPart;
import com.ibm.team.workitem.ide.ui.internal.editor.quickinformation.ItemizedQuickInformationEntry;
import com.ibm.team.workitem.ide.ui.internal.editor.quickinformation.Messages;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.views.navigator.LocalSelectionTransfer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArtifactQuickInformationEntry
extends ItemizedQuickInformationEntry<ArtifactLink> {
    static final String ID = "com.ibm.team.workitem.quickinformation.kind.artifact";
    private AttachmentsPart.ArtifactLinksLabelProvider fArtifactLabelProvider = new AttachmentsPart.ArtifactLinksLabelProvider();
    private IHyperlinkListener fArtifactLinks;
    private boolean fShowState = false;
    private WorkItemListener fWorkItemListener = new WorkItemListener();

    @Override
    public boolean canShow() {
        WorkItemUIWorkingCopy uiWorkingCopy = (WorkItemUIWorkingCopy)this.getWorkingCopy().getAdapter(WorkItemUIWorkingCopy.class);
        ArrayList artifactLinks = new ArrayList(uiWorkingCopy.getArtifactLinks());
        return artifactLinks.size() > 0;
    }

    @Override
    public void shown(boolean reflow) {
        if (reflow) {
            this.fShowState = true;
        }
    }

    @Override
    public void adaptElementLink(Hyperlink link, ArtifactLink element) {
        this.adaptArtifactLinkHyperlink(link, element);
        new ArtifactDragSupport((Control)link, element);
    }

    @Override
    public void adaptLDotsLink(Hyperlink link) {
        this.getQuickInformationPart().getLinkGroup().add(link);
        IHyperlinkListener hyperlinkListener = this.getQuickInformationPart().getPartActivator(this.getConfigurationEntry().getProperty("linkTarget"));
        if (hyperlinkListener != null) {
            link.addHyperlinkListener(hyperlinkListener);
        }
        new ArtifactSummaryTooltipSupport((Control)link, this.getTitle(), this.getElements());
    }

    @Override
    public void adaptTitleLink(Hyperlink titleLink, Label imageLabel) {
        this.getQuickInformationPart().getLinkGroup().add(titleLink);
        IHyperlinkListener hyperlinkListener = this.getQuickInformationPart().getPartActivator(this.getConfigurationEntry().getProperty("linkTarget"));
        if (hyperlinkListener != null) {
            titleLink.addHyperlinkListener(hyperlinkListener);
        }
        this.addArtifactDropTarget((Control)titleLink);
        this.addArtifactDropTarget((Control)imageLabel);
        new ArtifactSummaryTooltipSupport((Control)titleLink, this.getTitle(), this.getElements());
        new ArtifactSummaryTooltipSupport((Control)imageLabel, this.getTitle(), this.getElements());
        this.createArtifactContextMenu((Control)titleLink);
        this.createArtifactContextMenu((Control)imageLabel);
    }

    @Override
    public void dispose() {
        if (this.getQuickInformationPart().getUIListener() != null) {
            this.getQuickInformationPart().getUIListener().removeListener((IWorkItemListener)this.fWorkItemListener, "references");
        }
        if (this.fArtifactLabelProvider != null) {
            this.fArtifactLabelProvider.dispose();
            this.fArtifactLabelProvider = null;
        }
    }

    @Override
    public List<ArtifactLink> getElements() {
        WorkItemUIWorkingCopy uiWorkingCopy = (WorkItemUIWorkingCopy)this.getWorkingCopy().getAdapter(WorkItemUIWorkingCopy.class);
        ArrayList<ArtifactLink> artifactLinks = new ArrayList<ArtifactLink>(uiWorkingCopy.getArtifactLinks());
        Collections.sort(artifactLinks, new Comparator<ArtifactLink>(){

            @Override
            public int compare(ArtifactLink o1, ArtifactLink o2) {
                return Collator.getInstance().compare(ArtifactQuickInformationEntry.this.fArtifactLabelProvider.getText(o1), ArtifactQuickInformationEntry.this.fArtifactLabelProvider.getText(o2));
            }
        });
        return artifactLinks;
    }

    @Override
    public Image getImage() {
        return this.getQuickInformationPart().getLinkLableProvider().getColumnImage(WorkItemEndPoints.ATTACHMENT, 0);
    }

    @Override
    public String getShortIdentifier(ArtifactLink element) {
        String linkText = this.fArtifactLabelProvider.getColumnText(element, 0);
        if (linkText != null && linkText.contains(":")) {
            linkText = linkText.substring(0, linkText.indexOf(58)).trim();
        }
        return linkText;
    }

    @Override
    public String getTitle() {
        if (this.getConfigurationEntry().getTitle() != null) {
            return this.getConfigurationEntry().getTitle();
        }
        return Messages.ArtifactQuickInformationEntry_ATTACHMENTS;
    }

    @Override
    public boolean showFirstNElements() {
        return false;
    }

    @Override
    public void init() {
        this.fArtifactLinks = new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                if (e.getHref() instanceof ArtifactLink) {
                    LinkHelper.openArtifact((ArtifactLink)e.getHref());
                }
            }
        };
        if (this.getQuickInformationPart().getUIListener() != null) {
            this.getQuickInformationPart().getUIListener().addListener((IWorkItemListener)this.fWorkItemListener, "references");
        }
    }

    private void createArtifactContextMenu(Control control) {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        SelectionProvider selectionProvider = new SelectionProvider(){

            public ISelection getSelection() {
                return StructuredSelection.EMPTY;
            }
        };
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                manager.add((IAction)new AttachmentsPart.AddFileAction(ArtifactQuickInformationEntry.this.getWorkingCopy()));
                manager.add((IAction)new AttachmentsPart.AddScreenshotAction(ArtifactQuickInformationEntry.this.getWorkingCopy()));
                manager.add((IContributionItem)new Separator("additions"));
            }
        });
        this.getQuickInformationPart().getSite().registerContextMenu(this.getQuickInformationPart().getId(), menuMgr, (ISelectionProvider)selectionProvider);
        Menu menu = menuMgr.createContextMenu(control);
        control.setMenu(menu);
    }

    private void adaptArtifactLinkHyperlink(Hyperlink link, final ArtifactLink aLink) {
        this.getQuickInformationPart().getLinkGroup().add(link);
        link.setHref((Object)aLink);
        if (aLink.getReference().isItemReference()) {
            new TooltipSupport((Control)link, true, true){

                protected Object mapElement(int x, int y) {
                    return ((IItemReference)aLink.getReference()).getReferencedItem();
                }

                protected void openRequested(Object element) {
                    URI uri = ItemURI.generateAuditableURI((String)ArtifactQuickInformationEntry.this.getWorkingCopy().getTeamRepository().getRepositoryURI(), (Object)element);
                    Hyperlinks.openHyperlink((URI)uri);
                }
            };
        }
        link.addHyperlinkListener(this.fArtifactLinks);
        SelectionProvider selectionProvider = new SelectionProvider(){

            public ISelection getSelection() {
                if (aLink == null) {
                    return StructuredSelection.EMPTY;
                }
                if (aLink.getReference().isItemReference() && ((IItemReference)aLink.getReference()).getReferencedItem() instanceof IAttachmentHandle) {
                    return new StructuredSelection((Object)((IItemReference)aLink.getReference()).getReferencedItem());
                }
                return new StructuredSelection((Object)aLink);
            }
        };
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        Action openAction = new Action(Messages.ArtifactQuickInformationEntry_OPEN){

            public void run() {
                LinkHelper.openArtifact(aLink);
            }
        };
        Action removeItemAction = new Action(Messages.ArtifactQuickInformationEntry_REMOVE){

            public void run() {
                ArtifactQuickInformationEntry.this.getWorkingCopy().getReferences().remove(aLink.getReference());
            }
        };
        menuMgr.addMenuListener(new IMenuListener((IAction)openAction, (IAction)removeItemAction){
            private final /* synthetic */ IAction val$openAction;
            private final /* synthetic */ IAction val$removeItemAction;
            {
                this.val$openAction = iAction;
                this.val$removeItemAction = iAction2;
            }

            public void menuAboutToShow(IMenuManager manager) {
                manager.add(this.val$openAction);
                manager.add(this.val$removeItemAction);
                manager.add((IContributionItem)new Separator("additions"));
            }
        });
        this.getQuickInformationPart().getSite().registerContextMenu(this.getQuickInformationPart().getId(), menuMgr, (ISelectionProvider)selectionProvider);
        Menu menu = menuMgr.createContextMenu((Control)link);
        link.setMenu(menu);
    }

    private void addArtifactDropTarget(final Control control) {
        DropTarget target = new DropTarget(control, 5);
        target.setTransfer(new Transfer[]{LocalSelectionTransfer.getInstance(), FileTransfer.getInstance()});
        target.addDropListener((DropTargetListener)new AttachmentsPart.AttachmentDropListener(){

            public void dragEnter(DropTargetEvent event) {
                super.dragEnter(event);
                if (control instanceof Hyperlink && event.detail != 0) {
                    ((Hyperlink)control).setUnderlined(true);
                }
            }

            public void dragLeave(DropTargetEvent event) {
                super.dragLeave(event);
                if (control instanceof Hyperlink) {
                    ((Hyperlink)control).setUnderlined(false);
                }
            }

            protected WorkItemWorkingCopy getWorkingCopy() {
                return ArtifactQuickInformationEntry.this.getWorkingCopy();
            }
        });
    }

    private void triggerUpdate() {
        boolean show = this.canShow();
        if (show != this.fShowState) {
            this.getQuickInformationPart().updateItems(true);
            this.fShowState = show;
        } else {
            this.getQuickInformationPart().updateItems(false);
        }
    }

    private static class ArtifactDragSupport
    extends DragSupport {
        private final ArtifactLink fLink;

        public ArtifactDragSupport(Control control, ArtifactLink link) {
            super(control);
            this.fLink = link;
        }

        protected boolean validateSelection(ISelection selection) {
            if (super.validateSelection(selection)) {
                IStructuredSelection structured = (IStructuredSelection)selection;
                Object[] objectArray = structured.toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object element = objectArray[n2];
                    if (!(element instanceof IAttachmentHandle)) {
                        return false;
                    }
                    ++n2;
                }
                return true;
            }
            return false;
        }

        public ISelection getSelection() {
            if (this.fLink == null) {
                return StructuredSelection.EMPTY;
            }
            if (this.fLink.getReference().isItemReference() && ((IItemReference)this.fLink.getReference()).getReferencedItem() instanceof IAttachmentHandle) {
                return new StructuredSelection((Object)((IItemReference)this.fLink.getReference()).getReferencedItem());
            }
            return StructuredSelection.EMPTY;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ArtifactSummaryTooltipSupport
    extends TooltipSupport {
        private List<ArtifactLink> fReferences;
        private String fTitle;
        private StandardLabelProvider fStandardLabelProvider;

        public ArtifactSummaryTooltipSupport(Control control, String title, List<ArtifactLink> references) {
            super(control, true, false);
            this.fStandardLabelProvider = new StandardLabelProvider((IElementRemovedNotifier)new ElementRemovedNotifierImpl());
            control.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    if (ArtifactSummaryTooltipSupport.this.fStandardLabelProvider != null) {
                        ArtifactSummaryTooltipSupport.this.fStandardLabelProvider.dispose();
                        ArtifactSummaryTooltipSupport.this.fStandardLabelProvider = null;
                    }
                }
            });
            this.fTitle = title;
            this.fReferences = references;
        }

        protected Object mapElement(int x, int y) {
            return this.fReferences;
        }

        protected String getMarkup(Object element, boolean isFocus) {
            StringBuffer result = new StringBuffer();
            result.append("<ul>");
            for (ArtifactLink r : this.fReferences) {
                String text = ArtifactQuickInformationEntry.this.fArtifactLabelProvider.getText(r);
                text = XMLString.createFromPlainText((String)text).getXMLText();
                if (isFocus && ArtifactQuickInformationEntry.this.getWorkingCopy() != null) {
                    String uri = ClientUtils.createURI((String)ArtifactQuickInformationEntry.this.getWorkingCopy().getTeamRepository().getRepositoryURI(), (IReference)r.getReference()).toString();
                    result.append("<li><a href='" + uri + "'>" + text + "</a></li>");
                    continue;
                }
                result.append("<li>" + text + "</li>");
            }
            result.append("</ul>");
            String title = "<b>" + XMLString.createFromPlainText((String)this.fTitle).getXMLText() + ": " + this.fReferences.size() + "</b><br />";
            return String.valueOf(title) + result.toString();
        }
    }

    private class WorkItemListener
    implements IWorkItemListener {
        private WorkItemListener() {
        }

        public void workItemAttributeChanged(WorkItemChangeEvent event) {
            if (!event.affects((IWorkItemHandle)ArtifactQuickInformationEntry.this.getWorkingCopy().getWorkItem())) {
                return;
            }
            if (event.affects("references")) {
                IEndPointDescriptor desc;
                IAdaptable details = event.getAttributeChangeDetails("references");
                if (details == null) {
                    return;
                }
                ReferencesChangeDetails change = (ReferencesChangeDetails)details.getAdapter(ReferencesChangeDetails.class);
                if (change == null) {
                    return;
                }
                for (IReference ref : change.getAdded()) {
                    desc = WorkItemLinkTypes.getEndPointDescriptor((IReference)ref);
                    if (!desc.equals(WorkItemEndPoints.ATTACHMENT)) continue;
                    ArtifactQuickInformationEntry.this.triggerUpdate();
                    return;
                }
                for (IReference ref : change.getRemoved()) {
                    desc = WorkItemLinkTypes.getEndPointDescriptor((IReference)ref);
                    if (!desc.equals(WorkItemEndPoints.ATTACHMENT)) continue;
                    ArtifactQuickInformationEntry.this.triggerUpdate();
                    return;
                }
            }
        }

        public void workItemAttributeDependencyChanged(WorkItemChangeEvent event) {
        }
    }
}

