/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.editor.presentations.presentationhandler;

import com.ibm.team.jface.util.UIUpdaterJob;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.client.WorkItemChangeEvent;
import com.ibm.team.workitem.client.WorkItemEvent;
import com.ibm.team.workitem.client.WorkItemWorkingCopy;
import com.ibm.team.workitem.client.WorkingCopyEvent;
import com.ibm.team.workitem.common.IWorkItemCommon;
import com.ibm.team.workitem.common.internal.RequiredPropertiesAdvisor;
import com.ibm.team.workitem.common.internal.WorkItemCommon;
import com.ibm.team.workitem.common.internal.model.WorkItemAttributes;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.Identifier;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.presentationhandler.EditorPresentationHandler;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.presentationhandler.Messages;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.presentationhandler.PresentationUpdaterContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequiredPropertiesHandler
extends EditorPresentationHandler {
    private RequiredUpdaterJob fJob = new RequiredUpdaterJob(Messages.RequiredPropertiesHandler_UPDATING_REQUIRED_PROPERTIES);

    @Override
    public void handle(List<PresentationUpdaterContext> updaterContexts, WorkItemEvent event) {
        if (event.getKind() == WorkItemEvent.EventKind.INITIALIZATION || event.getKind() == WorkItemEvent.EventKind.LIFECYCLE_CHANGE && "workflowAction".equals(((WorkingCopyEvent)event).getType()) || event.getKind() == WorkItemEvent.EventKind.ATTRIBUTE_CHANGE && (((WorkItemChangeEvent)event).affects(IWorkItem.CATEGORY_PROPERTY) || ((WorkItemChangeEvent)event).affects(IWorkItem.TARGET_PROPERTY) || ((WorkItemChangeEvent)event).affects(IWorkItem.TYPE_PROPERTY) || ((WorkItemChangeEvent)event).affects(IWorkItem.STATE_PROPERTY))) {
            this.fJob.addContexts(updaterContexts);
            this.fJob.schedule();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RequiredUpdaterJob
    extends UIUpdaterJob {
        private Map<PresentationUpdaterContext, Boolean> fToUpdate;
        private List<PresentationUpdaterContext> fContexts;

        public RequiredUpdaterJob(String name) {
            super(name);
            this.fToUpdate = new HashMap<PresentationUpdaterContext, Boolean>();
            this.fContexts = new ArrayList<PresentationUpdaterContext>();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addContexts(List<PresentationUpdaterContext> contexts) {
            Map<PresentationUpdaterContext, Boolean> map = this.fToUpdate;
            synchronized (map) {
                this.fContexts.addAll(contexts);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IStatus runInBackground(IProgressMonitor monitor) {
            WorkItemWorkingCopy workingCopy = RequiredPropertiesHandler.this.getPresentationContext().getWorkingCopy();
            if (workingCopy == null) {
                return Status.OK_STATUS;
            }
            try {
                ITeamRepository teamRepository = (ITeamRepository)workingCopy.getWorkItem().getOrigin();
                IWorkItemClient workitemClient = (IWorkItemClient)teamRepository.getClientLibrary(IWorkItemClient.class);
                List properties = workitemClient.findRequiredProperties(workingCopy.getWorkItem(), monitor);
                List workflowProperties = Collections.emptyList();
                String stateId = RequiredPropertiesAdvisor.findTargetStateId((IWorkItem)workingCopy.getWorkItem(), (String)workingCopy.getWorkflowAction(), (IWorkItemCommon)workitemClient, (IProgressMonitor)monitor);
                if (stateId != null) {
                    workflowProperties = ((WorkItemCommon)workitemClient).findRequiredWorkflowProperties(workingCopy.getWorkItem(), stateId, monitor);
                }
                Map<PresentationUpdaterContext, Boolean> map = this.fToUpdate;
                synchronized (map) {
                    for (PresentationUpdaterContext context : this.fContexts) {
                        if (context.getPresentationDescriptor().getAttributeId() == null) continue;
                        String attributeId = WorkItemAttributes.getAttributeId((Identifier)context.getPresentationDescriptor().getAttributeId());
                        boolean req = properties.contains(attributeId) || workflowProperties.contains(attributeId);
                        this.fToUpdate.put(context, req);
                    }
                    this.fContexts.clear();
                }
                return Status.OK_STATUS;
            }
            catch (TeamRepositoryException x) {
                return new Status(4, "com.ibm.team.workitem.ide.ui", 4, Messages.RequiredPropertiesHandler_EXCEPTION_RETRIEVING_REQUIRED_PROPERTIES, (Throwable)x);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IStatus runInUI(IProgressMonitor monitor) {
            Map<PresentationUpdaterContext, Boolean> map = this.fToUpdate;
            synchronized (map) {
                if (RequiredPropertiesHandler.this.getPresentationContext().getWorkingCopy() != null) {
                    for (Map.Entry<PresentationUpdaterContext, Boolean> e : this.fToUpdate.entrySet()) {
                        e.getKey().getPresentationUpdater().setRequired(e.getValue());
                    }
                }
                this.fToUpdate.clear();
            }
            return super.runInUI(monitor);
        }
    }
}

