/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.editor.presentations.presentationhandler;

import com.ibm.team.workitem.client.WorkItemChangeEvent;
import com.ibm.team.workitem.common.internal.presentations.PresentationDescriptor;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.presentationhandler.IPresentationUpdater;
import java.util.List;
import org.eclipse.core.runtime.IStatus;

public class PresentationUpdaterContext {
    private PresentationDescriptor fDescriptor;
    private PresentationUpdaterProxy fProxy;

    public PresentationUpdaterContext(IPresentationUpdater updater, PresentationDescriptor descriptor) {
        this.fProxy = new PresentationUpdaterProxy(updater);
        this.fDescriptor = descriptor;
    }

    public IPresentationUpdater getPresentationUpdater() {
        return this.fProxy;
    }

    public PresentationDescriptor getPresentationDescriptor() {
        return this.fDescriptor;
    }

    public boolean equalsUpdater(IPresentationUpdater updater) {
        return this.fProxy.fUpdater == updater;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PresentationUpdaterProxy
    implements IPresentationUpdater {
        private IPresentationUpdater fUpdater;
        private Boolean fVisible;
        private Boolean fRequired;

        PresentationUpdaterProxy(IPresentationUpdater updater) {
            this.fUpdater = updater;
        }

        @Override
        public void dependencyChanged(List<String> dependencies) {
            this.fUpdater.dependencyChanged(dependencies);
        }

        @Override
        public void attributeChanged(WorkItemChangeEvent event) {
            this.fUpdater.attributeChanged(event);
        }

        @Override
        public void setRequired(boolean required) {
            if (this.fRequired == null || this.fRequired != required) {
                this.fUpdater.setRequired(required);
                this.fRequired = required;
            }
        }

        @Override
        public void setStatus(IStatus status) {
            this.fUpdater.setStatus(status);
        }

        @Override
        public void setVisible(boolean visible) {
            if (this.fVisible == null || this.fVisible != visible) {
                this.fUpdater.setVisible(visible);
                this.fVisible = visible;
            }
        }
    }
}

