/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.editor.presentations.presentationhandler;

import com.ibm.team.workitem.client.WorkItemEvent;
import com.ibm.team.workitem.ide.ui.internal.WorkItemIDEUIPlugin;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.presentationhandler.EditorPresentationHandler;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.presentationhandler.IPresentationContext;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.presentationhandler.Messages;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.presentationhandler.PresentationHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PresentationHandlerRegistry {
    private static final String LIFECYCLE_CHANGE = "lifecycleChange";
    private static final String ATTRIBUTE_CHANGE = "attributeChange";
    private static final String INITIALIZATION = "initialization";
    private static final String GLOBAL_PRESENTATION_HANDLER = "globalPresentationHandler";
    private static final String PROPERTY_PRESENTATION_HANDLER = "propertyPresentationHandler";
    private static final String HANDLER_EXTENSION_POINT = "com.ibm.team.workitem.ide.ui.presentationHandler";
    private static final String KIND = "kind";
    private static final String EVENT_KIND = "eventKind";
    private static final String KEY = "key";
    private static final String PROPERTY = "property";
    private static final String CLASS = "class";
    private static final String DISPLAY_NAME = "displayName";
    private static boolean initialized = false;
    private static final Object LOCK = new Object();
    private static List<GlobalHandlerStructure> fGlobalHandlerElements = new ArrayList<GlobalHandlerStructure>();
    private static List<PropertyHandlerStructure> fPropertyHandlerElements = new ArrayList<PropertyHandlerStructure>();
    private Map<WorkItemEvent.EventKind, Map<String, PresentationHandler>> fHandlers = new HashMap<WorkItemEvent.EventKind, Map<String, PresentationHandler>>();
    private Map<WorkItemEvent.EventKind, List<EditorPresentationHandler>> fEditorHandlers = new HashMap<WorkItemEvent.EventKind, List<EditorPresentationHandler>>();
    private IPresentationContext fContext;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PresentationHandlerRegistry(IPresentationContext context) {
        Object object = LOCK;
        synchronized (object) {
            if (!initialized) {
                PresentationHandlerRegistry.initRegistry();
                initialized = true;
            }
        }
        this.fContext = context;
        this.initialize();
    }

    public static PresentationHandlerRegistry createInstance(IPresentationContext context) {
        return new PresentationHandlerRegistry(context);
    }

    private void initialize() {
        Object handler;
        for (PropertyHandlerStructure propertyHandler : fPropertyHandlerElements) {
            try {
                handler = propertyHandler.getInstance();
                ((PresentationHandler)handler).setContext(this.fContext);
                this.register((PresentationHandler)handler, propertyHandler.getEventKinds(), propertyHandler.getProperties());
            }
            catch (CoreException e) {
                WorkItemIDEUIPlugin.getDefault().log(Messages.PresentationHandlerRegistry_ERROR_CREATING_PRESENTATION_HANDLER, e);
            }
        }
        for (GlobalHandlerStructure globalHandler : fGlobalHandlerElements) {
            try {
                handler = globalHandler.getInstance();
                ((EditorPresentationHandler)handler).setContext(this.fContext);
                this.register((EditorPresentationHandler)handler, globalHandler.getEventKinds());
            }
            catch (CoreException e) {
                WorkItemIDEUIPlugin.getDefault().log(Messages.PresentationHandlerRegistry_ERROR_CREATING_PRESENTATION_HANDLER, e);
            }
        }
    }

    private void register(PresentationHandler handler, List<WorkItemEvent.EventKind> eventKinds, Collection<String> properties) {
        for (WorkItemEvent.EventKind eventKind : eventKinds) {
            if (this.fHandlers.get(eventKind) == null) {
                this.fHandlers.put(eventKind, new HashMap());
            }
            for (String property : properties) {
                this.fHandlers.get(eventKind).put(property, handler);
            }
        }
    }

    private void register(EditorPresentationHandler handler, List<WorkItemEvent.EventKind> eventKinds) {
        for (WorkItemEvent.EventKind eventKind : eventKinds) {
            if (this.fEditorHandlers.get(eventKind) == null) {
                this.fEditorHandlers.put(eventKind, new ArrayList());
            }
            this.fEditorHandlers.get(eventKind).add(handler);
        }
    }

    public List<EditorPresentationHandler> getEditorHandlers(WorkItemEvent.EventKind eventKind) {
        List<EditorPresentationHandler> handlers = this.fEditorHandlers.get(eventKind);
        if (handlers == null) {
            return Collections.emptyList();
        }
        return handlers;
    }

    public PresentationHandler getHandler(WorkItemEvent.EventKind eventKind, String identifier) {
        if (this.fHandlers.get(eventKind) != null) {
            return this.fHandlers.get(eventKind).get(identifier);
        }
        return null;
    }

    private static void initRegistry() {
        IConfigurationElement[] elements;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = elements = registry.getConfigurationElementsFor(HANDLER_EXTENSION_POINT);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (PROPERTY_PRESENTATION_HANDLER.equals(element.getName())) {
                fPropertyHandlerElements.add(new PropertyHandlerStructure(element));
            }
            if (GLOBAL_PRESENTATION_HANDLER.equals(element.getName())) {
                fGlobalHandlerElements.add(new GlobalHandlerStructure(element));
            }
            ++n2;
        }
    }

    private static WorkItemEvent.EventKind getEventKind(String kind) {
        if (INITIALIZATION.equalsIgnoreCase(kind)) {
            return WorkItemEvent.EventKind.INITIALIZATION;
        }
        if (ATTRIBUTE_CHANGE.equalsIgnoreCase(kind)) {
            return WorkItemEvent.EventKind.ATTRIBUTE_CHANGE;
        }
        if (LIFECYCLE_CHANGE.equalsIgnoreCase(kind)) {
            return WorkItemEvent.EventKind.LIFECYCLE_CHANGE;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GlobalHandlerStructure {
        List<WorkItemEvent.EventKind> fEventKinds = new ArrayList<WorkItemEvent.EventKind>();
        IConfigurationElement fElement;

        public GlobalHandlerStructure(IConfigurationElement element) {
            this.fElement = element;
            IConfigurationElement[] iConfigurationElementArray = element.getChildren(PresentationHandlerRegistry.EVENT_KIND);
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement kind = iConfigurationElementArray[n2];
                WorkItemEvent.EventKind k = PresentationHandlerRegistry.getEventKind(kind.getAttribute(PresentationHandlerRegistry.KIND));
                if (k != null) {
                    this.fEventKinds.add(k);
                }
                ++n2;
            }
        }

        public List<WorkItemEvent.EventKind> getEventKinds() {
            return this.fEventKinds;
        }

        public EditorPresentationHandler getInstance() throws CoreException {
            return (EditorPresentationHandler)this.fElement.createExecutableExtension(PresentationHandlerRegistry.CLASS);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PropertyHandlerStructure {
        Map<String, String> fProperties = new HashMap<String, String>();
        List<WorkItemEvent.EventKind> fEventKinds = new ArrayList<WorkItemEvent.EventKind>();
        IConfigurationElement fElement;

        public PropertyHandlerStructure(IConfigurationElement element) {
            this.fElement = element;
            IConfigurationElement[] iConfigurationElementArray = element.getChildren(PresentationHandlerRegistry.PROPERTY);
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement key = iConfigurationElementArray[n2];
                this.fProperties.put(key.getAttribute(PresentationHandlerRegistry.KEY), key.getAttribute(PresentationHandlerRegistry.DISPLAY_NAME));
                ++n2;
            }
            iConfigurationElementArray = element.getChildren(PresentationHandlerRegistry.EVENT_KIND);
            n = iConfigurationElementArray.length;
            n2 = 0;
            while (n2 < n) {
                IConfigurationElement kind = iConfigurationElementArray[n2];
                WorkItemEvent.EventKind k = PresentationHandlerRegistry.getEventKind(kind.getAttribute(PresentationHandlerRegistry.KIND));
                if (k != null) {
                    this.fEventKinds.add(k);
                }
                ++n2;
            }
        }

        public Collection<String> getProperties() {
            return this.fProperties.keySet();
        }

        public String getPropertyDisplayName(String property) {
            return this.fProperties.get(property);
        }

        public List<WorkItemEvent.EventKind> getEventKinds() {
            return this.fEventKinds;
        }

        public PresentationHandler getInstance() throws CoreException {
            return (PresentationHandler)this.fElement.createExecutableExtension(PresentationHandlerRegistry.CLASS);
        }
    }
}

