/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.editor.presentations;

import com.ibm.team.ui.editor.TeamFormPart;
import com.ibm.team.ui.editor.TeamFormPartContainer;
import com.ibm.team.workitem.client.internal.util.ResolvedWorkItem;
import com.ibm.team.workitem.common.internal.model.WorkItemAttributes;
import com.ibm.team.workitem.common.internal.presentations.AbstractPresentationDescriptor;
import com.ibm.team.workitem.common.internal.presentations.AttributeTypePresentationIdBindingManager;
import com.ibm.team.workitem.common.internal.presentations.PresentationDescriptor;
import com.ibm.team.workitem.common.internal.presentations.SectionDescriptor;
import com.ibm.team.workitem.common.internal.presentations.TabDescriptor;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.IAttributeHandle;
import com.ibm.team.workitem.common.model.Identifier;
import com.ibm.team.workitem.ide.ui.internal.HelpContextIds;
import com.ibm.team.workitem.ide.ui.internal.editor.HeaderSection;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemEditorInput;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemEditorParts;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemTeamFormSectionPart;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemUIWorkingCopy;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.TeamFormHeadlessSection;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.TeamFormSectionContainer;
import com.ibm.team.workitem.rcp.ui.IWorkItemUIWorkingCopy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.AbstractFormPart;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkItemEditorSections {
    private static List<String> SMALL_PRESENTATIONS = Arrays.asList("com.ibm.team.workitem.kind.string", "com.ibm.team.workitem.kind.integer", "com.ibm.team.workitem.kind.long", "com.ibm.team.workitem.kind.enumeration", "com.ibm.team.workitem.kind.timestamp", "com.ibm.team.workitem.kind.contributor", "com.ibm.team.workitem.kind.boolean", "com.ibm.team.workitem.kind.smallhtml", "com.ibm.team.workitem.kind.processArea", "com.ibm.team.workitem.kind.workItem", "com.ibm.team.workitem.kind.internal.tags", "com.ibm.team.workitem.kind.internal.target", "com.ibm.team.workitem.kind.internal.category", "com.ibm.team.workitem.kind.internal.deliverable");

    public static TeamFormSectionContainer createHeaderSection(WorkItemEditorInput editorInput, Map<String, List<AbstractPresentationDescriptor>> presentations, String headerId, IManagedForm headerForm) {
        HeaderSection headerSection = new HeaderSection(editorInput.getWorkingCopy(), presentations, headerId);
        Composite head = headerForm.getForm().getForm().getHead();
        Control headClient = TeamFormPartContainer.setup((TeamFormPartContainer)headerSection, (IManagedForm)headerForm, (Composite)head);
        headerForm.addPart((IFormPart)headerSection);
        headerForm.getForm().setHeadClient(headClient);
        HelpContextIds.hookHelpListener(headClient, "com.ibm.team.workitem.ide.ui.work_item_editor");
        return new TeamFormSectionContainer((AbstractFormPart)headerSection, headClient);
    }

    public static TeamFormSectionContainer createSection(WorkItemEditorInput editorInput, Map<String, List<AbstractPresentationDescriptor>> presentations, SectionDescriptor sectionDescriptor, IManagedForm form, Composite parent, int style) {
        List<AbstractPresentationDescriptor> descriptors;
        boolean noHeader;
        boolean bl = noHeader = sectionDescriptor.getProperties() != null && "true".equalsIgnoreCase((String)sectionDescriptor.getProperties().get("noHeader"));
        if (noHeader) {
            TeamFormHeadlessSection section = new TeamFormHeadlessSection(editorInput.getWorkingCopy(), presentations, sectionDescriptor);
            Control layoutControl = TeamFormHeadlessSection.setup((TeamFormPartContainer)section, (IManagedForm)form, (Composite)parent);
            if (section.getParts().length == 0) {
                return null;
            }
            return new TeamFormSectionContainer((AbstractFormPart)section, layoutControl);
        }
        ArrayList<TeamFormPart> parts = new ArrayList<TeamFormPart>();
        if (presentations != null && !presentations.isEmpty() && (descriptors = presentations.get(sectionDescriptor.getElementId())) != null && !descriptors.isEmpty()) {
            for (AbstractPresentationDescriptor desc : descriptors) {
                TeamFormPart part = WorkItemEditorParts.createPart(editorInput.getWorkingCopy(), desc);
                if (part == null) continue;
                parts.add(part);
            }
        }
        if (WorkItemEditorSections.isCollectorSection(sectionDescriptor)) {
            parts.addAll(WorkItemEditorSections.createCollectorParts(editorInput, presentations, sectionDescriptor));
        }
        if (parts.size() > 0) {
            WorkItemTeamFormSectionPart part = new WorkItemTeamFormSectionPart(form, parent, style |= 0x2000, sectionDescriptor.getTitle(), parts.toArray(new TeamFormPart[parts.size()]));
            return part != null ? new TeamFormSectionContainer((AbstractFormPart)part, (Control)part.getSection()) : null;
        }
        return null;
    }

    public static TeamFormSectionContainer createSection(WorkItemEditorInput editorInput, Map<String, List<AbstractPresentationDescriptor>> presentations, SectionDescriptor sectionDescriptor, IManagedForm form, int style) {
        return WorkItemEditorSections.createSection(editorInput, presentations, sectionDescriptor, form, form.getForm().getBody(), style);
    }

    public static boolean isCollectorSection(SectionDescriptor sectionDescriptor) {
        return sectionDescriptor.getProperties() != null && "true".equals(sectionDescriptor.getProperties().get("autocollect"));
    }

    private static List<TeamFormPart> createCollectorParts(WorkItemEditorInput editorInput, Map<String, List<AbstractPresentationDescriptor>> presentations, SectionDescriptor sectionDescriptor) {
        boolean widthDefined = false;
        String width = (String)sectionDescriptor.getProperties().get("width");
        widthDefined = width != null;
        boolean isSmall = false;
        if (widthDefined) {
            if ("small".equals(width)) {
                isSmall = true;
            } else if (!"wide".equals(width)) {
                widthDefined = false;
            }
        }
        WorkItemUIWorkingCopy uiCopy = (WorkItemUIWorkingCopy)editorInput.getWorkingCopy().getAdapter(IWorkItemUIWorkingCopy.class);
        ResolvedWorkItem workItem = uiCopy.getResolvedWorkItem();
        ArrayList<TeamFormPart> parts = new ArrayList<TeamFormPart>();
        for (Identifier<IAttribute> att : WorkItemEditorSections.getCollectorRelevantAttributes(editorInput, presentations)) {
            IAttribute attribute = workItem.findAttribute(att);
            if (attribute == null || attribute.isInternal() || widthDefined && isSmall != WorkItemEditorSections.isSmallPresentation(attribute)) continue;
            Map properties = Collections.emptyMap();
            TeamFormPart part = WorkItemEditorParts.createPart(editorInput.getWorkingCopy(), (AbstractPresentationDescriptor)new PresentationDescriptor(sectionDescriptor.getElementId(), null, null, att, properties));
            if (part == null) continue;
            parts.add(part);
        }
        return parts;
    }

    private static boolean isSmallPresentation(IAttribute attribute) {
        String presentation = AttributeTypePresentationIdBindingManager.getAttributeTypePresentationId((String)attribute.getAttributeType());
        return SMALL_PRESENTATIONS.contains(presentation);
    }

    public static List<Identifier<IAttribute>> getCollectorRelevantAttributes(WorkItemEditorInput editorInput, Map<String, List<AbstractPresentationDescriptor>> presentations) {
        Assert.isNotNull((Object)editorInput.getWorkingCopy());
        Assert.isNotNull(presentations);
        WorkItemUIWorkingCopy uiCopy = (WorkItemUIWorkingCopy)editorInput.getWorkingCopy().getAdapter(IWorkItemUIWorkingCopy.class);
        ResolvedWorkItem workItem = uiCopy.getResolvedWorkItem();
        ArrayList<Identifier<IAttribute>> resolvedCustoms = new ArrayList<Identifier<IAttribute>>();
        for (IAttributeHandle handle : editorInput.getWorkingCopy().getWorkItem().getCustomAttributes()) {
            for (IAttribute att : workItem.getAttributes()) {
                if (!att.getItemId().equals((Object)handle.getItemId()) || att.isInternal()) continue;
                resolvedCustoms.add((Identifier<IAttribute>)WorkItemAttributes.getPropertyIdentifier((String)att.getIdentifier()));
            }
        }
        ArrayList<Identifier> relevantIdentifiers = new ArrayList<Identifier>();
        List<AbstractPresentationDescriptor> pages = presentations.get(editorInput.getEditorPresentation().getEditorLayout());
        if (pages != null) {
            for (AbstractPresentationDescriptor desc : pages) {
                if (!(desc instanceof TabDescriptor) || presentations.get(desc.getElementId()) == null) continue;
                for (AbstractPresentationDescriptor element : presentations.get(desc.getElementId())) {
                    if (element instanceof SectionDescriptor && presentations.get(element.getElementId()) != null) {
                        for (AbstractPresentationDescriptor item : presentations.get(element.getElementId())) {
                            if (!(item instanceof PresentationDescriptor)) continue;
                            relevantIdentifiers.add(((PresentationDescriptor)item).getAttributeId());
                        }
                        continue;
                    }
                    if (!(element instanceof PresentationDescriptor)) continue;
                    relevantIdentifiers.add(((PresentationDescriptor)element).getAttributeId());
                }
            }
        }
        resolvedCustoms.removeAll(relevantIdentifiers);
        return resolvedCustoms;
    }
}

