/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.editor.presentations;

import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.ui.editor.ITeamFormLayout;
import com.ibm.team.workitem.client.WorkItemChangeEvent;
import com.ibm.team.workitem.client.WorkItemWorkingCopy;
import com.ibm.team.workitem.client.internal.WorkItemWorkingCopyImpl;
import com.ibm.team.workitem.client.internal.util.ResolvedWorkItem;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.ide.ui.internal.editor.DecoratedFormsText;
import com.ibm.team.workitem.ide.ui.internal.editor.Util;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemEditorInput;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemEditorInputFuture;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemEditorToolkit;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemUIWorkingCopy;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.AttributePart;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.RequiredPropertyLabel;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.TeamFormUtil;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.presentationhandler.AbstractPresentationUpdater;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.presentationhandler.IPresentationUpdater;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.presentationhandler.PresentationHandlerManager;
import com.ibm.team.workitem.rcp.ui.IWorkItemUIWorkingCopy;
import java.util.ArrayList;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class TextAttributePart
extends AttributePart {
    private WorkItemWorkingCopy fWorkingCopy;
    private RequiredPropertyLabel fAttributeName;
    private DecoratedFormsText fText;
    private IPresentationUpdater fPresentationUpdater = new AbstractPresentationUpdater(){

        public void setVisible(boolean visible) {
            ArrayList<Control> changedControls = new ArrayList<Control>();
            if (TextAttributePart.this.fAttributeName != null && !TextAttributePart.this.fAttributeName.isDisposed()) {
                TeamFormUtil.setVisible(TextAttributePart.this.fAttributeName.getLayoutControl(), visible);
                changedControls.add(TextAttributePart.this.fAttributeName.getLayoutControl());
            }
            if (TextAttributePart.this.fText != null && !TextAttributePart.this.fText.getLayoutControl().isDisposed()) {
                TeamFormUtil.setVisible(TextAttributePart.this.fText.getLayoutControl(), visible);
                changedControls.add(TextAttributePart.this.fText.getLayoutControl());
            }
            Util.updateFormLayout(changedControls.toArray(new Control[changedControls.size()]));
        }

        public void setRequired(boolean required) {
            if (TextAttributePart.this.fAttributeName != null && !TextAttributePart.this.fAttributeName.isDisposed()) {
                TextAttributePart.this.fAttributeName.setRequired(required);
            }
        }

        public void attributeChanged(WorkItemChangeEvent event) {
            if (TextAttributePart.this.fText != null && !TextAttributePart.this.fText.getText().isDisposed()) {
                TextAttributePart.this.handleStringChanged();
            }
        }

        public void setStatus(IStatus status) {
            if (TextAttributePart.this.fText != null && !TextAttributePart.this.fText.getLayoutControl().isDisposed()) {
                TextAttributePart.this.fText.setStatus(status);
            }
        }
    };

    public boolean stretchVertically() {
        return true;
    }

    public void createContent(ITeamFormLayout formLayout) {
        WorkItemEditorToolkit toolkit = (WorkItemEditorToolkit)this.getSite().getToolkit();
        Composite parent = formLayout.getContainer();
        if (this.isLabelVisible()) {
            this.fAttributeName = new RequiredPropertyLabel(parent, toolkit, this.getBackgroundStyle());
            formLayout.add(this.fAttributeName.getLayoutControl(), "label");
        }
        this.fText = new DecoratedFormsText(parent, this.getSite(), 578, 4, this.getBackgroundStyle());
        this.fText.setHeightHint(this.fText.getText().getLineHeight());
        Util.addWidthHint(this.fText.getLayoutControl());
        formLayout.add(this.fText.getLayoutControl(), "wideContent");
        if (this.isReadOnly()) {
            this.fText.getText().setEditable(false);
        } else {
            this.fText.getText().addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    if (TextAttributePart.this.fWorkingCopy != null && !TextAttributePart.this.fWorkingCopy.isDirty() && !TextAttributePart.this.fText.getText().getText().equals(TextAttributePart.this.getNonNullValue())) {
                        ((WorkItemWorkingCopyImpl)TextAttributePart.this.fWorkingCopy).setDirty(true);
                    }
                }
            });
            this.fText.getText().addFocusListener((FocusListener)new FocusAdapter(){

                public void focusLost(FocusEvent e) {
                    if (!TextAttributePart.this.fText.getText().equals(TextAttributePart.this.getNonNullValue()) && TextAttributePart.this.fWorkingCopy != null && TextAttributePart.this.fWorkingCopy.getWorkItem().hasAttribute(TextAttributePart.this.getAttribute())) {
                        TextAttributePart.this.fWorkingCopy.getWorkItem().setValue(TextAttributePart.this.getAttribute(), (Object)TextAttributePart.this.fText.getText().getText());
                    }
                }
            });
        }
    }

    private String getNonNullValue() {
        String value = null;
        if (this.fWorkingCopy != null && this.getAttribute() != null && this.fWorkingCopy.getWorkItem().hasAttribute(this.getAttribute())) {
            WorkItemUIWorkingCopy uiCopy = (WorkItemUIWorkingCopy)this.fWorkingCopy.getAdapter(IWorkItemUIWorkingCopy.class);
            ResolvedWorkItem workItem = uiCopy.getResolvedWorkItem();
            value = (String)workItem.getValue(this.getAttribute());
        }
        if (value == null) {
            value = "";
        }
        return value;
    }

    private void handleStringChanged() {
        String value = this.getNonNullValue();
        if (!this.fText.getText().getText().equals(value)) {
            this.fText.getText().setText(value);
        }
    }

    public void setFocus() {
        if (this.fText != null && !this.fText.getText().isDisposed()) {
            this.fText.getText().setFocus();
        }
    }

    public void setInput(Object input) {
        this.removeListeners();
        if (input instanceof WorkItemEditorInput && ((WorkItemEditorInput)((Object)input)).isResolved() && this.getAttribute() != null) {
            WorkItemEditorInput workItemEditorInput = (WorkItemEditorInput)((Object)input);
            this.fWorkingCopy = workItemEditorInput.getWorkingCopy();
            this.addListeners();
            if (this.fAttributeName != null && !this.fAttributeName.isDisposed()) {
                this.fAttributeName.setText(NLS.bind((String)ATTRNAME_COLON, (Object)this.getLabel(), (Object[])new Object[0]));
                this.fAttributeName.layout();
            }
            if (this.fText != null && !this.fText.getText().isDisposed()) {
                this.handleStringChanged();
            }
        } else if (input instanceof WorkItemEditorInputFuture) {
            this.fWorkingCopy = null;
        }
    }

    private void addListeners() {
        PresentationHandlerManager mgr;
        if (this.getSite() != null && (mgr = (PresentationHandlerManager)this.getSite().getAdapter(PresentationHandlerManager.class)) != null) {
            mgr.addPresentationUpdater(this.fPresentationUpdater, this.getDescriptor());
        }
    }

    private void removeListeners() {
        PresentationHandlerManager mgr;
        if (this.getSite() != null && (mgr = (PresentationHandlerManager)this.getSite().getAdapter(PresentationHandlerManager.class)) != null) {
            mgr.removePresentationUpdater(this.fPresentationUpdater);
        }
    }

    public void dispose() {
        this.removeListeners();
        this.fWorkingCopy = null;
        super.dispose();
    }

    public IAttribute getAttribute() {
        return this.getAttribute(this.fWorkingCopy);
    }
}

