/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.editor.presentations;

import com.ibm.team.ui.editor.ITeamFormConfiguration;
import com.ibm.team.ui.editor.ITeamFormLayout;
import com.ibm.team.ui.editor.TeamFormLayouts;
import com.ibm.team.ui.editor.TeamFormPart;
import com.ibm.team.ui.internal.editor.TeamFormLayout;
import com.ibm.team.workitem.client.WorkItemWorkingCopy;
import com.ibm.team.workitem.common.internal.presentations.AbstractPresentationDescriptor;
import com.ibm.team.workitem.common.internal.presentations.SectionDescriptor;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemEditorParts;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemTeamFormPartContainer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TeamFormHeadlessSection
extends WorkItemTeamFormPartContainer {
    private SectionDescriptor fDescriptor;
    private WorkItemWorkingCopy fWorkingCopy;
    private Map<String, List<AbstractPresentationDescriptor>> fPresentations;

    public TeamFormHeadlessSection(WorkItemWorkingCopy workingCopy, Map<String, List<AbstractPresentationDescriptor>> presentations, SectionDescriptor sectionDescriptor) {
        this.fDescriptor = sectionDescriptor;
        this.fWorkingCopy = workingCopy;
        this.fPresentations = presentations;
    }

    public void createContent(Composite parent) {
        ITeamFormLayout formLayout = TeamFormLayouts.createLayout((Composite)parent, (ITeamFormConfiguration)ITeamFormConfiguration.LABEL_CONTENT_CONFIGURATION);
        TeamFormPart[] teamFormPartArray = this.getParts();
        int n = teamFormPartArray.length;
        int n2 = 0;
        while (n2 < n) {
            TeamFormPart part = teamFormPartArray[n2];
            part.init(this.getSite());
            Control c = this.createPartContent(parent, part);
            if (c != null && c.getLayoutData() == null) {
                ((TeamFormLayout)formLayout).fill(c, part.stretchHorizontally(), part.stretchVertically());
            }
            ++n2;
        }
    }

    protected TeamFormPart[] createParts() {
        ArrayList<TeamFormPart> parts = new ArrayList<TeamFormPart>();
        List<AbstractPresentationDescriptor> descriptors = this.fPresentations.get(this.fDescriptor.getElementId());
        if (descriptors != null && !descriptors.isEmpty()) {
            for (AbstractPresentationDescriptor desc : descriptors) {
                TeamFormPart part = WorkItemEditorParts.createPart(this.fWorkingCopy, desc);
                if (part == null) continue;
                parts.add(part);
            }
        }
        return parts.toArray(new TeamFormPart[parts.size()]);
    }
}

