/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.editor.presentations;

import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.ui.editor.ITeamFormData;
import com.ibm.team.ui.editor.ITeamFormLayout;
import com.ibm.team.ui.editor.TeamFormLayouts;
import com.ibm.team.workitem.client.WorkItemChangeEvent;
import com.ibm.team.workitem.client.WorkItemWorkingCopy;
import com.ibm.team.workitem.client.internal.WorkItemWorkingCopyImpl;
import com.ibm.team.workitem.client.internal.util.ResolvedWorkItem;
import com.ibm.team.workitem.common.internal.util.SeparatedStringList;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.TagsAttributeType;
import com.ibm.team.workitem.ide.ui.internal.editor.TagsTextField;
import com.ibm.team.workitem.ide.ui.internal.editor.Util;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemEditorInput;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemEditorToolkit;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemUIWorkingCopy;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.AttributePart;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.RequiredPropertyLabel;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.TeamFormUtil;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.presentationhandler.AbstractPresentationUpdater;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.presentationhandler.IPresentationUpdater;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.presentationhandler.PresentationHandlerManager;
import com.ibm.team.workitem.rcp.ui.IWorkItemUIWorkingCopy;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TagsAttributePart
extends AttributePart {
    private WorkItemWorkingCopy fWorkingCopy;
    private Text fText;
    private TagsTextField fTagsTextField;
    private RequiredPropertyLabel fTagLabel;
    private IPresentationUpdater fPresentationUpdater = new AbstractPresentationUpdater(){

        public void setRequired(boolean required) {
            if (TagsAttributePart.this.fTagLabel != null && !TagsAttributePart.this.fTagLabel.isDisposed()) {
                TagsAttributePart.this.fTagLabel.setRequired(required);
            }
        }

        public void setStatus(IStatus status) {
            if (TagsAttributePart.this.fTagsTextField != null && !TagsAttributePart.this.fTagsTextField.getDecoratedText().getText().isDisposed()) {
                TagsAttributePart.this.fTagsTextField.getDecoratedText().setStatus(status);
            }
        }

        public void setVisible(boolean visible) {
            ArrayList<Object> changedControls = new ArrayList<Object>();
            if (TagsAttributePart.this.fTagLabel != null && !TagsAttributePart.this.fTagLabel.isDisposed()) {
                TeamFormUtil.setVisible(TagsAttributePart.this.fTagLabel.getLayoutControl(), visible);
                changedControls.add(TagsAttributePart.this.fTagLabel.getLayoutControl());
            }
            if (TagsAttributePart.this.fTagsTextField != null && !TagsAttributePart.this.fTagsTextField.getDecoratedText().getLayoutControl().isDisposed()) {
                TeamFormUtil.setVisible(TagsAttributePart.this.fTagsTextField.getDecoratedText().getLayoutControl(), visible);
                changedControls.add(TagsAttributePart.this.fTagsTextField.getDecoratedText().getLayoutControl());
            } else {
                TeamFormUtil.setVisible((Control)TagsAttributePart.this.fText, visible);
                changedControls.add(TagsAttributePart.this.fText);
            }
            Util.updateFormLayout(changedControls.toArray(new Control[changedControls.size()]));
        }

        public void attributeChanged(WorkItemChangeEvent event) {
            TagsAttributePart.this.handleTagsChanged();
        }
    };

    public void createContent(ITeamFormLayout formLayout) {
        WorkItemEditorToolkit toolkit = (WorkItemEditorToolkit)this.getSite().getToolkit();
        Composite parent = formLayout.getContainer();
        if (this.isLabelVisible()) {
            this.fTagLabel = new RequiredPropertyLabel(parent, toolkit, this.getBackgroundStyle());
            formLayout.add(this.fTagLabel.getLayoutControl(), "label");
        }
        if (this.isReadOnly()) {
            this.fText = toolkit.createReadOnlyText(parent, "", 0, this.getBackgroundStyle());
            TeamFormLayouts.setLayoutData((Control)this.fText, (ITeamFormData)ITeamFormData.SINGLE_LINE_READONLY_TEXT);
            Util.addWidthHint((Control)this.fText);
            formLayout.add((Control)this.fText, "content");
        } else {
            this.fTagsTextField = new TagsTextField(parent, this.getSite(), this.getBackgroundStyle());
            Util.addWidthHint(this.fTagsTextField.getDecoratedText().getLayoutControl());
            formLayout.add(this.fTagsTextField.getDecoratedText().getLayoutControl(), "content");
            this.fText = this.fTagsTextField.getDecoratedText().getText();
            this.fText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    if (TagsAttributePart.this.fWorkingCopy != null && !TagsAttributePart.this.fWorkingCopy.isDirty()) {
                        WorkItemUIWorkingCopy uiCopy = (WorkItemUIWorkingCopy)TagsAttributePart.this.fWorkingCopy.getAdapter(IWorkItemUIWorkingCopy.class);
                        ResolvedWorkItem workItem = uiCopy.getResolvedWorkItem();
                        if (!TagsAttributePart.this.getTags().equals(workItem.getValue(TagsAttributePart.this.getAttribute()))) {
                            ((WorkItemWorkingCopyImpl)TagsAttributePart.this.fWorkingCopy).setDirty(true);
                        }
                    }
                    TagsAttributePart.this.fText.setToolTipText(TagsAttributePart.this.fText.getText());
                }
            });
            this.fText.addFocusListener((FocusListener)new FocusAdapter(){

                public void focusLost(FocusEvent e) {
                    if (TagsAttributePart.this.fWorkingCopy == null) {
                        return;
                    }
                    TagsAttributePart.this.writeTags();
                }
            });
        }
    }

    public void commit() {
        this.writeTags();
    }

    private void handleTagsChanged() {
        if (this.fWorkingCopy == null) {
            this.fText.setText("");
        } else {
            WorkItemUIWorkingCopy uiCopy = (WorkItemUIWorkingCopy)this.fWorkingCopy.getAdapter(IWorkItemUIWorkingCopy.class);
            ResolvedWorkItem workItem = uiCopy.getResolvedWorkItem();
            Collection tags = (Collection)workItem.getValue(this.getAttribute());
            if (!this.getTags().equals(tags)) {
                this.fText.setText(SeparatedStringList.toCommaSeparatedValue((Collection)tags));
            }
        }
    }

    private void writeTags() {
        WorkItemUIWorkingCopy uiCopy = (WorkItemUIWorkingCopy)this.fWorkingCopy.getAdapter(IWorkItemUIWorkingCopy.class);
        ResolvedWorkItem workItem = uiCopy.getResolvedWorkItem();
        Collection<String> tags = this.getTags();
        if (!tags.equals(workItem.getValue(this.getAttribute()))) {
            this.fText.setText(SeparatedStringList.toCommaSeparatedValue(tags));
            this.fWorkingCopy.getWorkItem().setValue(this.getAttribute(), tags);
        }
    }

    private Collection<String> getTags() {
        String tags = TagsAttributeType.normalizeTags((String)this.fText.getText());
        return TagsAttributeType.parseTags((String)tags);
    }

    public void setFocus() {
        if (this.fText != null && !this.fText.isDisposed()) {
            this.fText.setFocus();
        }
    }

    public void setInput(Object input) {
        this.removeListeners();
        if (input instanceof WorkItemEditorInput && ((WorkItemEditorInput)((Object)input)).isResolved() && this.getAttribute() != null) {
            WorkItemEditorInput workItemEditorInput = (WorkItemEditorInput)((Object)input);
            this.fWorkingCopy = workItemEditorInput.getWorkingCopy();
            this.addListeners();
            if (this.fTagLabel != null && !this.fTagLabel.isDisposed()) {
                this.fTagLabel.setText(NLS.bind((String)ATTRNAME_COLON, (Object)this.getLabel(), (Object[])new Object[0]));
                this.fTagLabel.layout();
            }
            if (this.fTagsTextField != null) {
                this.fTagsTextField.setAttribute(this.getAttribute());
            }
            this.handleTagsChanged();
        } else {
            this.fWorkingCopy = null;
        }
    }

    private void addListeners() {
        PresentationHandlerManager mgr;
        if (this.getSite() != null && (mgr = (PresentationHandlerManager)this.getSite().getAdapter(PresentationHandlerManager.class)) != null) {
            mgr.addPresentationUpdater(this.fPresentationUpdater, this.getDescriptor());
        }
    }

    private void removeListeners() {
        PresentationHandlerManager mgr;
        if (this.getSite() != null && (mgr = (PresentationHandlerManager)this.getSite().getAdapter(PresentationHandlerManager.class)) != null) {
            mgr.removePresentationUpdater(this.fPresentationUpdater);
        }
    }

    public void dispose() {
        this.removeListeners();
        this.fWorkingCopy = null;
        super.dispose();
    }

    @Override
    public IAttribute getAttribute() {
        return this.getAttribute(this.fWorkingCopy);
    }
}

